/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.dcbu.lib.map.common.PropertyChangeListenerIf;
import com.cisco.dcbu.lib.map.common.TopologyComponentIf;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.nm.esper.lib.OwnedList;
import com.cisco.nm.esper.model.BaseObjectPainter;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.palette.EdgeLabelPalette;
import com.cisco.nm.esper.model.palette.EdgePalette;
import com.cisco.nm.esper.model.ui.DefaultEdgeLabelPainter;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class TopologyLink
extends Edge
implements TopologyComponentIf,
Serializable,
PropertyChangeListenerIf,
Comparator,
Comparable {
    public static boolean _showMinorAlarmsOnLinks = true;
    private boolean _majorFault = false;
    private boolean _minorFault = false;
    private boolean _isDashed = false;
    private boolean _isDotDotDashed = false;
    private boolean _isDotted = false;
    private Object _model = null;
    private boolean _dummy = false;
    boolean _hasDummy = false;
    private String _tooltipStr = null;
    private String _formattedTooltip = null;
    private boolean _highlight = false;
    private boolean _dimmed = false;
    boolean _rebuildDummyStatus = true;
    private EdgePalette _thisLinkPalette = null;
    private JPopupMenu _popup = null;
    private boolean _destroyed = false;
    private Color _highlightColor = Color.yellow;
    static Color _MinorFaultColor = new Color(255, 153, 51);
    static EdgePalette _linkPalette = null;
    static EdgePalette _hlLinkPalette = null;
    static EdgePalette _dimLinkPalette = null;
    public static Logger _Logger;

    public TopologyLink(TopologyNode fromNode, TopologyNode toNode) {
        super((Node)fromNode, (Node)toNode);
        this.init(fromNode, toNode);
    }

    public void destroy() {
        this._destroyed = true;
        this._tooltipStr = null;
        this._formattedTooltip = null;
        this._thisLinkPalette = null;
        this._popup = null;
    }

    public Object clone() {
        TopologyLink link = (TopologyLink)super.clone();
        link._tooltipStr = this._tooltipStr;
        link._formattedTooltip = this._formattedTooltip;
        link._highlight = this._highlight;
        link._dimmed = this._dimmed;
        link._popup = this._popup;
        link._thisLinkPalette = this._thisLinkPalette;
        return link;
    }

    @Override
    public void addAnnotation(String ann) {
        this.addLabel(ann);
    }

    @Override
    public void removeAnnotation(String ann) throws NoSuchElementException {
        this.removeLabel(ann);
    }

    @Override
    public void clearAnnotation() {
        this.clearLabels();
    }

    public void setPopup(JPopupMenu popup) {
        this._popup = popup;
    }

    public JPopupMenu getPopup() {
        return this._popup;
    }

    public void actionDoubleClick() {
        if (this.isDummyLink()) {
            try {
                ((TopologyGraph)this.getOwner()).expandSelectedMultiEdges();
            }
            catch (Exception e) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
    }

    @Override
    public String getTooltip() {
        if (this._tooltipStr == null && this.isDummyLink()) {
            ((TopologyGraph)this.getOwner()).updateDummyEdgeTooltip(this, null);
        }
        return this._tooltipStr;
    }

    String getFormattedTooltip() {
        return this._formattedTooltip;
    }

    public TopologyNode getFromNode() {
        return (TopologyNode)this.getSourceNode();
    }

    public TopologyNode getToNode() {
        return (TopologyNode)this.getTargetNode();
    }

    @Override
    public boolean isDimmed() {
        return this._dimmed;
    }

    public void setWidth(int width) {
        if (width == 1) {
            this.setEdgePalette(_linkPalette);
        } else {
            if (this._thisLinkPalette == null) {
                this._thisLinkPalette = new EdgePalette();
            }
            for (int i = 0; i <= 2; ++i) {
                this._thisLinkPalette.setArrowType(i, 0);
                this._thisLinkPalette.setStrokeWidth(i, width);
            }
            this.setEdgePalette(this._thisLinkPalette);
        }
    }

    public void addLabel(String s) {
        EdgeLabel el = new EdgeLabel(s);
        el.setDistanceFromSource(0.5);
        el.setPainter((BaseObjectPainter)DefaultEdgeLabelPainter.INSTANCE);
        this.insert(el);
    }

    public void addLabel(String s, TopologyNode n) {
        EdgeLabel el = new EdgeLabel(s);
        double d = 0.1;
        if (this.getSourceNode() != n) {
            d = 0.9;
        }
        el.setDistanceFromSource(d);
        el.setPainter((BaseObjectPainter)DefaultEdgeLabelPainter.INSTANCE);
        this.insert(el);
    }

    public void removeLabel(String s) {
        OwnedList lbls = this.labels();
        if (lbls == null) {
            return;
        }
        for (EdgeLabel l : lbls) {
            if (s != null && !s.equals("") && !s.equals(l.getText())) continue;
            this.remove(l);
        }
    }

    public void clearLabels() {
        OwnedList lbls = this.labels();
        if (lbls == null) {
            return;
        }
        Iterator itr = lbls.iterator();
        while (itr.hasNext()) {
            this.remove((EdgeLabel)itr.next());
        }
    }

    @Override
    public void setDimmed(boolean dimmed) {
        this._dimmed = dimmed;
        if (this.isDummyLink()) {
            return;
        }
        TopologyGraph g = (TopologyGraph)this.getOwner();
        if (g == null) {
            return;
        }
        TopologyLink l = g.getCollapsedLink((TopologyNode)this.getSourceNode(), (TopologyNode)this.getTargetNode());
        if (l != null) {
            if (!dimmed) {
                l._dimmed = dimmed;
                return;
            }
            ArrayList list = g.getLinks((TopologyNode)this.getSourceNode(), (TopologyNode)this.getTargetNode());
            TopologyLink tl = null;
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    tl = (TopologyLink)list.get(i);
                    if (tl._dimmed) continue;
                    return;
                }
            }
            l._dimmed = dimmed;
        }
    }

    public void dimNodes(boolean dim) {
        if (this.getSourceNode() != null) {
            ((TopologyNode)this.getSourceNode()).setDimmed(dim);
        }
        if (this.getTargetNode() != null) {
            ((TopologyNode)this.getTargetNode()).setDimmed(dim);
        }
    }

    @Override
    public boolean isHighlighted() {
        return this._highlight;
    }

    @Override
    public void setHighlighted(boolean highlight) {
        this._highlight = highlight;
        if (this.isDummyLink()) {
            return;
        }
        TopologyGraph g = (TopologyGraph)this.getOwner();
        if (g == null) {
            return;
        }
        TopologyLink cl = g.getCollapsedLink((TopologyNode)this.getSourceNode(), (TopologyNode)this.getTargetNode());
        if (cl == null) {
            return;
        }
        if (highlight) {
            cl.setHighlighted(highlight);
            return;
        }
        ArrayList list = g.getLinks((TopologyNode)this.getSourceNode(), (TopologyNode)this.getTargetNode());
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                TopologyLink l = (TopologyLink)list.get(i);
                if (!l.isHighlighted()) continue;
                return;
            }
        }
        cl.setSelected(highlight);
    }

    @Override
    public void setHighlightColor(Color color) {
        this._highlightColor = color;
    }

    @Override
    public Color getHighlightColor() {
        return this._highlightColor;
    }

    public Color getStrokeColor() {
        if (this.isDummyLink() && !this.isSelected()) {
            TopologyGraph g = (TopologyGraph)this.getOwner();
            if (g == null) {
                return super.getStrokeColor();
            }
            ArrayList list = g.getLinks((TopologyNode)this.getSourceNode(), (TopologyNode)this.getTargetNode());
            TopologyLink tl = null;
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    tl = (TopologyLink)list.get(i);
                    if (tl == null) continue;
                    return tl.getStrokeColor();
                }
            }
        }
        return super.getStrokeColor();
    }

    @Override
    public void setTooltip(String tooltip) {
        this.setFormattedTooltip(null);
        this._tooltipStr = tooltip;
    }

    public void setFormattedTooltip(String tooltip) {
        if (this._hasDummy && !this._dummy) {
            try {
                ((TopologyGraph)this.getOwner()).getCollapsedLink(this.getFromNode(), this.getToNode()).setFormattedTooltip(null);
            }
            catch (Exception e) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
        if (this._dummy) {
            this._rebuildDummyStatus = true;
            if (tooltip == null) {
                this._tooltipStr = null;
            }
        }
        this._formattedTooltip = tooltip;
    }

    public void setFromNode(TopologyNode fromNode) {
        this.setSourceNode(fromNode);
    }

    public void setToNode(TopologyNode toNode) {
        this.setTargetNode(toNode);
    }

    public String toString() {
        if (this.getSourceNode() == null || this.getTargetNode() == null) {
            if (this.getModel() != null) {
                return this.getModel().toString();
            }
            return "";
        }
        return this._tooltipStr == null ? this.getSourceNode().toString() + " <-> " + this.getTargetNode().toString() : this._tooltipStr;
    }

    protected void updateBounds2() {
        double y2;
        double y1;
        double x2;
        double x1;
        int nHL;
        int n = nHL = this.isHighlighted() ? 1 : 0;
        if (this.getSourceX() < this.getTargetX()) {
            x1 = this.getSourceX() - (double)(2 * nHL);
            x2 = this.getTargetX() + (double)(4 * nHL);
        } else {
            x1 = this.getTargetX() - (double)(2 * nHL);
            x2 = this.getSourceX() + (double)(4 * nHL);
        }
        if (this.getSourceY() < this.getTargetY()) {
            y1 = this.getSourceY() - (double)(2 * nHL);
            y2 = this.getTargetY() + (double)(4 * nHL);
        } else {
            y1 = this.getTargetY() - (double)(2 * nHL);
            y2 = this.getSourceY() + (double)(4 * nHL);
        }
        for (Bend bend : this.bends()) {
            if (bend.getLeft() < x1) {
                x1 = bend.getLeft() - (double)(2 * nHL);
            }
            if (bend.getRight() > x2) {
                x2 = bend.getRight() + (double)(4 * nHL);
            }
            if (bend.getBottom() < y1) {
                y1 = bend.getBottom() - (double)(2 * nHL);
            }
            if (!(bend.getTop() > y2)) continue;
            y2 = bend.getTop() + (double)(4 * nHL);
        }
        for (EdgeLabel label : this.labels()) {
            if (label.getLeft() < x1) {
                x1 = label.getLeft();
            }
            if (label.getRight() > x2) {
                x2 = label.getRight();
            }
            if (label.getBottom() < y1) {
                y1 = label.getBottom();
            }
            if (!(label.getTop() > y2)) continue;
            y2 = label.getTop();
        }
        this.setBounds(x1, y1, x2, y2);
    }

    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        TopologyNode node = this.getFromNode();
        if (node == null) {
            node = this.getToNode();
        }
        if (node != null && node.isGroupFilter()) {
            if (TopologyNode._GlobalGroupDimPolicy == 2) {
                TopologyGraph g;
                if (this.isDimmed() && !this.isDummyLink()) {
                    return false;
                }
                if (this.isDummyLink() && (g = (TopologyGraph)this.getOwner()) == null) {
                    return false;
                }
            }
        } else if (TopologyNode._GlobalDimPolicy == 2) {
            TopologyGraph g;
            if (this.isDimmed() && !this.isDummyLink()) {
                return false;
            }
            if (this.isDummyLink() && (g = (TopologyGraph)this.getOwner()) == null) {
                return false;
            }
        }
        return true;
    }

    public boolean isSetVisible() {
        return super.isVisible();
    }

    protected void init(TopologyNode fromNode, TopologyNode toNode) {
        if (_linkPalette == null) {
            _linkPalette = new EdgePalette();
            _hlLinkPalette = new EdgePalette();
            for (int i = 0; i <= 2; ++i) {
                _linkPalette.setArrowType(i, 0);
                _linkPalette.setStrokeWidth(i, 1);
                _hlLinkPalette.setArrowType(i, 0);
                _hlLinkPalette.setStrokeWidth(i, 2);
            }
        }
        this.setEdgePalette(_linkPalette);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TopologyLink) {
            TopologyLink link = (TopologyLink)obj;
            if (this._destroyed || link._destroyed) {
                return false;
            }
            if (obj == null || this.toString() == null) {
                return false;
            }
            return this.toString().equals(((TopologyLink)obj).toString());
        }
        return false;
    }

    public int hashCode() {
        if (this.getModel() != null) {
            return this.getModel().hashCode();
        }
        return this.toString().hashCode();
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.isDummyLink()) {
            return;
        }
        TopologyGraph g = (TopologyGraph)this.getOwner();
        if (g == null) {
            return;
        }
        TopologyLink cl = g.getCollapsedLink((TopologyNode)this.getSourceNode(), (TopologyNode)this.getTargetNode());
        if (cl == null) {
            return;
        }
        if (selected) {
            cl.setSelected(selected);
            return;
        }
        ArrayList list = g.getLinks((TopologyNode)this.getSourceNode(), (TopologyNode)this.getTargetNode());
        if (list != null) {
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                TopologyLink l = (TopologyLink)list.get(i);
                if (!l.isSelected()) continue;
                return;
            }
        }
        cl.setSelected(selected);
    }

    public void setPresent(boolean isPresent) {
        if (this._hasDummy && !this._dummy) {
            try {
                this._majorFault = !isPresent;
            }
            catch (Exception e) {
                System.err.println("...." + e.getMessage());
            }
        } else {
            this._majorFault = !isPresent;
        }
    }

    public boolean isPresent() {
        if (this._dummy && this._rebuildDummyStatus) {
            try {
                boolean all = true;
                boolean one = true;
                this._majorFault = false;
                this._minorFault = false;
                this._rebuildDummyStatus = false;
                ArrayList list = ((TopologyGraph)this.getOwner()).getLinks(this.getFromNode(), this.getToNode());
                if (list != null && list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        TopologyLink l = (TopologyLink)list.get(i);
                        if (!l.isPresent()) {
                            one = false;
                            continue;
                        }
                        if (l.hasMinorFault()) {
                            one = false;
                        }
                        all = false;
                    }
                }
                if (all) {
                    this._majorFault = true;
                } else if (!one) {
                    this._minorFault = true;
                }
            }
            catch (Exception e) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
        return !this._majorFault;
    }

    public void setMajorFault(boolean f) {
        this._majorFault = f;
    }

    public boolean hasMajorFault() {
        return !this.isPresent();
    }

    public void setMinorFault(boolean f) {
        this._minorFault = f;
    }

    public boolean hasMinorFault() {
        return this._minorFault;
    }

    public static boolean showMinorFaultOnLinks() {
        return _showMinorAlarmsOnLinks;
    }

    public void setDashed(boolean isDashed) {
        this._isDashed = isDashed;
    }

    public boolean isDashed() {
        return this._isDashed;
    }

    public void setDotDotDashed(boolean isDotDotDashed) {
        this._isDotDotDashed = isDotDotDashed;
    }

    public boolean isDotDotDashed() {
        return this._isDotDotDashed;
    }

    public boolean isDotDashed() {
        if (this.isDummyLink()) {
            TopologyGraph g = (TopologyGraph)this.getOwner();
            if (g == null) {
                return false;
            }
            ArrayList list = g.getLinks((TopologyNode)this.getSourceNode(), (TopologyNode)this.getTargetNode());
            TopologyLink tl = null;
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    tl = (TopologyLink)list.get(i);
                    if (tl.isDotDashed()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void setDotted(boolean isDotted) {
        this._isDotted = isDotted;
    }

    public boolean isDotted() {
        if (this.isDummyLink()) {
            TopologyGraph g = (TopologyGraph)this.getOwner();
            if (g == null) {
                return false;
            }
            ArrayList list = g.getLinks((TopologyNode)this.getSourceNode(), (TopologyNode)this.getTargetNode());
            TopologyLink tl = null;
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    tl = (TopologyLink)list.get(i);
                    if (tl.isDotted()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    void setDummyLink(boolean dummy) {
        this._dummy = dummy;
        if (this._dummy) {
            this._hasDummy = true;
        }
    }

    public boolean isDummyLink() {
        return this._dummy;
    }

    public boolean hasDummyLink() {
        return this._hasDummy;
    }

    @Override
    public final void setModel(Object model) {
        this._model = model;
    }

    @Override
    public final Object getModel() {
        return this._model;
    }

    @Override
    public void statusChanged(Object object, int newStatus) {
    }

    @Override
    public void nameChanged(Object object, String newName) {
        this.clearLabels();
        this.addLabel(newName);
    }

    @Override
    public void tooltipChanged(Object object, String newTooltip) {
        this._tooltipStr = newTooltip;
        this._formattedTooltip = null;
    }

    public int compare(Object l1, Object l2) {
        if (l1 == l2) {
            return 0;
        }
        if (l1 == null) {
            return -1;
        }
        if (l2 == null) {
            return 1;
        }
        return ((TopologyLink)l1).compareTo((TopologyLink)l2);
    }

    public int compareTo(Object l) {
        if (l == this) {
            return 0;
        }
        if (l == null) {
            return 1;
        }
        String s1 = this.toString();
        String s2 = ((TopologyLink)l).toString();
        if (s1 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public boolean isDestroyed() {
        return this._destroyed;
    }

    public boolean showSecuredOnLinks() {
        return true;
    }

    public boolean isSecured() {
        return false;
    }

    public boolean isSecuredEncrypted() {
        return false;
    }

    static {
        EdgeLabelPalette.INSTANCE.setFilled(false);
        EdgeLabelPalette.INSTANCE.setStroked(false);
        EdgeLabelPalette.INSTANCE.setInsets(0, 1, 0, 1);
        _Logger = Logger.getLogger(TopologyLink.class);
    }
}

