/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.map.common.TopologyNodePainter;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.Transform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;

public class TopologyLoopPainter
extends TopologyNodePainter {
    @Override
    public void paintLabels(Graphics graphics, Node node, Transform transform) {
        if (!node.isVisible()) {
            return;
        }
        super.paintLabels(graphics, node, transform);
    }

    @Override
    protected void paintDetail(Graphics2D graphics, Node n, Transform transform) {
        if (!n.isVisible()) {
            return;
        }
        TopologyNode node = (TopologyNode)n;
        Rectangle rect = this.getBounds(node, transform, RectPool.INSTANCE.checkRectOut());
        Arc2D.Float loop = new Arc2D.Float();
        Rectangle r = new Rectangle(rect);
        if (node.isHighlighted()) {
            r.x += 2;
            r.y += 2;
            r.width -= 4;
            r.height -= 4;
            loop.setArc(r, 0.0, 360.0, 1);
            BasicStroke bs = new BasicStroke(4.0f, 0, 0, 1.0f);
            graphics.setStroke(bs);
            graphics.setColor(node.getHighlightColor());
            graphics.draw(loop);
        }
        loop.setArc(r, 0.0, 360.0, 1);
        if (!node.isPresent()) {
            if (node.isDimmed()) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.red);
            }
            graphics.drawLine(r.x + 1, r.y + 1, r.x + r.width - 2, r.y + r.height - 2);
            graphics.drawLine(r.x + r.width - 2, r.y + 1, r.x + 1, r.y + r.height - 2);
        } else if (!node.isManageable()) {
            if (node.isDimmed()) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.red);
            }
            graphics.drawLine(r.x + 1, r.y + 1, r.x + r.width - 2, r.y + r.height - 2);
        } else if (node.hasMinorFault()) {
            if (node.isDimmed()) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(TopologyLink._MinorFaultColor);
            }
            graphics.drawLine(r.x + 1, r.y + 1, r.x + r.width - 2, r.y + r.height - 2);
            graphics.drawLine(r.x + r.width - 2, r.y + 1, r.x + 1, r.y + r.height - 2);
        }
        if (node.isFilled()) {
            graphics.setColor(node.getFillColor());
            graphics.fill(loop);
        }
        int thickness = transform.isForegroundScaled() ? Math.max(1, transform.widthToDevice((double)node.getStrokeWidth())) : node.getStrokeWidth();
        BasicStroke bs = new BasicStroke(thickness, 0, 0, 1.0f);
        if (node.isDimmed()) {
            graphics.setColor(Color.lightGray);
        } else {
            Color backgroundColor = TopologyGraph.getBackgroundColor();
            if (node.isSelected() && backgroundColor != null && backgroundColor.equals(Color.BLACK)) {
                graphics.setColor(Color.MAGENTA);
            } else {
                graphics.setColor(node.getStrokeColor());
            }
        }
        graphics.setStroke(bs);
        graphics.draw(loop);
        if (!node.isExpanded() && r.width >= 6) {
            r.x += 2;
            r.y += 2;
            r.width -= 4;
            r.height -= 4;
            loop.setArc(r, 0.0, 360.0, 1);
            graphics.draw(loop);
            if (r.width >= 6) {
                r.x += 2;
                r.y += 2;
                r.width -= 4;
                r.height -= 4;
                loop.setArc(r, 0.0, 360.0, 1);
                graphics.draw(loop);
            }
        }
    }

    @Override
    public Rectangle getBounds(Node n, Transform transform, Rectangle rect) {
        TopologyNode node = (TopologyNode)n;
        int nHL = 1;
        if (rect == null) {
            rect = new Rectangle();
        }
        if (!n.isVisible()) {
            rect.height = 0;
            rect.width = 0;
            rect.y = 0;
            rect.x = 0;
            return rect;
        }
        if (this.getImage(node) == null) {
            super.getBounds(node, transform, rect);
        } else {
            rect.width = this.getImageWidth();
            rect.height = this.getImageHeight();
            if (transform.isForegroundScaled()) {
                rect.width = transform.widthToDevice((double)rect.width);
                rect.height = transform.heightToDevice((double)rect.height);
            }
            rect.x = transform.xToDevice(node.getIconCenterX()) - rect.width / 2;
            rect.y = transform.yToDevice(node.getIconCenterY()) - rect.height / 2;
        }
        rect.x += rect.width / 4;
        rect.y += rect.height / 4;
        rect.width /= 2;
        rect.height /= 2;
        if (nHL > 0) {
            rect.x -= 2 * nHL;
            rect.y -= 2 * nHL;
            rect.width += 4 * nHL;
            rect.height += 4 * nHL;
        }
        return rect;
    }
}

