/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.TextDecoration;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.palette.NodeLabelPalette;
import com.cisco.nm.esper.model.ui.DefaultNodeLabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;

public class TopologyNodeLabelPainter
extends DefaultNodeLabelPainter {
    static TopologyNodeLabelPainter _Instance = null;
    static Font boldFont = new Font("sans-serif", 1, 14);

    protected void paintDetail(Graphics2D graphics, NodeLabel label, Transform transform) {
        if (label == null || !label.isVisible() || label.getOwner() == null || !label.getOwner().isVisible()) {
            return;
        }
        TopologyNode node = (TopologyNode)label.getOwner();
        if (node == null) {
            return;
        }
        TopologyGraph graph = (TopologyGraph)node.getOwner();
        if (graph == null) {
            return;
        }
        if (!node.isNodeLabelDisplayed() || !graph.isNodeLabelDisplayed()) {
            return;
        }
        Color backgroundColor = TopologyGraph.getBackgroundColor();
        Color color = null;
        Font font = null;
        NodeLabelPalette palette = (NodeLabelPalette)label.getPalette();
        if (node.isDimmed()) {
            color = palette.getPlainTextColor();
            palette.setPlainTextColor(Color.lightGray);
        } else if (backgroundColor != null && backgroundColor.equals(Color.BLACK)) {
            palette.setPlainTextColor(Color.WHITE);
        }
        if (node.isBold()) {
            font = palette.getFont();
            palette.setFont(boldFont);
        }
        super.paintDetail(graphics, label, transform);
        if (node.isDimmed()) {
            palette.setPlainTextColor(color);
        }
        if (node.isBold()) {
            palette.setFont(font);
        }
    }

    public boolean intersects(NodeLabel label, Rectangle rect, Transform transform) {
        boolean isects = false;
        if (rect != null && rect.width > 0 && rect.height > 0) {
            Rectangle bounds = this.getBounds(label, transform, null);
            isects = bounds.x > -bounds.width && bounds.y > -bounds.height && bounds.x <= rect.x + rect.width && bounds.x + bounds.width >= rect.x && bounds.y <= rect.y + rect.height && bounds.y + bounds.height >= rect.y;
        }
        return isects;
    }

    public static TopologyNodeLabelPainter getInstance() {
        if (_Instance == null) {
            _Instance = new TopologyNodeLabelPainter();
        }
        return _Instance;
    }

    public Rectangle getBounds(NodeLabel label, Transform transform, Rectangle rect) {
        if (rect == null) {
            rect = new Rectangle();
        }
        if (label == null || !label.isVisible()) {
            rect.y = 1;
            rect.x = 1;
            rect.height = 1;
            rect.width = 1;
            return rect;
        }
        TopologyNode node = (TopologyNode)label.getOwner();
        TopologyGraph g = null;
        if (node != null) {
            g = (TopologyGraph)node.getParent();
        }
        this.superGetBounds(label, transform, rect);
        if (g == null || node == null || !node.isNodeLabelDisplayed() || !g.isNodeLabelDisplayed()) {
            rect.height = 1;
            rect.width = 1;
        }
        return rect;
    }

    public Rectangle superGetBounds(NodeLabel label, Transform transform, Rectangle rect) {
        if (rect == null) {
            rect = new Rectangle();
        }
        if (label == null || !label.isVisible()) {
            rect.height = -1;
            rect.width = -1;
        } else {
            int border = 0;
            if (label.getStrokeWidth() > 0 && label.isStroked()) {
                border = label.getStrokeWidth();
                if (transform.isForegroundScaled() && border > 0) {
                    border = Math.max(1, transform.widthToDevice((double)border));
                }
            }
            Insets ins = label.getInsets();
            if (label.getTextMetrics() == null || label.getOwner() == null) {
                rect.x = transform.xToDevice(label.getLeft()) - ins.left;
                rect.y = transform.yToDevice(label.getTop()) - ins.top;
                rect.width = transform.xToDevice(label.getRight()) - rect.x + ins.right;
                rect.height = transform.yToDevice(label.getBottom()) - rect.y + ins.bottom;
                rect.grow(border + 1, border + 1);
            } else {
                int width = label.getTextMetrics().width + 2 * border + ins.left + ins.right;
                int height = label.getTextMetrics().height + 2 * border + ins.top + ins.bottom;
                Node owner = label.getOwner();
                Rectangle nodeBounds = owner.getPainter().getBounds((BaseObject)owner, transform, RectPool.INSTANCE.checkRectOut());
                rect.x = nodeBounds.x + (nodeBounds.width - width) / 2;
                rect.width = width;
                rect.height = height;
                switch (label.getLocation()) {
                    case -1: {
                        rect.y = nodeBounds.y - height;
                        break;
                    }
                    case 1: {
                        rect.y = nodeBounds.y + nodeBounds.height;
                        break;
                    }
                    case 0: {
                        rect.y = nodeBounds.y + (nodeBounds.height - height) / 2;
                    }
                }
                TopologyNode node = (TopologyNode)label.getOwner();
                int textAlignment = node.getNodePalette().getTextAlignment();
                int iconWidth = (int)node.getIconWidth();
                TextDecoration.TextMetrics metrics = label.getTextMetrics();
                TextDecoration.LineMetrics[] line = metrics.line;
                int hOffset = 0;
                switch (textAlignment) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        int w = line[0].width;
                        hOffset = rect.width - w / 2 + iconWidth / 2 + 5;
                        rect.x += hOffset;
                        break;
                    }
                    case 0: {
                        int w = line[0].width;
                        hOffset = (rect.width - w / 2 + iconWidth / 2) * -1 - 15;
                        rect.x += hOffset;
                    }
                }
                RectPool.INSTANCE.checkRectIn(nodeBounds);
            }
        }
        return rect;
    }
}

