/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.PortField;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSet;
import com.cisco.dcbu.lib.mds.PortSetCellCallbackIf;
import com.cisco.dcbu.lib.mds.PortSetEditor;
import com.cisco.dcbu.lib.mds.PortSetEditorIf;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;

public class PortSetFieldPanel
extends PortField
implements PortSetEditorIf {
    public PortSetEditor _portSetEditor;
    protected SnmpPeer _node;
    protected PortSet _selected;
    protected PortEditorFilter _filter;
    PortSetCellCallbackIf _cellCallback;
    protected PortEditorCardAttribute[] _slotMembers;
    protected int[] _logicalIfs;
    protected boolean _exclusive = false;
    protected boolean _allowNoSelectionWhenExclusive = false;
    protected boolean _allowLogicalIf = false;

    public PortSetFieldPanel(boolean exclusive, int width, PortEditorFilter filter) {
        this(exclusive, false, width, filter);
    }

    public PortSetFieldPanel(boolean exclusive, boolean allowNoSelectionWhenExclusive, int width, PortEditorFilter filter) {
        super(width);
        this._exclusive = exclusive;
        this._allowNoSelectionWhenExclusive = allowNoSelectionWhenExclusive;
        this._filter = filter;
    }

    @Override
    public void portSetEditorCB(String ifNames, Object context) {
        this.setText(ifNames);
    }

    public void setFilter(PortEditorFilter filter) {
        this._filter = filter;
    }

    public void setCellCallBack(PortSetCellCallbackIf cellCallback) {
        this._cellCallback = cellCallback;
    }

    public void updateEditor() {
        this._portSetEditor = PortSetEditor.getInstance(Util.getFrameAncestor(this));
        this._portSetEditor.setTitle(this._node.toString() + "- Select interface(s)");
        this._portSetEditor.setCellCallBack(this._cellCallback);
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(this._node.getAddress());
        this._portSetEditor.setIfIndexIf(sw);
        this._portSetEditor.setFilter(this._filter);
        try {
            this._portSetEditor.setSelected(PortSet.parse(this.getText(), this._slotMembers, new Integer[]{4}));
            this._portSetEditor.setLogicalSelected(SnmpIntList.parse(this.getText(), sw));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._portSetEditor.setSlotMembers(this._slotMembers);
        this._portSetEditor.setLogicalInterfaces(this._allowLogicalIf ? this._logicalIfs : null);
        this._portSetEditor.setExclusive(this._exclusive);
        this._portSetEditor.setAllowNoSelectionWhenExclusive(this._allowNoSelectionWhenExclusive);
        this._portSetEditor.setTarget(this);
    }

    public void setNode(SnmpPeer node) {
        this._node = node;
    }

    public void setSelected(PortSet selected) {
        this._selected = selected;
    }

    public void setSlotMembers(PortEditorCardAttribute[] slotMembers) {
        this._slotMembers = slotMembers;
    }

    public void setLogicalInterfaces(int[] logicalIfs) {
        this._logicalIfs = logicalIfs;
    }

    public void setExclusive(boolean exclusive) {
        this._exclusive = exclusive;
    }

    public void setAllowLogicalIf(boolean allowLogicalIf) {
        this._allowLogicalIf = allowLogicalIf;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateEditor();
        this._portSetEditor.showDlg((JComponent)e.getSource());
    }
}

