/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.flash;

import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class FlashUtil {
    public static final int BOOTFLASH = 1;
    public static final int SUP_LOCAL = 1;

    public static String[] getDevices(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ciscoFlashDeviceName").getOid())));
        vbl = SnmpFetch.getBulk(peer, vbl, 10).getVariables();
        String[] names = new String[vbl.size()];
        for (int i = 0; i < vbl.size(); ++i) {
            names[i] = vbl.stringValue(i);
        }
        return names;
    }

    public static String[] getPartitions(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ciscoFlashPartitionName").getOid())));
        vbl = SnmpFetch.getBulk(peer, vbl, 10).getVariables();
        String[] names = new String[vbl.size()];
        for (int i = 0; i < vbl.size(); ++i) {
            names[i] = vbl.stringValue(i);
        }
        return names;
    }

    public static String[] getFiles(SnmpPeer peer) throws SnmpException {
        return FlashUtil.getFiles(peer, 1, 1);
    }

    public static String[] getFiles(SnmpPeer peer, int device, int partition) throws SnmpException {
        int[] index = new int[]{device, partition};
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ciscoFlashFileName").getOid(), index)));
        vbl = SnmpFetch.getBulk(peer, vbl).getVariables();
        String[] names = new String[vbl.size()];
        int num = 0;
        for (int i = 0; i < names.length; ++i) {
            String f = vbl.get(i).getVar().toString();
            if (f.startsWith("/.") || f.startsWith(".") || f.endsWith("/") || f.endsWith("/.") || f.endsWith("/..")) continue;
            if (f.startsWith("/")) {
                f = f.substring(1);
            }
            if (f.indexOf("/") != -1) continue;
            names[num++] = f;
        }
        String[] vals = new String[num];
        System.arraycopy(names, 0, vals, 0, num);
        return vals;
    }

    public static JPopupMenu getFilesMenu(SnmpPeer peer, int device, int partition, ActionListener lsnr) throws SnmpException {
        String[] files = FlashUtil.getFiles(peer, device, partition);
        JPopupMenu menu = new JPopupMenu();
        JMenu currMenu = null;
        for (int i = 0; i < files.length; ++i) {
            JMenuItem mi = new JMenuItem(files[i]);
            if (currMenu != null) {
                currMenu.add(mi);
            } else {
                menu.add(mi);
            }
            int num = i + 1;
            if (num % 10 == 0 && num < files.length) {
                JMenu newMenu = new JMenu("More...");
                if (currMenu != null) {
                    currMenu.add(newMenu);
                } else {
                    menu.add(newMenu);
                }
                currMenu = newMenu;
            }
            mi.addActionListener(lsnr);
        }
        return menu;
    }

    public static void disableTerminalColor(Vsh vsh) throws IOException {
        String command = "no terminal color";
        vsh.send(command + "\n");
        vsh.learn();
        vsh.readPrompt();
    }
}

