/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Comparator;

public class VersionPeer
implements Comparator,
Comparable {
    protected SnmpPeer switchPeer;
    protected SwitchVersion version;
    protected boolean isManageble;
    protected String switchName;
    protected ZoneCapability nonIvrZoneCapability;
    protected ZoneCapability ivrZoneCapability;
    protected IfIndexIf ifIndexIf;

    public VersionPeer(SnmpPeer switchPeer, SwitchVersion version, IfIndexIf ifIndexIf, String name, boolean manageble) {
        this.switchPeer = switchPeer;
        this.version = version;
        this.switchName = name;
        this.isManageble = manageble;
        this.ifIndexIf = ifIndexIf;
    }

    public ZoneCapability getNonIvrCapability() {
        if (this.nonIvrZoneCapability == null) {
            this.nonIvrZoneCapability = new ZoneCapability(this.isMds(), this.isQuail(), this.isN5K(), this.version, false);
        }
        return this.nonIvrZoneCapability;
    }

    public ZoneCapability getIvrCapability() {
        if (this.ivrZoneCapability == null) {
            this.ivrZoneCapability = new ZoneCapability(this.isMds(), this.isQuail(), this.isN5K(), this.version, true);
        }
        return this.ivrZoneCapability;
    }

    public boolean isMds() {
        return this.ifIndexIf.isMDS();
    }

    public boolean isQuail() {
        return this.ifIndexIf.isQuail();
    }

    public SnmpPeer getSwitchPeer() {
        return this.switchPeer;
    }

    public SwitchVersion getVersion() {
        return this.version;
    }

    public boolean isN5K() {
        return this.ifIndexIf.isN5K();
    }

    public static VersionPeer findVersionPeer(ArrayList verPeers, InetAddress address) {
        for (int i = 0; i < verPeers.size(); ++i) {
            VersionPeer verPr = (VersionPeer)verPeers.get(i);
            if (!verPr.getSwitchPeer().getAddress().equals(address)) continue;
            return verPr;
        }
        return null;
    }

    public int compare(Object o1, Object o2) {
        VersionPeer sw1 = (VersionPeer)o1;
        VersionPeer sw2 = (VersionPeer)o2;
        return sw1.getSwitchPeer().compare(sw1.getSwitchPeer(), sw2.getSwitchPeer());
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.switchPeer.equals(((VersionPeer)obj).getSwitchPeer());
    }

    public static ArrayList getSnmpPeersFromVerPeers(ArrayList verPeers) {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        if (verPeers != null) {
            for (int k = 0; k < verPeers.size(); ++k) {
                peers.add(((VersionPeer)verPeers.get(k)).getSwitchPeer());
            }
        }
        return peers;
    }

    public static SnmpPeer[] getSnmpPeersFromVerPeers(VersionPeer[] verPeers) {
        SnmpPeer[] peers = new SnmpPeer[verPeers.length];
        for (int k = 0; k < verPeers.length; ++k) {
            peers[k] = verPeers[k].getSwitchPeer();
        }
        return peers;
    }

    public String toString() {
        return this.switchName != null && this.switchName.length() > 0 ? this.switchName : this.switchPeer.toString();
    }

    public String getSwitchName() {
        return this.toString();
    }

    public boolean isManageble() {
        return this.isManageble;
    }

    public IfIndexIf getIfIndexIf() {
        return this.ifIndexIf;
    }

    public void setIfIndexIf(IfIndexIf ifIndexIf) {
        this.ifIndexIf = ifIndexIf;
    }
}

