/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.util.ArrayList;

public class ZoneSet
extends AbstractZone {
    public static final String[] ZONESET_NUMBER_VARS = new String[]{"zoneEnforcedZoneSetNumber", "zoneSetNumber"};
    public static final String[] IVR_ZONESET_NUMBER_VARS = new String[]{"", "civrZoneSetNumber"};
    public static final String[] ZONESET_VARS = new String[]{"zoneSetName", "zoneSetZoneList", "zoneSetZoneListBmap4k", "zoneSetZoneListBmap6k", "zoneSetZoneListBmap8k", "zoneSetLastChange"};
    public static final String[] IVR_ZONESET_VARS = new String[]{"civrZoneSetName", "civrZoneSetZoneList", "civrZoneSetZoneExtList2kto4k", "civrZoneSetZoneExtList4kto6k", "civrZoneSetZoneExtList6kto8k", "civrZoneSetLastChange", "civrZoneSetChecksum"};
    public static final String[] ENF_ZONESET_VARS = new String[]{"zoneEnforcedZoneSetName", "zoneEnforcedZoneSetZoneList", "zoneSetEnforcedZoneListBmap4k", "zoneSetEnforcedZoneListBmap6k", "zoneSetEnforcedZoneListBmap8k", "zoneEnforcedZoneSetActivateTime"};
    public static final String[] IVR_ENF_ZONESET_VARS = new String[]{"civrZoneEnforcedZoneSetName", "civrZoneEnforcedZoneSetZoneList", "civrZoneEnforcedZoneSetZoneExtList2kto4k", "civrZoneEnforcedZoneSetZoneExtList4kto6k", "civrZoneEnforcedZoneSetZoneExtList6kto8k", "civrZoneEnforcedZoneSetActvtTime", "civrActiveZonesetChecksum"};
    public static final int ZONELIST2K = 1;
    public static final int ZONELIST4K = 2;
    public static final int ZONELIST6K = 3;
    public static final int ZONELIST8K = 4;
    public static final int ZONELISTOFFSET = 4;
    public static final int IVRZONELISTOFFSET = 4;
    public static final int ZONE_LAST_CHANGE_TIME = 5;
    public static final int[] ZONESET_ROW_STATUS_OID = MibNode.get("zoneSetRowStatus").getOid();
    public static final int[] IVR_ZONESET_ROW_STATUS_OID = MibNode.get("civrZoneSetRowStatus").getOid();
    public static final int NAME = 0;
    private byte[] members;
    private byte[] checkSum;
    private SnmpVar zoneDbEnforcedEqualsLocal;

    public ZoneSet(int vsan, int index, String name, byte[] mem, long lastModtime) {
        this.zoneIndex = index;
        this.zoneLastModtime = lastModtime;
        this.zoneVsanId = vsan;
        this.zoneName = name;
        this.members = mem;
        this.type = 4;
    }

    public byte[] getMembers() {
        return this.members;
    }

    public void setMembers(byte[] mem) {
        this.members = mem;
    }

    public String toString() {
        return this.zoneName;
    }

    @Override
    public int[] getSnmpIndex() {
        return ZoneSet.getSnmpIndex(this.zoneVsanId, this.zoneIndex);
    }

    public static int[] getSnmpIndex(int vsan, int index) {
        int[] nArray;
        if (vsan == -1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = index;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = vsan;
            nArray = nArray3;
            nArray3[1] = index;
        }
        return nArray;
    }

    public boolean isZoneMember(Zone zone) {
        return SnmpString.getBit(ZoneSet.testBit(this.members, zone.zoneIndex, false), zone.zoneIndex);
    }

    public boolean isActive(String activeZnstName) {
        if (this.zoneVsanId != -1) {
            return this.zoneName.equals(activeZnstName);
        }
        return false;
    }

    public static boolean isModifiedActive(ZoneSet active, ZoneSet target) {
        if (active == null) {
            return false;
        }
        if (active != null && target == null) {
            return true;
        }
        if (target.zoneVsanId != -1 || target.checkSum == null) {
            if (target.zoneDbEnforcedEqualsLocal != null) {
                return !target.isZoneDbEnforcedEqualsLocal();
            }
            return active.zoneLastModtime < target.zoneLastModtime;
        }
        return !SnmpString.equals(active.checkSum, target.checkSum);
    }

    public boolean isZoneDbEnforcedEqualsLocal() {
        try {
            return this.zoneDbEnforcedEqualsLocal != null && ((SnmpInt)this.zoneDbEnforcedEqualsLocal).getValue() == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ArrayList discover(CommandHandler handler, ArrayList members) throws SnmpException {
        return handler.discoverZoneSets(false, members);
    }

    public static ArrayList discoverEnforced(CommandHandler handler, ArrayList members) throws SnmpException {
        return handler.discoverZoneSets(true, members);
    }

    @Override
    public void buildTimeStampVarBind(VarBindList tmstmpVBL) {
        String[] vars = this.zoneVsanId == -1 ? IVR_ZONESET_VARS : ZONESET_VARS;
        tmstmpVBL.add(MibNode.get(vars[5]).getOid(), this.getSnmpIndex());
    }

    @Override
    public void buildLinkRemovePDU(VarBindList vbLst, Array list, ZoneCapability cap) {
        String[] vars = this.zoneVsanId == -1 ? IVR_ZONESET_VARS : ZONESET_VARS;
        byte[] memClone = new byte[this.members.length];
        System.arraycopy(this.members, 0, memClone, 0, this.members.length);
        for (int i = 0; i < list.size(); ++i) {
            AbstractZone member = (AbstractZone)list.elementAt(i);
            if (!member.isZone()) continue;
            memClone = ZoneSet.testBit(memClone, member.zoneIndex, false);
            SnmpString.clearBit(memClone, member.zoneIndex);
        }
        byte[][] segregatedMem = ZoneSet.getZonesetZoneMembersAsByteArray(memClone);
        vbLst.add(MibNode.get(vars[1]).getOid(), this.getSnmpIndex(), (SnmpVar)new SnmpString(segregatedMem[0]));
        if (cap.areMoreThan2KZonesSupported()) {
            for (int k = 1; k < segregatedMem.length; ++k) {
                if (segregatedMem[k] == null) continue;
                vbLst.add(MibNode.get(vars[k + 1]).getOid(), this.getSnmpIndex(), (SnmpVar)new SnmpString(segregatedMem[k]));
            }
        }
    }

    public byte[] duplicateZonesArray() {
        String[] vars = this.zoneVsanId == -1 ? IVR_ZONESET_VARS : ZONESET_VARS;
        byte[] memClone = new byte[]{};
        if (this.members != null && this.members.length > 0) {
            memClone = new byte[this.members.length];
            System.arraycopy(this.members, 0, memClone, 0, this.members.length);
        }
        return memClone;
    }

    @Override
    public void removeLink(AbstractZone member) {
        this.members = ZoneSet.testBit(this.members, member.zoneIndex, false);
        SnmpString.clearBit(this.members, member.zoneIndex);
    }

    public static byte[] getZoneMembersAsByteArray(Zone[] members) {
        byte[] zoneMembers = null;
        if (members != null) {
            for (int i = 0; i < members.length; ++i) {
                zoneMembers = AbstractZone.testBit(zoneMembers, members[i].getZoneIndex(), false);
                SnmpString.setBit(zoneMembers, members[i].getZoneIndex());
            }
        }
        return zoneMembers;
    }

    public static ZoneSet createNewZoneset(int vsan, Zone[] members, long sysuptime, int index, String name, CommandHandler handler) throws SnmpException {
        ZoneSet zs = new ZoneSet(vsan, index, name, null, sysuptime);
        handler.createNewZoneset(zs, members);
        zs.members = ZoneSet.getZoneMembersAsByteArray(members);
        return zs;
    }

    @Override
    public void addMembers(CommandHandler handler, AbstractZone[] az) throws SnmpException {
        handler.addMembers(this, az);
    }

    @Override
    public int[] getRowStatusOid(boolean isIvr) {
        return isIvr ? IVR_ZONESET_ROW_STATUS_OID : ZONESET_ROW_STATUS_OID;
    }

    public int findMatchMember(Zone[] zones) {
        for (int j = 0; j < zones.length; ++j) {
            if (this.members == null) {
                return -1;
            }
            if (this.zoneVsanId == -1 && zones[j].getZoneIndex() + 1 > this.members.length * 8) {
                return -1;
            }
            if (this.zoneVsanId != -1 && zones[j].getZoneIndex() > this.members.length * 8) {
                return -1;
            }
            if (!SnmpString.getBit(this.members, zones[j].getZoneIndex())) continue;
            return j;
        }
        return -1;
    }

    public void setZoneDbEnforcedEqualsLocal(SnmpVar var) {
        this.zoneDbEnforcedEqualsLocal = var;
    }

    public static ArrayList discoverZonesetName(CommandHandler handler) throws SnmpException {
        return handler.discoverZonesetName(false);
    }

    public static ZoneSet findZoneSet(CommandHandler handler, String name) throws SnmpException {
        ArrayList zonesets = ZoneSet.discoverZonesetName(handler);
        for (int z = 0; z < zonesets.size(); ++z) {
            if (!((ZoneSet)zonesets.get(z)).getZoneName().equals(name)) continue;
            return (ZoneSet)zonesets.get(z);
        }
        return null;
    }

    public byte[] getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(byte[] chkSum) {
        if (chkSum != null) {
            this.checkSum = new byte[chkSum.length];
            System.arraycopy(chkSum, 0, this.checkSum, 0, chkSum.length);
        } else {
            this.checkSum = null;
        }
    }

    @Override
    public int[] getNameOID() {
        String[] vars = this.zoneVsanId == -1 ? IVR_ZONESET_VARS : ZONESET_VARS;
        return MibNode.get(vars[0]).getOid();
    }

    public static byte[] getZonesetZoneMembers(byte[][] zonemembers) {
        if (zonemembers != null && zonemembers.length > 0) {
            byte[] mem = new byte[zonemembers.length * 256];
            for (int k = 0; k < zonemembers.length; ++k) {
                byte[] addMem = zonemembers[k];
                if (zonemembers[k] == null || zonemembers[k].length < 256) {
                    addMem = new byte[256];
                    if (zonemembers[k] != null) {
                        System.arraycopy(zonemembers[k], 0, addMem, 0, zonemembers[k].length);
                    }
                }
                System.arraycopy(addMem, 0, mem, k * 256, addMem.length);
            }
            mem = SnmpBitmap.trimTrailingZero(mem);
            return mem;
        }
        return null;
    }

    public static byte[][] getZonesetZoneMembersAsByteArray(byte[] zonemembers) {
        byte[][] mem = new byte[4][0];
        if (zonemembers != null && zonemembers.length > 0) {
            mem[0] = new byte[zonemembers.length > 256 ? 256 : zonemembers.length];
            System.arraycopy(zonemembers, 0, mem[0], 0, mem[0].length);
            mem[0] = SnmpBitmap.trimTrailingZero(mem[0]);
            if (zonemembers.length > 256) {
                mem[1] = new byte[zonemembers.length > 512 ? 256 : zonemembers.length - 256];
                System.arraycopy(zonemembers, 256, mem[1], 0, mem[1].length);
                mem[1] = SnmpBitmap.trimTrailingZero(mem[1]);
            }
            if (zonemembers.length > 512) {
                mem[2] = new byte[zonemembers.length > 768 ? 256 : zonemembers.length - 512];
                System.arraycopy(zonemembers, 512, mem[2], 0, mem[2].length);
                mem[2] = SnmpBitmap.trimTrailingZero(mem[2]);
            }
            if (zonemembers.length > 768) {
                mem[3] = new byte[zonemembers.length - 768];
                System.arraycopy(zonemembers, 768, mem[3], 0, mem[3].length);
                mem[3] = SnmpBitmap.trimTrailingZero(mem[3]);
            }
        }
        return mem;
    }
}

