/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.net;

import com.cisco.dcbu.lib.net.EZServerSocket;
import com.cisco.dcbu.lib.net.NetServiceIf;
import com.cisco.dcbu.lib.net.NetServiceListenerIf;
import com.cisco.dcbu.lib.serviceconf.AbstractService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public abstract class AbstractNetService
extends AbstractService
implements NetServiceIf,
Runnable {
    protected ThreadGroup _threadGroup = new ThreadGroup(this.getClass().getName());
    protected Thread _listenThread;
    protected EZServerSocket _servSocket;
    protected Set<Connection> _connections = new HashSet<Connection>();
    protected List<NetServiceListenerIf> _evtListeners = Collections.synchronizedList(new ArrayList());

    public AbstractNetService() {
    }

    public AbstractNetService(String name) {
        super(name);
    }

    @Override
    protected void initImpl(Object[] params) throws Exception {
        String value = this._configuration.getProperty("bindAddr");
        InetAddress[] bindAddrs = EZServerSocket.parseHostnames(value);
        int port = 0;
        value = this._configuration.getProperty("bindPort");
        if (value != null && value.length() != 0) {
            port = Integer.parseInt(value);
        }
        this._servSocket = new EZServerSocket(port, 50, bindAddrs);
        this._servSocket.setSoTimeout(600000);
        this._listenThread = new Thread(this._threadGroup, this, this.getName() + ":" + this._servSocket.getInetAddress().getHostAddress() + ":" + this._servSocket.getLocalPort());
    }

    @Override
    protected void startImpl() throws Exception {
        this._listenThread.start();
    }

    @Override
    protected void stopImpl() {
        this._listenThread.interrupt();
        for (Connection conn : this._connections) {
            conn.close();
        }
        this._connections.clear();
        this._connections = null;
    }

    @Override
    public void run() {
        while (this._state.get() != 1) {
            try {
                Socket client = this._servSocket.accept();
                if (this._state.get() == 4 && this.handshake(client)) {
                    this.addConnection(client);
                    continue;
                }
                client.close();
            }
            catch (InterruptedIOException ie) {
                if (this._state.get() != 1) continue;
                break;
            }
            catch (IOException ioe) {
                if (this._state.get() == 1) continue;
                this._log.log((Priority)Level.ERROR, (Object)(this.getName() + "::run()"), (Throwable)ioe);
            }
        }
        try {
            this._servSocket.close();
        }
        catch (IOException ioe) {
            this._log.error((Object)("Closing socket failed: " + ioe.getMessage()));
        }
        this._servSocket = null;
        this._listenThread = null;
    }

    @Override
    public String info() {
        StringBuffer sb = new StringBuffer(this.getName());
        if (this._servSocket != null) {
            sb.append(":").append(this._servSocket.getInetAddress().getHostAddress()).append(":").append(this._servSocket.getLocalPort()).append("\n");
        }
        sb.append(this._connections.size()).append(" connections\n");
        Iterator<Connection> it = this._connections.iterator();
        while (it.hasNext()) {
            sb.append("\t").append(it.next()).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getName() + (this._servSocket != null ? ":" + this._servSocket.getInetAddress().getHostAddress() + ":" + this._servSocket.getLocalPort() : "");
    }

    @Override
    public boolean handshake(Socket s) {
        return true;
    }

    @Override
    public void addListener(NetServiceListenerIf lis) {
        this._evtListeners.add(lis);
    }

    @Override
    public void removeListener(NetServiceListenerIf lis) {
        this._evtListeners.remove(lis);
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        if (this._servSocket != null) {
            if (this._servSocket.getInetAddress().isAnyLocalAddress()) {
                try {
                    return new InetSocketAddress(InetAddress.getLocalHost(), this._servSocket.getLocalPort());
                }
                catch (UnknownHostException uhe) {
                    return null;
                }
            }
            return (InetSocketAddress)this._servSocket.getLocalSocketAddress();
        }
        return null;
    }

    protected synchronized void addConnection(Socket client) {
        int maxConn;
        String value = this._configuration.getProperty("maxConn");
        int n = maxConn = value != null ? Integer.parseInt(value) : 0;
        if (maxConn == 0 || this._connections.size() < maxConn) {
            Connection conn = new Connection(client);
            this._connections.add(conn);
            conn.start();
            this.connectionEstablished(client.getInetAddress(), client.getPort());
            this._log.info((Object)(conn + " established"));
        } else {
            try {
                PrintWriter out = new PrintWriter(client.getOutputStream(), true);
                out.println("Connection refused: the server is busy; please try again later.");
                client.close();
                this._log.trace((Object)(this.getName() + " connection refused to " + client.getInetAddress().getHostAddress() + ":" + client.getPort() + ": max connection reached."));
            }
            catch (IOException ioe) {
                this._log.log((Priority)Level.ERROR, (Object)(this.getName() + " add connection failed"), (Throwable)ioe);
            }
        }
    }

    protected synchronized void endConnection(Connection conn) {
        this._connections.remove(conn);
        this.connectionLost(conn._client.getInetAddress(), conn._client.getPort());
        this._log.info((Object)(conn + " closed."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionLost(InetAddress addr, int port) {
        List<NetServiceListenerIf> list = this._evtListeners;
        synchronized (list) {
            for (NetServiceListenerIf lis : this._evtListeners) {
                try {
                    lis.connectionEstablished(addr, port);
                }
                catch (Exception ex) {
                    this._log.log((Priority)Level.TRACE, (Object)(this.getName() + "::notifyConnectionLost"), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionEstablished(InetAddress addr, int port) {
        List<NetServiceListenerIf> list = this._evtListeners;
        synchronized (list) {
            for (NetServiceListenerIf lis : this._evtListeners) {
                try {
                    lis.connectionEstablished(addr, port);
                }
                catch (Exception ex) {
                    this._log.log((Priority)Level.TRACE, (Object)(this.getName() + "::notifyConnectionEstablished"), (Throwable)ex);
                }
            }
        }
    }

    class Connection
    extends Thread {
        final Socket _client;
        volatile boolean _close;

        public Connection(Socket client) {
            super(AbstractNetService.this.getName() + ": connection " + client.getInetAddress().getHostAddress() + ":" + client.getPort());
            this._close = false;
            this._client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AbstractNetService.this.serve(this._client);
            }
            catch (IOException ioe) {
                if (!this._close) {
                    AbstractNetService.this._log.log((Priority)Level.FATAL, (Object)(this.getName() + "::run()"), (Throwable)ioe);
                }
            }
            finally {
                AbstractNetService.this.endConnection(this);
            }
        }

        public void close() {
            this._close = true;
            this.interrupt();
            try {
                this._client.close();
            }
            catch (IOException ioe) {
                AbstractNetService.this._log.error((Object)("closing connection error: " + ioe));
            }
        }

        @Override
        public String toString() {
            return AbstractNetService.this.getName() + ": connection " + this._client.getLocalAddress().getHostAddress() + ":" + this._client.getLocalPort() + " -> " + this._client.getInetAddress().getHostAddress() + ":" + this._client.getPort();
        }
    }
}

