/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.rmi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class ClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    static final long serialVersionUID = 2L;
    static Logger _Log = Logger.getLogger(ClientSocketFactory.class);
    public static final String PROP_STARTPORT = "client.portStart";
    public static final String PROP_ENDPORT = "client.portEnd";
    private static int _hashCode = ClientSocketFactory.class.getName().hashCode();
    private static String _ProxyServer = null;
    private String _serverHost = null;
    private int _serverPort = 0;
    private boolean _useSsl = Boolean.getBoolean("server.useSsl");
    private transient int _localStartPort = 0;
    private transient int _localEndPort = 0;

    public ClientSocketFactory() {
        this(0);
    }

    public ClientSocketFactory(int serverPort) {
        this(System.getProperty("java.rmi.server.hostname"), serverPort);
    }

    public ClientSocketFactory(String serverHost, int serverPort) {
        if (serverHost != null && serverHost.length() != 0) {
            this._serverHost = serverHost;
        }
        this._serverPort = serverPort < 0 ? 0 : serverPort;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        int max;
        String rhost = _ProxyServer != null ? _ProxyServer : (this._serverHost != null ? this._serverHost : host);
        int rport = this._serverPort != 0 ? this._serverPort : port;
        SocketFactory sf = this._useSsl ? SSLSocketFactory.getDefault() : SocketFactory.getDefault();
        _Log.debug((Object)("creating socket to " + rhost + ":" + rport + " useSSl: " + this._useSsl));
        IOException ioe = null;
        int n = max = this._localStartPort == 0 ? 0 : this._localEndPort;
        for (int lport = this._localStartPort; lport <= max; ++lport) {
            try {
                Socket sock = sf.createSocket(rhost, rport, null, lport);
                _Log.debug((Object)("socket created on " + sock.getLocalAddress().getHostAddress() + ":" + sock.getLocalPort() + " to " + sock.getInetAddress().getHostAddress() + ":" + sock.getPort()));
                return sock;
            }
            catch (IOException ex) {
                ioe = ex;
                _Log.info((Object)("creating socket on " + lport + " to " + rhost + ":" + rport + " error: " + ex));
                continue;
            }
        }
        throw ioe;
    }

    public void setServerHost(String host) {
        this._serverHost = host;
    }

    public void setServerPort(int port) {
        this._serverPort = port;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._localStartPort = Integer.getInteger(PROP_STARTPORT, 0);
        this._localEndPort = Integer.getInteger(PROP_ENDPORT, 0);
        if (this._localEndPort < this._localStartPort) {
            this._localEndPort = this._localStartPort;
        }
    }

    public boolean equals(Object object) {
        return object instanceof ClientSocketFactory;
    }

    public int hashCode() {
        return _hashCode;
    }

    public static String getProxyServer() {
        return _ProxyServer;
    }

    public static void setProxyServer(String proxyhost) {
        _ProxyServer = proxyhost;
    }

    static boolean isLoopbackAddress(String host) {
        try {
            return InetAddress.getByName(host).isLoopbackAddress();
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }
}

