/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.PduComparer;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetchIf;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntArray;
import java.util.Arrays;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SnmpFetch
implements SnmpCallbackIf {
    public static int _Max = Integer.getInteger("snmp.maxvarbind", 24);
    public static int _noOfVars;
    static final int MAX_BYTES_PER_GETBACK_PDU = 1500;
    static final int DEFAULT_STRING_LEN = 16;
    static final int DEFAULT_FRGMENT_LEN = 96;
    private SnmpCallbackIf _target;
    private int _pending;
    private VarBindList _response;
    private boolean _timedOut;
    private byte _state;
    private int _numVar;
    private VarBindList _reqVariables;
    private int[] _request;
    private int[] _startIndex;
    private int[] _stopIndex = null;
    private SnmpPDU[] _getResponse;
    private int _getResponseCount;
    private Logger _log;
    private static SnmpFetchIf _snmpFetchCb;
    public final int ROUNDTRIPDELAY_UNDEFINED = -1;

    public SnmpFetch() {
        _noOfVars = Integer.getInteger("snmp.pmVarBinPerPdu", 24);
    }

    public SnmpFetch(Logger log) {
        this();
        this._log = log;
    }

    public Logger getLogger() {
        return this._log;
    }

    public void setLogger(Logger log) {
        this._log = log;
    }

    public static SnmpPDU getFrag(SnmpPeer peer, VarBindList vbl) throws SnmpException {
        return SnmpFetch.opFrag((byte)-96, peer, new SnmpPDU(-96, vbl));
    }

    static SnmpPDU setFrag(SnmpPeer peer, SnmpPDU pdu) throws SnmpException {
        return SnmpFetch.opFrag((byte)-93, peer, pdu);
    }

    private static SnmpPDU opFrag(byte op, SnmpPeer peer, SnmpPDU pdu) throws SnmpException {
        VarBindList vbl = pdu.getVariables();
        Array<SnmpPDU> pdus = SnmpFetch.fragment(vbl, op);
        VarBindList response = new VarBindList();
        SnmpPDU resp = null;
        SnmpPDU firstPDU = pdus.elementAt(0);
        for (int i = 0; i < pdus.size(); ++i) {
            try {
                SnmpPDU reqPdu = pdus.elementAt(i);
                if (pdu._log != null) {
                    reqPdu.setLogger(pdu._log);
                }
                resp = peer.send(reqPdu);
            }
            catch (SnmpException ex) {
                pdu.setReqid(firstPDU.getReqid());
                throw ex;
            }
            for (int j = 0; j < resp.getVariables().size(); ++j) {
                response.add(resp.getVariables().getVb(j));
            }
        }
        if (resp != null) {
            resp.setVariables(response);
            resp.setReqid(firstPDU.getReqid());
        }
        return resp;
    }

    public int get(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, int retries) throws SnmpException {
        return this.get(peer, vbl, target, (byte)-96, retries);
    }

    public int get(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target) throws SnmpException {
        return this.get(peer, vbl, target, (byte)-96, -1);
    }

    public int getWithFixedRoundTripDelay(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, int roundTripDelay) throws SnmpException {
        return this.get(peer, vbl, target, (byte)-96, -1, -1, roundTripDelay);
    }

    public void getNext(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target) throws SnmpException {
        this.get(peer, vbl, target, (byte)-95, -1);
    }

    public void getWithTimeOut(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, int timeout) throws SnmpException {
        this.get(peer, vbl, target, (byte)-96, -1, timeout);
    }

    public void getWithTimeOutOpt(SnmpPeer peer, Array<SnmpPDU> pdus, SnmpCallbackIf target, int retries, int timeout) throws SnmpException {
        this.getOpt(peer, pdus, target, (byte)-96, retries, timeout);
    }

    public void getWithTimeOutOpt(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, int retries, int timeout) throws SnmpException {
        this.getOpt(peer, vbl, target, (byte)-96, retries, timeout);
    }

    private int get(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, byte op, int retries) throws SnmpException {
        return this.get(peer, vbl, target, op, retries, -1);
    }

    private int get(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, byte op, int retries, int timeout) throws SnmpException {
        return this.get(peer, vbl, target, op, retries, timeout, -1);
    }

    public int get(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, byte op, int retries, int timeout, int roundTripDelay) throws SnmpException {
        Array<SnmpPDU> pdus = SnmpFetch.fragment(vbl, op);
        this._state = op;
        this._target = target;
        this._pending = pdus.size();
        this._timedOut = false;
        this._getResponse = new SnmpPDU[this._pending];
        this._getResponseCount = 0;
        int reqid = 0;
        if (roundTripDelay == -1) {
            roundTripDelay = peer.getSleeptimeForSegments();
        }
        for (int i = 0; i < pdus.size(); ++i) {
            if (i > 0 && roundTripDelay > 0) {
                try {
                    Thread.sleep(roundTripDelay / 2);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            SnmpPDU pdu = pdus.elementAt(i);
            pdu.setTimeout(timeout);
            pdu.setRetries(retries);
            if (this._log != null) {
                pdu.setLogger(this._log);
            } else if (peer.getLogger() != null) {
                pdu.setLogger(peer.getLogger());
            }
            reqid = peer.send(pdus.elementAt(i), this);
        }
        return reqid;
    }

    private int getOpt(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, byte op, int retries, int timeout) throws SnmpException {
        Array<SnmpPDU> pdus = SnmpFetch.fragmentOpt(vbl, op);
        this._state = op;
        this._target = target;
        this._pending = pdus.size();
        this._timedOut = false;
        this._getResponse = new SnmpPDU[this._pending];
        this._getResponseCount = 0;
        int reqid = 0;
        int roundTripDelay = peer.getSleeptimeForSegments();
        for (int i = 0; i < pdus.size(); ++i) {
            if (i > 0 && roundTripDelay > 0) {
                try {
                    Thread.sleep(roundTripDelay / 2);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            SnmpPDU pdu = pdus.elementAt(i);
            pdu.setTimeout(timeout);
            pdu.setRetries(retries);
            if (this._log != null) {
                pdu.setLogger(this._log);
            }
            reqid = peer.send(pdus.elementAt(i), this);
        }
        return reqid;
    }

    private int getOpt(SnmpPeer peer, Array<SnmpPDU> pdus, SnmpCallbackIf target, byte op, int retries, int timeout) throws SnmpException {
        this._state = op;
        this._target = target;
        this._pending = pdus.size();
        this._timedOut = false;
        this._getResponse = new SnmpPDU[this._pending];
        this._getResponseCount = 0;
        int reqid = 0;
        int roundTripDelay = peer.getSleeptimeForSegments();
        for (int i = 0; i < pdus.size(); ++i) {
            if (i > 0 && roundTripDelay > 0) {
                try {
                    Thread.sleep(roundTripDelay / 2);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            SnmpPDU pdu = pdus.elementAt(i);
            pdu.setTimeout(timeout);
            pdu.setRetries(retries);
            if (this._log != null) {
                pdu.setLogger(this._log);
            }
            reqid = peer.send(pdus.elementAt(i), this);
        }
        return reqid;
    }

    public static Array<SnmpPDU> fragment(VarBindList vbl, byte op) {
        Array<SnmpPDU> pdus = new Array<SnmpPDU>();
        SnmpFetch.addPdu(pdus, vbl, 0, vbl.size(), op);
        return pdus;
    }

    public static Array<SnmpPDU> fragmentOpt(VarBindList vbl, byte op) {
        Array<SnmpPDU> pdus = new Array<SnmpPDU>();
        SnmpFetch.addPduOpt(pdus, vbl, 0, vbl.size(), op);
        return pdus;
    }

    private static void addPdu(Array<SnmpPDU> pdus, VarBindList vbl, int from, int to, byte op) {
        int nVars = to - from;
        int numPdus = nVars / _Max;
        if (nVars % _Max > 0) {
            ++numPdus;
        }
        int vNo = from;
        for (int i = 0; i < numPdus; ++i) {
            VarBindList pduVbl = new VarBindList();
            int max = vNo + _Max;
            if (max > to) {
                max = to;
            }
            while (vNo < max) {
                pduVbl.add(vbl.get(vNo++));
            }
            SnmpPDU pdu = new SnmpPDU(op, pduVbl);
            pdus.addElement(pdu);
        }
    }

    private static void addPduOpt(Array<SnmpPDU> pdus, VarBindList vbl, int from, int to, byte op) {
        int nVars = to - from;
        int numPdus = nVars / _noOfVars;
        if (nVars % _noOfVars > 0) {
            ++numPdus;
        }
        int vNo = from;
        SnmpVarBind vb = null;
        for (int i = 0; i < numPdus; ++i) {
            VarBindList pduVbl = new VarBindList();
            int max = vNo + _noOfVars;
            if (max > to) {
                max = to;
            }
            while (vNo < max) {
                vb = vbl.get(vNo++);
                pduVbl.add(vb);
            }
            SnmpPDU pdu = new SnmpPDU(op, pduVbl);
            pdus.addElement(pdu);
        }
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (this._state == -96 || this._state == -95) {
            --this._pending;
            if (timedOut) {
                this._timedOut = true;
            } else if (!this._timedOut && this._getResponseCount < this._getResponse.length) {
                this._getResponse[this._getResponseCount++] = pdu;
            }
            if (this._pending == 0) {
                if (!this._timedOut && this._getResponse.length > 1) {
                    pdu = SnmpFetch.sortResponses(this._getResponse, this._getResponseCount);
                }
                this._target.callback(session, reqid, pdu, this._timedOut);
            }
        } else if (this._state == -91) {
            if (!timedOut) {
                VarBindList bVbl = pdu.getVariables();
                boolean isEnd = SnmpFetch.trimBulkResponse(bVbl, this._numVar, this._request, this._startIndex, this._stopIndex);
                if (bVbl.size() > 0) {
                    this._response.addAll(bVbl);
                }
                if (!isEnd) {
                    pdu.setVariables(new VarBindList());
                    pdu.reset();
                    pdu.setCommand((byte)-91);
                    pdu.setMaxRptr(_Max / this._numVar);
                    int max = bVbl.size();
                    for (int i = max - this._numVar; i < max; ++i) {
                        SnmpVarBind vb = bVbl.getVb(i);
                        pdu.addVar(new SnmpVarBind(vb.getOid()));
                    }
                    try {
                        SnmpPeer peer = pdu._peer;
                        if (peer == null) {
                            SnmpPeer.findPeer(pdu.getAddress());
                        }
                        peer.setup(pdu);
                        session.send(pdu, this);
                        return;
                    }
                    catch (SnmpException ex) {
                        pdu.getLogger().log((Priority)Level.ERROR, (Object)"SnmpFetch::callback() error", (Throwable)ex);
                    }
                }
            }
            pdu.setVariables(this._response.size() != 0 ? this._response : pdu.getVariables());
            this._target.callback(session, reqid, pdu, timedOut);
        } else if (this._state == -76) {
            if (!timedOut) {
                VarBindList bVbl = pdu.getVariables();
                boolean isEnd = SnmpFetch.trimBulkResponse(bVbl, this._numVar, this._request, this._startIndex, this._stopIndex);
                if (bVbl.size() > 0) {
                    this._response.addAll(bVbl);
                }
                if (!isEnd) {
                    VarBindList rVbl = this._reqVariables;
                    pdu.setVariables(new VarBindList());
                    pdu.reset();
                    pdu.setCommand((byte)-76);
                    pdu.setMaxRptr(2 * _Max / this._numVar);
                    int max = bVbl.size();
                    int i = max - this._numVar / 2;
                    for (int j = 1; i < max && j < this._numVar; ++i, j += 2) {
                        SnmpVarBind vb = bVbl.getVb(i);
                        SnmpVarBind vbr = rVbl.getVb(j);
                        pdu.addVar(new SnmpVarBind(vb.getOid()));
                        pdu.addVar(new SnmpVarBind(vbr.getOid()));
                    }
                    try {
                        SnmpPeer peer = pdu._peer;
                        if (peer == null) {
                            SnmpPeer.findPeer(pdu.getAddress());
                        }
                        peer.setup(pdu);
                        session.send(pdu, this);
                        return;
                    }
                    catch (SnmpException ex) {
                        pdu.getLogger().log((Priority)Level.ERROR, (Object)"SnmpFetch::callback() error", (Throwable)ex);
                    }
                }
            }
            pdu.setVariables(this._response.size() != 0 ? this._response : pdu.getVariables());
            this._target.callback(session, reqid, pdu, timedOut);
        }
    }

    public static SnmpPDU sortResponses(SnmpPDU[] responses) {
        return SnmpFetch.sortResponses(responses, responses.length);
    }

    public static SnmpPDU sortResponses(SnmpPDU[] responses, int toIdx) {
        int nOfPDUs = responses.length;
        Arrays.sort(responses, 0, toIdx, new PduComparer());
        int size = 0;
        for (int i = 0; i < nOfPDUs; ++i) {
            size += responses[i].getVariables().size();
        }
        VarBindList varBindList = new VarBindList(size);
        for (int i = 0; i < responses.length; ++i) {
            VarBindList vbl = responses[i].getVariables();
            size = vbl.size();
            for (int j = 0; j < size; ++j) {
                varBindList.add(vbl.getVb(j));
            }
        }
        SnmpPDU pdu = responses[nOfPDUs - 1];
        pdu.setVariables(varBindList);
        return pdu;
    }

    public static SnmpPDU get(SnmpPeer peer, VarBindList vbl) throws SnmpException {
        return SnmpFetch.send(peer, vbl, (byte)-96, _Max, true);
    }

    public static SnmpPDU get(SnmpPeer peer, VarBindList vbl, int max) throws SnmpException {
        return SnmpFetch.send(peer, vbl, (byte)-96, max, true);
    }

    public static SnmpPDU next(SnmpPeer peer, VarBindList vbl) throws SnmpException {
        return SnmpFetch.send(peer, vbl, (byte)-95, _Max, true);
    }

    public static SnmpPDU set(SnmpPeer peer, VarBindList vbl) throws SnmpException {
        return SnmpFetch.send(peer, vbl, (byte)-93, _Max, false);
    }

    public static SnmpPDU set(SnmpPeer peer, VarBindList vbl, boolean ignoreSetCount) throws SnmpException {
        return SnmpFetch.send(peer, vbl, (byte)-93, _Max, ignoreSetCount);
    }

    public static SnmpPDU set(SnmpPeer peer, SnmpPDU pdu) throws SnmpException {
        return SnmpFetch.send(peer, pdu.getVariables(), (byte)-93, _Max, false, pdu.getTimeout());
    }

    public static SnmpPDU set(SnmpPeer peer, SnmpPDU pdu, boolean ignoreSetCount) throws SnmpException {
        return SnmpFetch.send(peer, pdu.getVariables(), (byte)-93, _Max, ignoreSetCount);
    }

    private static SnmpPDU send(SnmpPeer peer, VarBindList vbl, byte command, int maxVbl, boolean ignoreSetCount) throws SnmpException {
        return SnmpFetch.send(peer, vbl, command, maxVbl, ignoreSetCount, -1);
    }

    private static SnmpPDU send(SnmpPeer peer, VarBindList vbl, byte command, int maxVbl, boolean ignoreSetCount, int pduTimeout) throws SnmpException {
        SnmpPDU resp = null;
        VarBindList response = new VarBindList();
        int numPdus = vbl.size() / maxVbl;
        if (vbl.size() % maxVbl > 0) {
            ++numPdus;
        }
        int vNo = 0;
        for (int i = 0; i < numPdus; ++i) {
            VarBindList pduVbl = new VarBindList();
            int max = vNo + maxVbl;
            if (max > vbl.size()) {
                max = vbl.size();
            }
            while (vNo < max) {
                pduVbl.add(vbl.get(vNo++));
            }
            SnmpPDU pdu = new SnmpPDU(command, pduVbl);
            if (command == -93) {
                pdu.setIgnoreSetCount(ignoreSetCount);
            }
            if (peer.getLogger() != null) {
                pdu.setLogger(peer.getLogger());
            }
            pdu.setTimeout(pduTimeout > peer.getTimeout() ? pduTimeout : peer.getTimeout());
            try {
                resp = peer.send(pdu);
            }
            catch (SnmpException ex) {
                if (command == -93) {
                    if (pdu._response != null) {
                        if (pdu.getVariables().size() > 1 && pdu._response.getErrorIndex() > 0) {
                            SnmpOID o = pdu.getVariables().getVb(pdu._response.getErrorIndex() - 1).getOid();
                            String mibName = MibNode.oidToName(o.getValue());
                            throw new SnmpException(peer.getSnmpErrorDetail(ex.getMessage(), pdu._response) + "- " + pdu._response.getPeer() + " " + mibName, pdu._response.getErrorIndex());
                        }
                        throw new SnmpException(peer.getSnmpErrorDetail(ex.getMessage(), pdu._response));
                    }
                    throw ex;
                }
                throw ex;
            }
            for (int j = 0; j < resp.getVariables().size(); ++j) {
                response.add(resp.getVariables().getVb(j));
            }
        }
        if (resp != null) {
            resp.setVariables(response);
        }
        return resp;
    }

    public int getBulk(SnmpPeer peer, String[] mibVar, SnmpCallbackIf target) throws SnmpException {
        VarBindList vbl = new VarBindList(mibVar.length);
        for (int i = 0; i < mibVar.length; ++i) {
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get(mibVar[i]).getOid())));
        }
        return this.getBulk(peer, vbl, target);
    }

    public int getBulk(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, int retries, int timeout) throws SnmpException {
        return this.getBulk(peer, vbl, _Max / vbl.size(), target, retries, timeout);
    }

    public int getBulk(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, int retries) throws SnmpException {
        return this.getBulk(peer, vbl, _Max / vbl.size(), target, retries);
    }

    public int getBulk(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target) throws SnmpException {
        return this.getBulk(peer, vbl, _Max / vbl.size(), target, -1);
    }

    public int getBulk(SnmpPeer peer, String[] mibVar, int[] startIndex, int stopIndex, SnmpCallbackIf target) throws SnmpException {
        return this.getBulk(peer, mibVar, startIndex, new int[]{stopIndex}, target);
    }

    public int getBulk(SnmpPeer peer, String[] mibVar, int[] startIndex, int[] stopIndex, SnmpCallbackIf target) throws SnmpException {
        VarBindList vbl = new VarBindList(mibVar.length);
        for (int i = 0; i < mibVar.length; ++i) {
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get(mibVar[i]).getOid(), startIndex)));
        }
        this._startIndex = startIndex;
        this._stopIndex = stopIndex;
        return this.getBulk(peer, vbl, target);
    }

    public int getBulk(SnmpPeer peer, VarBindList vbl, int[] startIndex, int[] stopIndex, SnmpCallbackIf target) throws SnmpException {
        this._startIndex = startIndex;
        this._stopIndex = stopIndex;
        return this.getBulk(peer, vbl, target);
    }

    public int getBulk(SnmpPeer peer, VarBindList vbl, int maxRptr, SnmpCallbackIf target) throws SnmpException {
        return this.getBulk(peer, vbl, maxRptr, target, -1);
    }

    public int getBulk(SnmpPeer peer, VarBindList vbl, int maxRptr, SnmpCallbackIf target, int retries) throws SnmpException {
        return this.getBulk(peer, vbl, maxRptr, target, retries, -1);
    }

    public int getBulk(SnmpPeer peer, VarBindList vbl, int maxRptr, SnmpCallbackIf target, int retries, int timeout) throws SnmpException {
        this._state = (byte)-91;
        this._target = target;
        this._numVar = vbl.size();
        if (this._startIndex == null) {
            this._request = vbl.getVb(0).getOid().getValue();
        } else {
            int[] firstVbOid = vbl.getVb(0).getOid().getValue();
            int firstMibOidLen = firstVbOid.length - this._startIndex.length;
            this._request = new int[firstMibOidLen];
            System.arraycopy(firstVbOid, 0, this._request, 0, firstMibOidLen);
        }
        this._response = new VarBindList();
        SnmpPDU pdu = new SnmpPDU(-91, vbl);
        pdu.setMaxRptr(maxRptr);
        pdu.setRetries(retries);
        if (timeout != -1) {
            pdu.setTimeout(timeout);
        }
        if (this._log != null) {
            pdu.setLogger(this._log);
        } else if (peer.getLogger() != null) {
            pdu.setLogger(peer.getLogger());
        }
        return peer.send(pdu, this);
    }

    public int getBulkLimit(SnmpPeer peer, VarBindList vbl, int maxRptr, SnmpCallbackIf target, int retries, int timeout) throws SnmpException {
        this._state = (byte)-76;
        this._target = target;
        this._numVar = vbl.size();
        this._reqVariables = vbl;
        if (this._startIndex == null) {
            this._request = vbl.getVb(0).getOid().getValue();
        } else {
            int[] firstVbOid = vbl.getVb(0).getOid().getValue();
            int firstMibOidLen = firstVbOid.length - this._startIndex.length;
            this._request = new int[firstMibOidLen];
            System.arraycopy(firstVbOid, 0, this._request, 0, firstMibOidLen);
        }
        this._response = new VarBindList();
        SnmpPDU pdu = new SnmpPDU(-76, vbl);
        pdu.setMaxRptr(maxRptr);
        pdu.setRetries(retries);
        if (timeout != -1) {
            pdu.setTimeout(timeout);
        }
        if (this._log != null) {
            pdu.setLogger(this._log);
        } else if (peer.getLogger() != null) {
            pdu.setLogger(peer.getLogger());
        }
        return peer.send(pdu, this);
    }

    public int getBulkLimit(SnmpPeer peer, VarBindList vbl, SnmpCallbackIf target, int retries, int timeout) throws SnmpException {
        return this.getBulkLimit(peer, vbl, _Max / vbl.size() * 2, target, retries, timeout);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, VarBindList vbl, SnmpOID maxRptr) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        pdu.addNull(maxRptr);
        int max = 0;
        SnmpPDU resp = peer.send(pdu);
        SnmpVar v = resp.getVar(0);
        if (v.getType() == 2) {
            max = ((SnmpInt)v).getValue();
        } else if (v instanceof SnmpUnsignedInt) {
            max = (int)((SnmpUnsignedInt)v).getValue();
        } else {
            throw new SnmpException("Unknown maxRptr");
        }
        if (max == 0) {
            resp.reset();
            return resp;
        }
        return SnmpFetch.getBulk(peer, vbl, max);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, VarBindList vbl, Logger log) throws SnmpException {
        return SnmpFetch.getBulk(peer, vbl, 0, null, null, log);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, VarBindList vbl) throws SnmpException {
        return SnmpFetch.getBulkWithStartIndexFix(peer, vbl, 0, null, null, null);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, VarBindList vbl, SnmpFetchIf cb) throws SnmpException {
        _snmpFetchCb = cb;
        try {
            SnmpPDU snmpPDU = SnmpFetch.getBulk(peer, vbl, 0);
            return snmpPDU;
        }
        catch (SnmpException ex) {
            throw ex;
        }
        finally {
            _snmpFetchCb = null;
        }
    }

    public static SnmpPDU getBulk(SnmpPeer peer, int maxPerPDU, VarBindList vbl) throws SnmpException {
        return SnmpFetch.getBulk(peer, maxPerPDU, vbl, 0);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, int maxPerPDU, VarBindList vbl, int maxRptr) throws SnmpException {
        _Max = maxPerPDU;
        SnmpPDU pdu = SnmpFetch.getBulk(peer, vbl, maxRptr);
        _Max = Integer.getInteger("snmp.maxvarbind", 24);
        return pdu;
    }

    public static SnmpPDU getBulk(SnmpPeer peer, String[] mibVar, int maxRptr) throws SnmpException {
        VarBindList vbl = new VarBindList(mibVar.length);
        for (int i = 0; i < mibVar.length; ++i) {
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get(mibVar[i]).getOid())));
        }
        return SnmpFetch.getBulk(peer, vbl, maxRptr);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, VarBindList vbl, int maxRptr, Logger log) throws SnmpException {
        return SnmpFetch.getBulk(peer, vbl, maxRptr, null, null, log);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, VarBindList vbl, int maxRptr) throws SnmpException {
        return SnmpFetch.getBulk(peer, vbl, maxRptr, null, null, null);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, VarBindList vbl, int maxRptr, int[] startIndex, int[] stopIndex) throws SnmpException {
        return SnmpFetch.getBulk(peer, vbl, maxRptr, startIndex, stopIndex, null);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, VarBindList vbl, int maxRptr, int[] startIndex, int[] stopIndex, Logger log) throws SnmpException {
        boolean useMaxRptr;
        SnmpPDU pdu = new SnmpPDU(-91, vbl);
        int numVar = vbl.size();
        boolean bl = useMaxRptr = maxRptr > 0;
        if (!useMaxRptr) {
            maxRptr = (_Max + numVar - 1) / numVar;
        }
        pdu.setMaxRptr(maxRptr);
        if (log != null) {
            pdu.setLogger(log);
        }
        int[] request = vbl.getVb(0).getOid().getValue();
        VarBindList respVbl = new VarBindList();
        SnmpPDU resp = null;
        boolean isEnd = false;
        while (!isEnd) {
            resp = peer.send(pdu);
            VarBindList bVbl = resp.getVariables();
            isEnd = SnmpFetch.trimBulkResponse(bVbl, numVar, request, startIndex, stopIndex);
            if (bVbl.size() > 0) {
                respVbl.addAll(bVbl);
                if (_snmpFetchCb != null && respVbl.size() > 0) {
                    _snmpFetchCb.notifyResp(peer, respVbl.size() / numVar);
                }
                if (useMaxRptr && (maxRptr -= bVbl.size() / numVar) <= 0) {
                    isEnd = true;
                }
            }
            if (isEnd || maxRptr <= 0) continue;
            pdu.setVariables(new VarBindList());
            pdu.reset();
            pdu.setCommand((byte)-91);
            pdu.setMaxRptr(maxRptr);
            int max = bVbl.size();
            for (int i = max - numVar; i < max; ++i) {
                SnmpVarBind vb = bVbl.getVb(i);
                pdu.addVar(new SnmpVarBind(vb.getOid()));
            }
        }
        resp.setVariables(respVbl);
        return resp;
    }

    public static SnmpPDU getBulkWithStartIndexFix(SnmpPeer peer, VarBindList vbl, int maxRptr, int[] startIndex, int[] stopIndex) throws SnmpException {
        return SnmpFetch.getBulkWithStartIndexFix(peer, vbl, maxRptr, startIndex, stopIndex, null);
    }

    public static SnmpPDU getBulkWithStartIndexFix(SnmpPeer peer, VarBindList vbl, int maxRptr, int[] startIndex, int[] stopIndex, Logger log) throws SnmpException {
        boolean useMaxRptr;
        VarBindList newVbl = new VarBindList();
        SnmpPDU pdu = new SnmpPDU(-91, newVbl);
        int numVar = vbl.size();
        boolean bl = useMaxRptr = maxRptr > 0;
        if (!useMaxRptr) {
            maxRptr = (_Max + numVar - 1) / numVar;
        }
        pdu.setMaxRptr(maxRptr);
        if (log != null) {
            pdu.setLogger(log);
        }
        int[] request = vbl.getVb(0).getOid().getValue();
        for (int i = 0; i < vbl.size(); ++i) {
            if (startIndex == null) {
                newVbl.add(vbl.get(i).getOid().getValue());
                continue;
            }
            newVbl.add(vbl.get(i).getOid().getValue(), startIndex);
        }
        VarBindList respVbl = new VarBindList();
        SnmpPDU resp = null;
        boolean isEnd = false;
        while (!isEnd) {
            resp = peer.send(pdu);
            VarBindList bVbl = resp.getVariables();
            isEnd = SnmpFetch.trimBulkResponse(bVbl, numVar, request, startIndex, stopIndex);
            if (bVbl.size() > 0) {
                respVbl.addAll(bVbl);
                if (_snmpFetchCb != null && respVbl.size() > 0) {
                    _snmpFetchCb.notifyResp(peer, respVbl.size() / numVar);
                }
                if (useMaxRptr && (maxRptr -= bVbl.size() / numVar) <= 0) {
                    isEnd = true;
                }
            }
            if (isEnd || maxRptr <= 0) continue;
            pdu.setVariables(new VarBindList());
            pdu.reset();
            pdu.setCommand((byte)-91);
            pdu.setMaxRptr(maxRptr);
            int max = bVbl.size();
            for (int i = max - numVar; i < max; ++i) {
                SnmpVarBind vb = bVbl.getVb(i);
                pdu.addVar(new SnmpVarBind(vb.getOid()));
            }
        }
        resp.setVariables(respVbl);
        return resp;
    }

    private static boolean trimBulkResponse(VarBindList bVbl, int numVar, int[] request, int[] startIndex, int[] stopIndex) {
        if (bVbl.size() == 0 || bVbl.getVb(0).getError() == 21) {
            bVbl.clear();
            return true;
        }
        int max = bVbl.size();
        int partial = max % numVar;
        if (partial != 0) {
            max = max / numVar * numVar;
            bVbl.removeRange(max, bVbl.size());
        }
        for (int i = 0; i < max; i += numVar) {
            if (!bVbl.getVb(i).getOid().startsWith(request)) {
                bVbl.removeRange(i, bVbl.size());
                return true;
            }
            if (startIndex == null || stopIndex == null) continue;
            int[] oid = bVbl.getVb(i).getOid().getValue();
            int[] index = new int[startIndex.length];
            System.arraycopy(oid, request.length, index, 0, index.length);
            if ((stopIndex.length != 1 || index[0] < stopIndex[0]) && (stopIndex.length == 1 || SnmpOID.startsWith(index, stopIndex))) continue;
            bVbl.removeRange(i, bVbl.size());
            return true;
        }
        return bVbl.size() == 0;
    }

    public static SnmpPDU getBulk(SnmpPeer peer, int[][] oids, int[] startIndex, int maxRptr) throws SnmpException {
        return SnmpFetch.getBulk(peer, oids, startIndex, maxRptr, null);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, int[][] oids, int[] startIndex, int maxRptr, Logger log) throws SnmpException {
        boolean useMaxRptr;
        VarBindList vbl = new VarBindList(oids.length);
        for (int i = 0; i < oids.length; ++i) {
            vbl.add(new SnmpVarBind(new SnmpOID(oids[i], startIndex)));
        }
        SnmpPDU pdu = new SnmpPDU(-91, vbl);
        int numVar = vbl.size();
        boolean bl = useMaxRptr = maxRptr > 0;
        if (!useMaxRptr) {
            maxRptr = _Max / numVar;
        }
        pdu.setMaxRptr(maxRptr);
        if (log != null) {
            pdu.setLogger(log);
        }
        VarBindList respVbl = new VarBindList();
        SnmpPDU resp = null;
        boolean isEnd = false;
        while (!isEnd) {
            resp = peer.send(pdu);
            VarBindList bVbl = resp.getVariables();
            isEnd = SnmpFetch.trimBulkResponse(bVbl, numVar, oids[0], null, null);
            if (bVbl.size() > 0) {
                respVbl.addAll(bVbl);
                if (useMaxRptr && (maxRptr -= bVbl.size() / numVar) <= 0) {
                    isEnd = true;
                }
            }
            if (isEnd || maxRptr <= 0) continue;
            pdu.reset();
            pdu.setCommand((byte)-91);
            pdu.setMaxRptr(maxRptr);
            if (log != null) {
                pdu.setLogger(log);
            }
            int max = bVbl.size();
            for (int i = max - numVar; i < max; ++i) {
                SnmpVarBind vb = bVbl.getVb(i);
                pdu.addVar(new SnmpVarBind(vb.getOid()));
            }
        }
        resp.setVariables(respVbl);
        return resp;
    }

    public static SnmpPDU getBulk(SnmpPeer peer, int[][] oids, int subIndex, int maxRptr) throws SnmpException {
        VarBindList vbl = new VarBindList(oids.length);
        for (int i = 0; i < oids.length; ++i) {
            if (subIndex == 0) {
                vbl.add(new SnmpVarBind(new SnmpOID(oids[i])));
                continue;
            }
            vbl.add(new SnmpVarBind(new SnmpOID(oids[i], subIndex)));
        }
        return SnmpFetch.getBulk(peer, vbl, maxRptr);
    }

    public static SnmpPDU getBulk(SnmpPeer peer, int[][] oids, int[] subIndices) throws SnmpException {
        if (subIndices.length == 1) {
            return SnmpFetch.getBulk(peer, oids, subIndices[0], 0);
        }
        VarBindList[] vblBySubIndex = new VarBindList[subIndices.length];
        boolean[] endBySubIndex = new boolean[subIndices.length];
        IntArray indexInd = new IntArray(subIndices.length);
        SnmpPDU resp = null;
        int numEnds = 0;
        int maxNumIndex = _Max / (oids.length * subIndices.length) < 2 ? _Max / oids.length / 2 : subIndices.length;
        SnmpPDU reqPdu = new SnmpPDU(-91, new VarBindList(oids.length * maxNumIndex));
        while (true) {
            int count = 0;
            for (int i = 0; i < subIndices.length && count < maxNumIndex; ++i) {
                if (endBySubIndex[i]) continue;
                indexInd.add(i);
                ++count;
                for (int j = 0; j < oids.length; ++j) {
                    SnmpVarBind vb;
                    SnmpVarBind snmpVarBind = vb = vblBySubIndex[i] == null ? null : vblBySubIndex[i].getVb(vblBySubIndex[i].size() - oids.length + j);
                    if (vb == null) {
                        reqPdu.addVar(new SnmpVarBind(new SnmpOID(oids[j], subIndices[i])));
                        continue;
                    }
                    reqPdu.addVar(new SnmpVarBind(vb.getOid()));
                }
            }
            reqPdu.setMaxRptr(_Max / reqPdu.getVariables().size());
            resp = peer.send(reqPdu);
            VarBindList respVbl = resp.getVariables();
            if ((numEnds += SnmpFetch.trimBulkResponse(vblBySubIndex, respVbl, oids, subIndices, indexInd, endBySubIndex)) == subIndices.length) break;
            reqPdu.reset();
            reqPdu.setCommand((byte)-91);
            indexInd.clear();
        }
        VarBindList rvbl = new VarBindList();
        for (int i = 0; i < vblBySubIndex.length; ++i) {
            if (vblBySubIndex[i] == null) continue;
            rvbl.addAll(vblBySubIndex[i]);
        }
        resp.setVariables(rvbl);
        return resp;
    }

    private static int trimBulkResponse(VarBindList[] vblByIndex, VarBindList rspVbl, int[][] oids, int[] subIndices, IntArray indexInd, boolean[] endByIndex) {
        if (rspVbl.size() == 0 || rspVbl.getVb(0).getError() == 21) {
            rspVbl.clear();
            for (int i = 0; i < indexInd.size(); ++i) {
                endByIndex[indexInd.get((int)i)] = true;
            }
            return indexInd.size();
        }
        int numEnds = 0;
        int max = rspVbl.size();
        int partial = max % oids.length;
        if (partial != 0) {
            max = max / oids.length * oids.length;
            rspVbl.removeRange(max, rspVbl.size());
        }
        int numVar = oids.length * indexInd.size();
        block1: for (int i = 0; i < indexInd.size(); ++i) {
            for (int j = 0; j < max / numVar; ++j) {
                int pos = i * oids.length + j * numVar;
                int[] oid = rspVbl.getVb(pos).getOid().getValue();
                int index = indexInd.get(i);
                if (SnmpOID.startsWith(oid, oids[0]) && oid[oids[0].length] == subIndices[index]) {
                    for (int k = pos; k < pos + oids.length; ++k) {
                        if (vblByIndex[index] == null) {
                            vblByIndex[index] = new VarBindList();
                        }
                        vblByIndex[index].add(rspVbl.get(k));
                    }
                    continue;
                }
                endByIndex[index] = true;
                ++numEnds;
                continue block1;
            }
        }
        return numEnds;
    }

    public static SnmpPDU getTableColumns(SnmpPeer peer, VarBindList colVbl) throws SnmpException {
        int numCols = colVbl.size();
        int count = 0;
        VarBindList vbl = colVbl;
        VarBindList rspVbl = new VarBindList(numCols);
        SnmpPDU reqPdu = new SnmpPDU(-95);
        SnmpPDU rspPdu = new SnmpPDU(-95, rspVbl);
        block0: while (true) {
            reqPdu.setVariables(vbl);
            vbl = peer.send(reqPdu).getVariables();
            if (vbl.size() != numCols) break;
            for (int i = 0; i < numCols; ++i) {
                if (!vbl.getVb(i).getOid().startsWith(colVbl.getVb(i).getOid())) break block0;
            }
            rspVbl.addAll(count, vbl);
            count += numCols;
        }
        return rspPdu;
    }
}

