/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpASN1;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpVar;

public final class SnmpOID
extends SnmpVar {
    int[] _value;
    private int _hashCode;

    public SnmpOID(int[] id) {
        this._type = (byte)6;
        this._hashCode = 0;
        this._value = id;
    }

    public SnmpOID(int[] id, int index) {
        this._type = (byte)6;
        this._hashCode = 0;
        this._value = new int[id.length + 1];
        System.arraycopy(id, 0, this._value, 0, id.length);
        this._value[id.length] = index;
    }

    public SnmpOID(int[] id, int[] index) {
        this._type = (byte)6;
        this._hashCode = 0;
        this._value = new int[id.length + index.length];
        System.arraycopy(id, 0, this._value, 0, id.length);
        System.arraycopy(index, 0, this._value, id.length, index.length);
    }

    public SnmpOID(int[] id, int offset, int length) {
        this._type = (byte)6;
        this._hashCode = 0;
        this._value = new int[length];
        System.arraycopy(id, offset, this._value, 0, length);
    }

    public SnmpOID(int[] id, String indexString) {
        this._type = (byte)6;
        this._hashCode = 0;
        char[] index = indexString.toCharArray();
        this._value = new int[id.length + index.length + 1];
        System.arraycopy(id, 0, this._value, 0, id.length);
        this._value[id.length] = index.length;
        for (int i = 0; i < index.length; ++i) {
            this._value[id.length + 1 + i] = index[i];
        }
    }

    public SnmpOID(String str) {
        this._type = (byte)6;
        this._hashCode = 0;
        this._value = SnmpOID.stringToOid(str);
    }

    SnmpOID(SnmpInputStream is, int len) throws SnmpException {
        this(SnmpASN1.parseObjectId(is, len));
    }

    public final boolean startsWith(int[] oid) {
        return SnmpOID.startsWith(oid, this._value);
    }

    public final boolean startsWith(SnmpOID oid) {
        return SnmpOID.startsWith(oid.getValue(), this._value);
    }

    public static boolean startsWith(int[] first, int[] second) {
        return SnmpOID.startsWith(first, second, 0);
    }

    public static boolean startsWith(int[] first, int[] second, int offset) {
        int i = offset;
        for (int j = 0; i < first.length && j < second.length; ++i, ++j) {
            if (first[i] == second[j]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] first, int[] second) {
        if (first.length != second.length) {
            return false;
        }
        return SnmpOID.startsWith(first, second);
    }

    public static boolean equals(int[] first, int firstOffset, int[] second, int secondOffset) {
        if (first.length - firstOffset != second.length - secondOffset) {
            return false;
        }
        int i = firstOffset;
        for (int j = secondOffset; i < first.length && j < second.length; ++i, ++j) {
            if (first[i] == second[j]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object o) {
        return SnmpOID.equals(this._value, ((SnmpOID)o)._value);
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        SnmpOID i1 = (SnmpOID)o1;
        SnmpOID i2 = (SnmpOID)o2;
        return MibNode.equals(i1._value, i2._value);
    }

    public final int[] getValue() {
        return this._value;
    }

    public final int[] getIndex(int len) {
        int[] index = new int[len];
        System.arraycopy(this._value, this._value.length - len, index, 0, len);
        return index;
    }

    public final int getIndexFromEnd(int endOffset) {
        return this._value[this._value.length - 1 - endOffset];
    }

    public String toString() {
        if (this._value == null || this._value.length == 0) {
            return null;
        }
        return SnmpOID.toString(this._value, 0, this._value.length);
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int j = this._value.length - 1;
            int k = 1;
            while (j >= 0) {
                this._hashCode += k * this._value[j];
                --j;
                k *= 31;
            }
        }
        return this._hashCode;
    }

    public static String toString(int[] value) {
        return SnmpOID.toString(value, 0, value.length);
    }

    public static String toString(int[] value, int offset, int len) {
        StringBuffer sb = new StringBuffer();
        sb.append(value[offset]);
        for (int i = offset + 1; i < len; ++i) {
            sb.append('.');
            sb.append(value[i]);
        }
        return sb.toString();
    }

    public static int[] stringToOid(String str) {
        if (str.charAt(0) == '.') {
            str = str.substring(1);
        }
        int numOids = 1;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '.') continue;
            ++numOids;
        }
        int[] oid = new int[numOids];
        int p1 = 0;
        for (int i = 0; i < oid.length - 1; ++i) {
            int p2 = str.indexOf(46, p1);
            oid[i] = Integer.parseInt(str.substring(p1, p2));
            p1 = p2 + 1;
        }
        oid[numOids - 1] = Integer.parseInt(str.substring(p1));
        return oid;
    }

    @Override
    protected void encode(SnmpOutputStream os) throws SnmpException {
        SnmpASN1.buildObjectId(os, this._value, this._value.length);
    }
}

