/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpASN1;
import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import java.io.Serializable;

public final class SnmpVarBind
implements Serializable {
    SnmpOID _oid;
    SnmpVar _variable;

    public SnmpVarBind() {
    }

    public SnmpVarBind(SnmpOID oid) {
        this._oid = oid;
    }

    public SnmpVarBind(SnmpOID oid, SnmpVar variable) {
        this._oid = oid;
        this._variable = variable;
    }

    public SnmpOID getOid() {
        return this._oid;
    }

    public void setOid(SnmpOID oid) {
        this._oid = oid;
    }

    public SnmpVar getVar() {
        return this._variable;
    }

    public long longValue() {
        SnmpVar var = this.getVar();
        if (var.getType() == 66 || var.getType() == 65 || var.getType() == 67 || var.getType() == 66) {
            return ((SnmpUnsignedInt)var).getValue();
        }
        if (var.getType() == 70) {
            return ((SnmpCounter64)var).getLongValue();
        }
        if (var.getType() == 2) {
            return ((SnmpInt)var).getValue();
        }
        return 0L;
    }

    public int intValue() {
        SnmpVar var = this.getVar();
        if (var.getType() == 2) {
            return ((SnmpInt)var).getValue();
        }
        if (var.getType() == 66 || var.getType() == 65 || var.getType() == 66) {
            return (int)((SnmpUnsignedInt)var).getValue();
        }
        return 0;
    }

    public String stringValue() {
        return this.getVar().toString();
    }

    public byte[] byteValue() {
        SnmpVar var = this.getVar();
        if (var.getType() == 4) {
            return ((SnmpString)var).getValue();
        }
        if (var instanceof SnmpString) {
            return ((SnmpString)var).getValue();
        }
        return new byte[0];
    }

    public String enumValue() {
        MibEnum[] enums = null;
        SnmpVar var = this.getVar();
        MibNode n = MibNode.oidToNode(this.getOid().getValue());
        if (n != null) {
            enums = n.getEnums();
        }
        if (enums != null) {
            if (var.getType() == 2) {
                return MibEnum.getLabel(enums, ((SnmpInt)var).getValue());
            }
            if (var.getType() == 4) {
                return SnmpString.bitsToString(((SnmpString)var).getValue(), enums);
            }
        }
        return var.toString();
    }

    public boolean isNull() {
        return this.getVar().getType() == 4 && ((SnmpString)this.getVar()).isNull();
    }

    public void setVar(SnmpVar variable) {
        this._variable = variable;
    }

    void encode(SnmpOutputStream os) throws SnmpException {
        int start = os._pos;
        SnmpASN1.buildSequence(os, 0);
        SnmpASN1.buildObjectId(os, this._oid._value, this._oid._value.length);
        if (this._variable == null) {
            SnmpASN1.buildHeader(os, (byte)5, 0);
        } else {
            this._variable.encode(os);
        }
        int end = os._pos;
        os._pos = start;
        SnmpASN1.buildSequence(os, end - start - 4);
        os._pos = end;
    }

    void decode(SnmpInputStream is) throws SnmpException {
        int id = SnmpASN1.parseHeader(is);
        if (id != 48) {
            throw new SnmpException("VarBind Header decode error: " + id);
        }
        SnmpVar obj = SnmpASN1.decodeVar(is);
        if (obj._type != 6) {
            throw new SnmpException("VarBind OID decode error");
        }
        this._oid = (SnmpOID)obj;
        this._variable = SnmpASN1.decodeVar(is);
    }

    public int getError() {
        if (this._variable.getType() == 5) {
            return ((SnmpNull)this._variable)._error & 0xFF;
        }
        return 0;
    }

    public int getIndex() {
        return this._oid._value[this._oid._value.length - 1];
    }

    public void setIndex(int newIndex) {
        this._oid._value[this._oid._value.length - 1] = newIndex;
    }

    public final int[] getIndex(int len) {
        return this._oid.getIndex(len);
    }

    public final int getIndexFromEnd(int endOffset) {
        return this._oid.getIndexFromEnd(endOffset);
    }

    public String toString() {
        if (this._variable == null) {
            return this._oid.toString();
        }
        return this._oid.toString() + "=" + this._variable.toString();
    }
}

