/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public final class VarBindList
extends AbstractList<SnmpVarBind> {
    static final Comparator<SnmpVarBind> _NameComparer = new Comparator<SnmpVarBind>(){

        @Override
        public int compare(SnmpVarBind o1, SnmpVarBind o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1.getVar().toString().compareTo(o2.getVar().toString());
        }
    };
    private transient SnmpVarBind[] _elementData;
    private int _size;

    public VarBindList() {
        this(10);
    }

    public VarBindList(int initialCapacity) {
        this._elementData = new SnmpVarBind[initialCapacity];
    }

    public VarBindList(SnmpVarBind[] vbs) {
        this._elementData = vbs;
        this._size = vbs.length;
    }

    public SnmpOID getOid(int index) {
        return this.getVb(index).getOid();
    }

    @Override
    public SnmpVarBind get(int index) {
        return this._elementData[index];
    }

    public void copy(VarBindList from, int index, int len) {
        this.ensureCapacity(from.size() + 1);
        System.arraycopy(from._elementData, index, this._elementData, 0, len);
        this._size = len;
    }

    public SnmpVarBind getVb(int index) {
        return this._elementData[index];
    }

    public long longValue(int index) {
        return this._elementData[index].longValue();
    }

    public int intValue(int index) {
        return this._elementData[index].intValue();
    }

    public String stringValue(int index) {
        return this._elementData[index].stringValue();
    }

    public byte[] byteValue(int index) {
        return this._elementData[index].byteValue();
    }

    public String enumValue(int index) {
        return this._elementData[index].enumValue();
    }

    public boolean isNull(int index) {
        return this._elementData[index].isNull();
    }

    @Override
    public SnmpVarBind set(int index, SnmpVarBind element) {
        SnmpVarBind oldValue = this._elementData[index];
        this._elementData[index] = element;
        if (oldValue == null) {
            ++this._size;
        }
        return oldValue;
    }

    @Override
    public void add(int index, SnmpVarBind element) {
        this.ensureCapacity(this._size + 1);
        System.arraycopy(this._elementData, index, this._elementData, index + 1, this._size - index);
        this._elementData[index] = element;
        ++this._size;
    }

    public void add(int[] oid) {
        this.add(new SnmpVarBind(new SnmpOID(oid)));
    }

    public void add(int[] oid, int index) {
        this.add(new SnmpVarBind(new SnmpOID(oid, index)));
    }

    public void add(int[] oid, int[] index) {
        this.add(new SnmpVarBind(new SnmpOID(oid, index)));
    }

    public void add(int[] oid, int[] index, SnmpVar v) {
        this.add(new SnmpVarBind(new SnmpOID(oid, index), v));
    }

    public void add(int[] oid, int index, SnmpVar v) {
        this.add(new SnmpVarBind(new SnmpOID(oid, new int[]{index}), v));
    }

    @Override
    public boolean add(SnmpVarBind o) {
        this.ensureCapacity(this._size + 1);
        this._elementData[this._size++] = o;
        return true;
    }

    @Override
    public SnmpVarBind remove(int index) {
        ++this.modCount;
        SnmpVarBind oldValue = this._elementData[index];
        int numMoved = this._size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this._elementData, index + 1, this._elementData, index, numMoved);
        }
        this._elementData[--this._size] = null;
        return oldValue;
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this._elementData.length;
        if (minCapacity > oldCapacity) {
            SnmpVarBind[] oldData = this._elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this._elementData = new SnmpVarBind[newCapacity];
            System.arraycopy(oldData, 0, this._elementData, 0, this._size);
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this._size; ++i) {
            this._elementData[i] = null;
        }
        this._size = 0;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this._size - toIndex;
        System.arraycopy(this._elementData, toIndex, this._elementData, fromIndex, numMoved);
        int newSize = this._size - (toIndex - fromIndex);
        while (this._size != newSize) {
            this._elementData[--this._size] = null;
        }
    }

    public boolean addAll(int index, VarBindList c) {
        int numNew = c.size();
        this.ensureCapacity(this._size + numNew);
        int numMoved = this._size - index;
        if (numMoved > 0) {
            System.arraycopy(this._elementData, index, this._elementData, index + numNew, numMoved);
        }
        Iterator e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            this._elementData[index++] = (SnmpVarBind)e.next();
        }
        this._size += numNew;
        return numNew != 0;
    }

    public void sort() {
        if (this.size() > 1) {
            Collections.sort(this, _NameComparer);
        }
    }

    public static int oidLookup(VarBindList vbl, int[] targetOid) {
        for (int i = 0; i < vbl.size(); ++i) {
            if (!SnmpOID.startsWith(vbl.get(i).getOid().getValue(), targetOid)) continue;
            return i;
        }
        return -1;
    }
}

