/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.proxy;

import com.cisco.dcbu.lib.util.NetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

final class ProxySession {
    private String _sessionId;
    private Socket _client = null;
    private DataInputStream _input = null;
    private DataOutputStream _output = null;
    private SnmpSession _snmpSession = null;
    private Semaphore _writingLock = new Semaphore(1);
    private boolean _close = false;
    Logger _log = LogManager.getLogger((String)"snmp.proxy");

    public ProxySession(Socket client) {
        this._client = client;
        this._sessionId = this._client.getInetAddress().getHostAddress() + "/" + this._client.getPort();
    }

    public String getSessionId() {
        return this._client.getInetAddress().getHostAddress() + "/" + this._client.getPort();
    }

    public void serve() {
        try {
            this._input = new DataInputStream(new BufferedInputStream(this._client.getInputStream()));
            this._output = new DataOutputStream(new BufferedOutputStream(this._client.getOutputStream()));
        }
        catch (IOException ioe) {
            this._log.log((Priority)Level.FATAL, (Object)"ProxySession::serve()", (Throwable)ioe);
            return;
        }
        this._log.info((Object)("Start proxy session with client: " + this._sessionId));
        try {
            int error_count = 0;
            while (!this._close) {
                byte reqType = this._input.readByte();
                if (reqType == 1) {
                    error_count = 0;
                    this.receiveOpenRequest();
                    continue;
                }
                if (reqType == 3) {
                    error_count = 0;
                    this.receiveSnmpRequest();
                    continue;
                }
                if (reqType == 2) {
                    error_count = 0;
                    this.receiveCloseRequest();
                    continue;
                }
                if (reqType == 4) {
                    error_count = 0;
                    this.receiveSnmpSourceAddressRequest();
                    continue;
                }
                this._log.error((Object)("unknown client request: " + reqType));
                if (++error_count <= 10) continue;
                throw new IOException("received " + error_count + " unknow client request, terminate this session");
            }
        }
        catch (Exception ex) {
            this._log.debug((Object)("Lost connection to client: " + this._sessionId));
            this.close();
        }
        this._log.info((Object)("Proxy Session to " + this._sessionId + " stopped"));
    }

    public void close() {
        this._log.info((Object)("Closing session to client: " + this._sessionId));
        this._close = true;
        if (this._snmpSession != null) {
            this._snmpSession.close();
            this._snmpSession = null;
        }
        try {
            this._client.close();
        }
        catch (IOException ioe) {
            this._log.error((Object)("Closing session provider failed: " + ioe.getMessage()));
        }
        this._client = null;
        this._log.info((Object)"ProxySession transport closed");
    }

    private void receiveOpenRequest() {
        this._log.debug((Object)"Open SNMP session request");
        try {
            this._snmpSession = new SnmpSession();
            this._snmpSession.open();
            this.sendResponseMessage((byte)65, (byte)1, this._snmpSession.getSnmpSourceAddress() + "/" + this._snmpSession.getSnmpSourcePort());
        }
        catch (SocketException se) {
            this._log.log((Priority)Level.ERROR, (Object)"Opening SNMP socket failed", (Throwable)se);
            this.sendResponseMessage((byte)65, (byte)2, se.toString());
        }
    }

    private void receiveSnmpSourceAddressRequest() {
        String host = null;
        try {
            int msgLen = this._input.readInt();
            host = this._input.readUTF();
        }
        catch (Exception ex) {
            this.sendResponseMessage((byte)69, (byte)2, host);
            return;
        }
        try {
            String addr = NetUtil.getHtml(host, "cgi-bin/ip.jnlp");
            String returnMsg = host + "=" + addr;
            this.sendResponseMessage((byte)69, (byte)1, returnMsg);
            this._log.debug((Object)("Sent Snmp Srouce Address of " + host + " to " + addr));
        }
        catch (IOException ioe) {
            this.sendResponseMessage((byte)69, (byte)2, host);
        }
    }

    private void receiveCloseRequest() {
        this._log.debug((Object)"Close SNMP session request");
        this.close();
        this.sendResponseMessage((byte)66, (byte)1, null);
    }

    private void receiveSnmpRequest() {
        byte[] pduData;
        int pduLen;
        int remotePort;
        InetAddress remoteAddr;
        int reqId = 0;
        try {
            int secondLen;
            reqId = this._input.readInt();
            byte addrType = this._input.readByte();
            int addrLen = this._input.readInt();
            byte[] addr = new byte[addrLen];
            this._input.read(addr, 0, addrLen);
            try {
                if (addrType == 3) {
                    String hostname = new String(addr);
                    remoteAddr = InetAddress.getByName(hostname);
                } else {
                    remoteAddr = InetAddress.getByAddress(addr);
                }
            }
            catch (UnknownHostException uhe) {
                this.sendResponseMessage((byte)67, (byte)2, "UnknownHostException: " + uhe.getMessage());
                return;
            }
            remotePort = this._input.readInt();
            pduLen = this._input.readInt();
            pduData = new byte[pduLen];
            for (int readLen = this._input.read(pduData, 0, pduLen); readLen < pduLen; readLen += secondLen) {
                byte[] tmpBuf = new byte[pduLen];
                secondLen = this._input.read(tmpBuf, 0, pduLen - readLen);
                for (int j = 0; j < secondLen; ++j) {
                    pduData[readLen + j] = tmpBuf[j];
                }
            }
        }
        catch (Exception ex) {
            this._log.log((Priority)Level.ERROR, (Object)("error reading data " + reqId), (Throwable)ex);
            this.sendResponseMessage((byte)67, (byte)2, ex.toString());
            return;
        }
        try {
            this._snmpSession.send(pduData, pduLen, remoteAddr, remotePort);
            this._log.debug((Object)("Sent PDU from " + this._sessionId + " to " + remoteAddr.getHostAddress() + ", reqId=" + reqId + ", len=" + pduLen));
        }
        catch (IOException ioe) {
            this._log.error((Object)(reqId + " : " + ioe.getMessage()));
            this.sendResponseMessage((byte)67, (byte)2, ioe.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendResponseMessage(byte rspType, byte errCode, String msg) {
        try {
            this._writingLock.acquire();
            this._output.writeByte(rspType);
            this._output.writeByte(errCode);
            if (msg == null || msg.length() == 0) {
                this._output.writeInt(0);
            } else {
                this._output.writeInt(msg.length());
                this._output.writeUTF(msg);
            }
            this._output.flush();
        }
        catch (IOException ioe) {
        }
        catch (InterruptedException ie) {
        }
        finally {
            this._writingLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPDUResponse(DatagramPacket packet) {
        InetAddress srcaddr = packet.getAddress();
        byte[] addr = srcaddr.getAddress();
        int srcport = packet.getPort();
        int pdulen = packet.getLength();
        this._log.debug((Object)("Received PDU from " + srcaddr.getHostAddress() + "/" + srcport + ", len=" + pdulen));
        try {
            this._writingLock.acquire();
            this._output.writeByte(68);
            this._output.writeByte(1);
            this._output.writeInt(0);
            this._output.writeInt(addr.length);
            this._output.write(addr, 0, addr.length);
            this._output.writeInt(srcport);
            this._output.writeInt(pdulen);
            this._output.write(packet.getData(), 0, packet.getLength());
            this._output.flush();
            this._log.debug((Object)("Forwarded PDU from " + srcaddr.getHostAddress() + " to " + this._sessionId + ':' + srcport + ", len=" + pdulen));
        }
        catch (Exception ex) {
            this._log.error((Object)("Sending PDU error: " + ex.toString()));
        }
        finally {
            this._writingLock.release();
        }
    }

    final class SnmpSession
    extends Thread {
        private DatagramSocket _snmpSock;
        final byte[] _responseBuf;

        public SnmpSession() {
            super("SnmpReceiver-" + ProxySession.this._sessionId);
            this._snmpSock = null;
            this._responseBuf = new byte[6000];
        }

        public String getSnmpSourceAddress() {
            InetAddress addr = null;
            if (this._snmpSock != null && (addr = this._snmpSock.getLocalAddress()).isAnyLocalAddress()) {
                try {
                    addr = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            return addr != null ? addr.getHostAddress() : null;
        }

        public int getSnmpSourcePort() {
            return this._snmpSock != null ? this._snmpSock.getLocalPort() : 0;
        }

        public void open() throws SocketException {
            InetAddress bindAddr = null;
            String value = System.getProperty("snmp.localaddress");
            try {
                bindAddr = value == null || value.length() == 0 ? InetAddress.getByName("0.0.0.0") : NetUtil.getLocalAddressByName(value);
            }
            catch (IOException ioe) {
                ProxySession.this._log.log((Priority)Level.ERROR, (Object)"ProxySession.SnmpSession()", (Throwable)ioe);
            }
            this._snmpSock = new DatagramSocket(0, bindAddr);
            ProxySession.this._log.info((Object)("SNMP socket opened on " + this._snmpSock.getLocalAddress().getHostAddress() + "/" + this._snmpSock.getLocalPort() + " for client " + ProxySession.this._sessionId));
            if (!this.isAlive()) {
                this.start();
            }
        }

        public void close() {
            String desc = null;
            try {
                if (this._snmpSock != null) {
                    desc = this._snmpSock.getLocalAddress().getHostAddress() + ':' + this._snmpSock.getLocalPort();
                    this._snmpSock.close();
                    this._snmpSock = null;
                    ProxySession.this._log.info((Object)("SNMP socket closed on " + desc));
                }
            }
            catch (Exception ex) {
                ProxySession.this._log.error((Object)("Closing SNMP socket " + desc + " failed: " + ex.getMessage()));
            }
        }

        void send(byte[] buf, int len, InetAddress destaddr, int port) throws IOException {
            if (this._snmpSock == null) {
                throw new IOException("SNMP socket not opened.");
            }
            DatagramPacket p = new DatagramPacket(buf, len, destaddr, port);
            this._snmpSock.send(p);
        }

        @Override
        public void run() {
            DatagramPacket packet = new DatagramPacket(this._responseBuf, this._responseBuf.length);
            while (!ProxySession.this._close) {
                if (this._snmpSock != null) {
                    packet.setLength(this._responseBuf.length);
                    try {
                        this._snmpSock.receive(packet);
                    }
                    catch (IOException ex) {
                        ProxySession.this._log.error((Object)("receiver: " + ex));
                        continue;
                    }
                    if (ProxySession.this._close) {
                        return;
                    }
                    if (packet.getLength() == 0) continue;
                    ProxySession.this.sendPDUResponse(packet);
                    continue;
                }
                Thread.yield();
            }
            ProxySession.this._log.info((Object)"ProxySession.SnmpSession stopped.");
        }
    }
}

