/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.sshexec.impl;

import com.cisco.dcbu.lib.sshexec.CliCommands;
import com.cisco.dcbu.lib.sshexec.IGoldDiagAdapter;
import com.cisco.dcbu.lib.sshexec.impl.CliAdapter;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class GoldDiagAdapter
extends CliAdapter
implements IGoldDiagAdapter {
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.disc"), false, false, false, false);

    public GoldDiagAdapter(EthSwitchImpl ethSw) throws Exception {
        super(ethSw, true);
    }

    public GoldDiagAdapter(String host, String userName, String password) throws Exception {
        super(host, userName, password, true);
    }

    @Override
    public void startModuleDiagnostic(int moduleNum) throws Exception {
        long startTime = System.currentTimeMillis();
        String resp = this.transport.send(CliCommands.GOLD_DIAGNOSTIC_START + moduleNum + CliCommands.GOLD_DIAGNOSTIC_TEST_NON_DISRUOTIVE);
        long sendTime = System.currentTimeMillis();
        if (this.ethSw != null) {
            _Tracer.log(Level.DEBUG, this.ethSw.getIpAddress() + "-->show diagnostic result module x command took " + (sendTime - startTime) + " ms");
        }
        if (resp.length() > 0) {
            _Tracer.log(Level.INFO, "CLI response from the device: " + resp);
            if (this.ethSw != null) {
                _Tracer.log(Level.ERROR, this.ethSw.getIpAddress() + "-->Unable to run show diagnostic result module x command.");
            }
        }
    }

    @Override
    public String showModuleDiagnostic(int moduleNum) throws Exception {
        long startTime = System.currentTimeMillis();
        String resp = this.transport.send(CliCommands.GOLD_SHOW_DIAGNOSTIC_RESULT + moduleNum);
        long sendTime = System.currentTimeMillis();
        if (this.ethSw != null) {
            _Tracer.log(Level.DEBUG, this.ethSw.getIpAddress() + "-->show diagnostic result module x command took " + (sendTime - startTime) + " ms");
        }
        if (resp.startsWith("Syntax error")) {
            _Tracer.log(Level.TRACE, "CLI response from the device: " + resp);
            if (this.ethSw != null) {
                _Tracer.log(Level.TRACE, this.ethSw.getIpAddress() + "-->Unable to get show diagnostic result module command output.");
            }
            return null;
        }
        return resp;
    }

    @Override
    public String showModuleDiagnosticAll() throws Exception {
        long startTime = System.currentTimeMillis();
        String resp = this.transport.send(CliCommands.GOLD_SHOW_DIAGNOSTIC_RESULT + "all");
        long sendTime = System.currentTimeMillis();
        if (this.ethSw != null) {
            _Tracer.log(Level.INFO, this.ethSw.getIpAddress() + "-->show diagnostic result module x command took " + (sendTime - startTime) + " ms");
        }
        if (resp.startsWith("Syntax error")) {
            _Tracer.log(Level.INFO, "CLI response from the device: " + resp);
            if (this.ethSw != null) {
                _Tracer.log(Level.ERROR, this.ethSw.getIpAddress() + "-->Unable to get show diagnostic result module command output.");
            }
            return null;
        }
        return resp;
    }

    @Override
    public String showLoggingLogfile() throws Exception {
        long startTime = System.currentTimeMillis();
        String resp = this.transport.send(CliCommands.SHOW_LOGGING_LOGFILE_20);
        long sendTime = System.currentTimeMillis();
        if (this.ethSw != null) {
            _Tracer.log(Level.TRACE, this.ethSw.getIpAddress() + "-->show logging logfile | last 10 command took " + (sendTime - startTime) + " ms");
        }
        if (resp.startsWith("Syntax error")) {
            _Tracer.log(Level.TRACE, "CLI response from the device: " + resp);
            if (this.ethSw != null) {
                _Tracer.log(Level.TRACE, this.ethSw.getIpAddress() + "-->Unable to get show logging logfile | last 10 command output.");
            }
            return null;
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        GoldDiagAdapter adapter = null;
        try {
            adapter = new GoldDiagAdapter("172.22.31.16", "admin", "democonf_2008");
            adapter.startModuleDiagnostic(3);
            Thread.sleep(10000L);
            String rs = adapter.showModuleDiagnostic(3);
            System.out.println(rs);
            rs = adapter.showLoggingLogfile();
            System.out.println(rs);
            adapter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (adapter != null) {
                try {
                    adapter.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

