/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.sshexec.impl;

import com.cisco.dcbu.lib.sshexec.CliCommands;
import com.cisco.dcbu.lib.sshexec.CliTokens;
import com.cisco.dcbu.lib.sshexec.IHardwareAdapter;
import com.cisco.dcbu.lib.sshexec.impl.CliAdapter;
import com.cisco.dcbu.lib.sshexec.model.CliResponse;
import com.cisco.dcbu.lib.sshexec.model.Hardware;
import com.cisco.dcbu.lib.util.CliUtil;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class HardwareAdapter
extends CliAdapter
implements IHardwareAdapter {
    static final TraceLogger logger = new TraceLogger(Logger.getLogger((String)"fms.adapter"), false, false, false, false);

    public HardwareAdapter(EthSwitchImpl ethSw) throws Exception {
        super(ethSw);
    }

    public HardwareAdapter(String host, String userName, String password) throws Exception {
        super(host, userName, password);
    }

    @Override
    public Hardware getHardware() throws Exception {
        Hardware hw = null;
        try {
            long startTime = System.currentTimeMillis();
            CliResponse r = new CliResponse();
            this.transport.send(CliCommands.SHOW_HARDWARE, r);
            while (!r.isDone()) {
                Thread.yield();
            }
            long sendTime = System.currentTimeMillis();
            logger.debug("showLldpNeighborsDetail command took " + (sendTime - startTime) + "ms");
            if (r.isError()) {
                throw new Exception(r.getErrMsg());
            }
            if (r.getResponseString().indexOf("% Invalid") >= 0) {
                throw new Exception(r.getResponseString());
            }
            hw = new Hardware();
            String resp = r.getResponseString();
            hw.setCards(this.getCards(resp));
            long parseTime = System.currentTimeMillis();
            logger.debug("showLldpNeighborsDetail processing took " + (parseTime - sendTime) + "ms");
        }
        catch (Exception e) {
            logger.log(Level.ERROR, e.getMessage());
            throw e;
        }
        return hw;
    }

    private List<Card<PKIf>> getCards(String s) throws Exception {
        ArrayList<Card<PKIf>> cards = new ArrayList<Card<PKIf>>();
        String swVer = this.getTokenValue(s, CliTokens.SYSTEM_VERSION);
        String resetReason = this.getTokenValue(s, CliTokens.RESET_REASON);
        List<String> modules = this.getHardwares(this.getHardwareBlock(s, CliTokens.MODULE_SLOTS), CliTokens.MODULE);
        if (modules != null) {
            for (String m : modules) {
                List<String> lines = CliUtil.getLines(m);
                int slotNum = -1;
                String status = null;
                String moduleType = null;
                String modelNum = null;
                String hwVer = null;
                String partNum = null;
                String serialNum = null;
                try {
                    for (String l : lines) {
                        if (l.indexOf(CliTokens.MODULE) == 0) {
                            slotNum = Integer.parseInt(l.substring(0, l.indexOf(" ")).trim().substring(CliTokens.MODULE.length()));
                            status = l.substring(l.indexOf(" ")).trim();
                            continue;
                        }
                        if (status.equals("empty")) continue;
                        if (l.indexOf(CliTokens.MODULE_TYPE) >= 0) {
                            moduleType = l.substring(CliTokens.MODULE_TYPE.length() + 1).trim();
                            continue;
                        }
                        if (l.indexOf(CliTokens.MODEL_NUMBER) >= 0) {
                            modelNum = l.substring(CliTokens.MODEL_NUMBER.length() + 1).trim();
                            continue;
                        }
                        if (l.indexOf(CliTokens.HW_VERSION) >= 0) {
                            hwVer = l.substring(CliTokens.HW_VERSION.length() + 1).trim();
                            continue;
                        }
                        if (l.indexOf(CliTokens.PART_NUMBER) >= 0) {
                            partNum = l.substring(CliTokens.PART_NUMBER.length() + 1).trim();
                            continue;
                        }
                        if (l.indexOf(CliTokens.SERIAL_NUMBER) < 0) continue;
                        serialNum = l.substring(CliTokens.SERIAL_NUMBER.length() + 1).trim();
                    }
                }
                catch (Exception e) {
                    logger.warn("Failed to get module. " + e.getMessage());
                }
                Card<Object> c = new Card<Object>(null, 0, null, slotNum, moduleType, hwVer, swVer, swVer, serialNum, modelNum, null, partNum, 0, 0, status, resetReason, System.currentTimeMillis(), 0, 0, 0, 0, 0, 0, 0);
                cards.add(c);
            }
        }
        return cards;
    }

    private String getTokenValue(String s, String token) throws Exception {
        String result = null;
        int index = s.indexOf(token);
        if (index >= 0) {
            String subStr = s.substring(index);
            if ((subStr = subStr.substring(0, subStr.indexOf(10))).length() > 0) {
                result = CliUtil.getValue(subStr, token);
            }
        }
        return result;
    }

    private List<String> getHardwares(String in, String key) {
        if (in == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int index = in.indexOf(key);
        in = in.substring(index);
        index = 0;
        int nextIndex = 0;
        while (nextIndex >= 0) {
            if ((nextIndex = in.indexOf(key, nextIndex + 1)) == -1) {
                results.add(in);
                index = 0;
                break;
            }
            String temp = in.substring(nextIndex + key.length(), nextIndex + key.length() + 1);
            if (!temp.matches("[0-9]")) continue;
            results.add(in.substring(index, nextIndex));
            in = in.substring(nextIndex);
            nextIndex = 0;
        }
        return results;
    }

    private String getHardwareBlock(String in, String start) {
        String result = null;
        int index = in.indexOf(start);
        if (index >= 0 && (result = in.substring(index)) != null) {
            index = result.indexOf("-----");
            if ((index = result.indexOf("\n", index)) >= 0) {
                result = result.substring(index + 1).trim();
            }
            if (result != null && (index = result.indexOf("-----")) >= 0) {
                result = result.substring(0, index).trim();
            }
        }
        return result;
    }
}

