/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.sshexec.impl;

import com.cisco.dcbu.lib.protocol.SSHWrapper;
import com.cisco.dcbu.lib.protocol.Util;
import com.cisco.dcbu.lib.sshexec.impl.ProcessCliResponse;
import com.cisco.dcbu.lib.sshexec.impl.SshTransportAdapter;
import com.cisco.dcbu.lib.sshexec.model.CliResponse;
import com.cisco.dcbu.lib.sshexec.model.SshCredential;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SshExecTransport
extends SshTransportAdapter {
    private final Logger log = LogManager.getLogger((String)"fms");
    private static int SSH_PORT = 22;
    private static int SLEEP = 50;
    private int _SessionTimeout = Integer.parseInt(System.getProperty("ssh.session-timeout", "60000"));
    private int _readWaitTime = Integer.parseInt(System.getProperty("ssh.read-wait-time", "15000"));
    private SshCredential credential = null;
    private JSch jsch = null;
    private Session session = null;
    private boolean timed = false;

    @Override
    public void close() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
            this.credential = null;
        }
    }

    @Override
    public void open(String host, String userName, String password) throws IOException {
        try {
            if (!Util.isServiceRunning(host, SSH_PORT)) {
                throw new Exception("Not able to reach : " + host + ":" + SSH_PORT);
            }
            try {
                this.jsch = new JSch();
                this.session = this.jsch.getSession(userName, host);
                this.session.setUserInfo(new SSHWrapper.MyUserInfo(password));
                this.session.connect(this._SessionTimeout, new String[]{Session.PASSWORD});
                this.credential = new SshCredential(host, userName, password);
            }
            catch (JSchException e) {
                this.log.error((Object)("SshExecTransport.open(): failed to connect to '" + host + "'. " + e.getMessage()));
                throw new Exception("SSH failed to connect to '" + host + "', please check user name and password.");
            }
        }
        catch (Exception e) {
            if (this.session != null) {
                this.session.disconnect();
                this.session = null;
            }
            throw new IOException("Cannot open ssh connection to '" + host + "'. Please check ssh connection or credential.", e);
        }
    }

    @Override
    public String send(String cmd) throws Exception {
        if (this.session == null || cmd == null) {
            throw new IllegalArgumentException("SshExecTransport.send(): invalid session or command");
        }
        if (this.log.isDebugEnabled() && this.credential != null) {
            this.log.debug((Object)(this.credential.getHost() + ": sending command '" + cmd + "'"));
        }
        Channel channel = null;
        ByteArrayOutputStream out = null;
        Timer timer = null;
        try {
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(cmd);
            out = new ByteArrayOutputStream();
            channel.setOutputStream(out);
            channel.connect();
            this.timed = false;
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    SshExecTransport.this.timed = true;
                }
            };
            timer = new Timer("SshExecTimer");
            timer.schedule(task, this._readWaitTime);
            while (!this.timed) {
                if (channel.isEOF()) {
                    break;
                }
                try {
                    Thread.sleep(SLEEP);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.log.error((Object)("SshExecTransport.send(): " + e.getMessage()));
            throw e;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            if (timer != null) {
                timer.cancel();
            }
        }
        return out.toString();
    }

    @Override
    public void send(String cmd, CliResponse r) throws IOException {
        if (cmd == null || cmd.length() == 0) {
            return;
        }
        if (r == null) {
            return;
        }
        Thread worker = new Thread(new ProcessCliResponse(this.session, cmd, r, SLEEP));
        worker.start();
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
            this.credential = null;
        }
    }

    @Override
    public Session getJschSession() {
        return this.session;
    }

    @Override
    public final SshCredential getCredential() {
        return this.credential;
    }

    @Override
    public void setSessionTimeout(int timeout) {
        this._SessionTimeout = timeout;
    }
}

