/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.sshexec.impl.nxos611;

import com.cisco.dcbu.lib.sshexec.IFmCliAdapter;
import com.cisco.dcbu.lib.sshexec.impl.CliAdapter;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class FmCliAdapter
extends CliAdapter
implements IFmCliAdapter {
    static final Logger _Logger = Logger.getLogger((String)"fm.adapter");
    protected Channel channel = null;
    protected OutputStream outS = null;
    protected InputStream inS = null;
    protected Session session = null;
    private String hostIp = null;
    private volatile boolean stop = false;
    private volatile boolean getResult = false;
    protected BlockingQueue<Integer> resultQ = new LinkedBlockingQueue<Integer>();
    protected StringBuilder resultBuff = new StringBuilder();
    protected Map<String, Integer> cmdHash = null;
    public static final String ESCAPE_FOR_HELP = new String(new byte[]{27, 91});
    public static final String ESCAPE_FOR_AUTO_CPLT = new String(new byte[]{27, 91, 74});
    public static final int SESSION_TIMEOUT = 1800000;

    public FmCliAdapter(String host, String userName, String password) throws Exception {
        super(host, userName, password, 1800000);
        this.hostIp = host;
        this.cmdHash = new HashMap<String, Integer>();
        this.init();
    }

    private void init() throws Exception {
        this.session = this.transport.getJschSession();
        if (this.session == null) {
            throw new Exception("Can not get the cli session.");
        }
        this.channel = this.session.openChannel("shell");
        this.outS = this.channel.getOutputStream();
        this.inS = this.channel.getInputStream();
        this.channel.connect();
        if (this.channel.isClosed()) {
            throw new Exception("Channel is closed.");
        }
        Thread readerThread = new Thread(new CmdReader(this.resultQ));
        Thread writerThread = new Thread(new CmdWriter(this.resultQ, this.resultBuff));
        readerThread.setName("ReaderThread for " + this.hostIp);
        writerThread.setName("WriterThread for " + this.hostIp);
        readerThread.start();
        writerThread.start();
    }

    public void addCmd(String cmdStr) {
        if (this.cmdHash.containsKey(cmdStr)) {
            return;
        }
        this.cmdHash.put(cmdStr, 1);
    }

    @Override
    public boolean isEOF() {
        return this.channel.isEOF();
    }

    @Override
    public void runCli(String cmd) throws Exception {
        this.addCmd(cmd);
        try {
            byte[] bArr = cmd.getBytes();
            this.outS.write(bArr, 0, bArr.length);
            this.outS.flush();
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            this.close();
            throw new Exception("The connection has been closed, please close the pod and reconnect.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        try {
            this.stop = true;
            this.getResult = true;
            this.inS.close();
            this.outS.close();
            if (this.channel != null) {
                this.channel.disconnect();
            }
            this.resultBuff.delete(0, this.resultBuff.length());
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.transport.close();
        }
    }

    @Override
    public String getCliResult() throws Exception {
        if (this.channel.isClosed()) {
            throw new Exception("Connection to host lost.");
        }
        this.getResult = true;
        if (this.stop) {
            this.close();
            return "Connection to host lost.";
        }
        String resultStr = this.resultBuff.toString();
        this.resultBuff.delete(0, this.resultBuff.length());
        System.out.println("buf size: " + this.resultBuff.length());
        this.getResult = false;
        return resultStr;
    }

    @Override
    public StringBuilder getStrBudr() throws Exception {
        return this.resultBuff;
    }

    class CmdWriter
    implements Runnable {
        private BlockingQueue<Integer> bq = null;
        private StringBuilder sBuff = null;

        public CmdWriter(BlockingQueue<Integer> que, StringBuilder sb) {
            this.bq = que;
            this.sBuff = sb;
        }

        @Override
        public void run() {
            _Logger.info((Object)"Start to write the cli to string.");
            while (!FmCliAdapter.this.stop) {
                try {
                    while (!FmCliAdapter.this.getResult) {
                        try {
                            char vlu = (char)this.bq.take().intValue();
                            if (vlu == '\r') continue;
                            this.sBuff.append(vlu);
                        }
                        catch (Exception ex) {
                            _Logger.warn((Object)ex.getMessage());
                            break;
                        }
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage());
                }
            }
            _Logger.info((Object)"Done with write thread");
        }
    }

    class CmdReader
    implements Runnable {
        private BlockingQueue<Integer> bq = null;

        public CmdReader(BlockingQueue<Integer> que) {
            this.bq = que;
        }

        @Override
        public void run() {
            _Logger.info((Object)"Start to accept the cli result.");
            while (!FmCliAdapter.this.stop) {
                try {
                    int rstB = FmCliAdapter.this.inS.read();
                    this.bq.put(rstB);
                    if (rstB != -1) continue;
                    FmCliAdapter.this.stop = true;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage());
                    break;
                }
            }
            _Logger.info((Object)"Done with result thread");
        }
    }
}

