/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import com.cisco.dcbu.lib.ui.FieldPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

final class ArrowButtonHandler
extends MouseAdapter
implements ActionListener {
    final Timer _autoRepeatTimer;
    final boolean _isUp;
    FieldPanel _field;

    ArrowButtonHandler(boolean isUp) {
        this._isUp = isUp;
        this._autoRepeatTimer = new Timer(60, this);
        this._autoRepeatTimer.setInitialDelay(300);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._field == null) {
            return;
        }
        if (this._field._field.getText().length() == 0) {
            this._field._field.setText(Integer.toString(this._field._min));
        } else {
            try {
                int n = FieldPanel.getNumber(this._field._field.getText());
                if (this._isUp && n < this._field._max) {
                    this._field._field.setText(Integer.toString(n + 1));
                } else if (!this._isUp && n > this._field._min) {
                    this._field._field.setText(Integer.toString(n - 1));
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (NumberFormatException ex) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getComponent().isEnabled()) {
            this._autoRepeatTimer.start();
            Container c = ((Component)e.getSource()).getParent().getParent();
            if (c instanceof FieldPanel) {
                this._field = (FieldPanel)c;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this._autoRepeatTimer.stop();
        KeyListener[] kl = this._field._field.getKeyListeners();
        if (kl != null) {
            KeyEvent ke = new KeyEvent(this._field._field, 0, 0L, 0, 0, 'x');
            for (int i = 0; i < kl.length; ++i) {
                kl[i].keyReleased(ke);
            }
        }
        this._field = null;
    }
}

