/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class GroupButtonPanel
extends JPanel {
    public static final int GRID_WIDTH = 3;
    JToggleButton[] _components = null;

    public GroupButtonPanel(Object[] choices, int gridWidth) {
        if (choices.length <= gridWidth) {
            this.setLayout(new BoxLayout(this, 0));
        } else {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new GridLayout(-1, gridWidth));
        }
        this.setChoices(choices);
    }

    public GroupButtonPanel(Object[] choices) {
        this(choices, 3);
    }

    public void setChoices(Object[] choices) {
        if (choices == null) {
            this.clearChoices();
            return;
        }
        this._components = new JToggleButton[choices.length];
        for (int i = 0; i < choices.length; ++i) {
            this._components[i] = this.makeButton(choices[i].toString());
            this.add(this._components[i]);
        }
    }

    public JToggleButton[] getButtons() {
        return this._components;
    }

    public void clearChoices() {
        if (this._components == null) {
            return;
        }
        for (int i = 0; i < this._components.length; ++i) {
            this.remove(this._components[i]);
            this._components[i] = null;
        }
        this._components = null;
    }

    public JToggleButton makeButton(String label) {
        return new JToggleButton(label);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._components != null) {
            for (int i = 0; i < this._components.length; ++i) {
                this._components[i].setEnabled(enabled);
            }
        }
        super.setEnabled(enabled);
    }

    public final JToggleButton getButton(int index) {
        return this._components != null && index < this._components.length ? this._components[index] : null;
    }

    public JToggleButton getButton(String label) {
        if (this._components == null) {
            return null;
        }
        for (int i = 0; i < this._components.length; ++i) {
            if (!this._components[i].getText().equals(label)) continue;
            return this._components[i];
        }
        return null;
    }

    public int getSelected() {
        if (this._components == null) {
            return -1;
        }
        for (int i = 0; i < this._components.length; ++i) {
            if (!this._components[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    public Object getSelectedValue() {
        if (this._components == null) {
            return null;
        }
        for (int i = 0; i < this._components.length; ++i) {
            if (!this._components[i].isSelected()) continue;
            return this._components[i].getText();
        }
        return null;
    }

    public final void setSelected(int index) {
        if (this._components == null) {
            return;
        }
        if (index < this._components.length) {
            this._components[index].setSelected(true);
        }
    }

    public final void setSelected(int index, boolean bSelected) {
        if (this._components == null) {
            return;
        }
        if (index < this._components.length) {
            this._components[index].setSelected(bSelected);
        }
    }

    public void clearSelection() {
        if (this._components == null) {
            return;
        }
        for (int i = 0; i < this._components.length; ++i) {
            this._components[i].setSelected(false);
        }
    }

    public void selectAllSelection() {
        if (this._components == null) {
            return;
        }
        for (int i = 0; i < this._components.length; ++i) {
            this._components[i].setSelected(true);
        }
    }

    @Override
    public void setFont(Font font) {
        if (this._components != null) {
            for (int i = 0; i < this._components.length; ++i) {
                this._components[i].setFont(font);
            }
        }
    }

    public void addChangeListener(ItemListener l) {
        if (this._components == null) {
            return;
        }
        for (int i = 0; i < this._components.length; ++i) {
            this._components[i].addItemListener(l);
        }
    }

    public boolean isChanged() {
        if (this._components == null) {
            return false;
        }
        for (int i = 0; i < this._components.length; ++i) {
            if (this._components[i].getFont() != ChangedCellRenderer.getChangeFont()) continue;
            return true;
        }
        return false;
    }
}

