/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.table;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.MultiLineHeaderCapable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.StringUtil;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.BitSet;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class KTableModel
extends AbstractTableModel
implements MultiLineHeaderCapable {
    private String[] _headers;
    protected int _headerLines = 1;
    Array _data;
    boolean[] _editable;
    boolean[] _emptyColumnsHidable;
    protected int _sortColumn;
    protected boolean _ascending;
    Component _errorComponent;

    public final String[] getHeaders() {
        return this._headers;
    }

    private void checkHeaderLines() {
        this._headerLines = 1;
        if (this._headers != null) {
            for (int i = 0; i < this._headers.length; ++i) {
                int count;
                if (this._headers[i] == null || this._headers[i].length() <= 0 || this._headers[i].charAt(0) != '<' || (count = StringUtil.countSubstrings(this._headers[i], "<br>") + 1) <= this._headerLines) continue;
                this._headerLines = count;
            }
        }
    }

    @Override
    public int getHeaderLines() {
        return this._headerLines;
    }

    public String getColumnNameWithoutHtml(int col) {
        String s = this._headers[col];
        if (s != null && s.startsWith("<html>")) {
            return s.substring(6).replaceAll("<br>", " ");
        }
        return s;
    }

    public final void setHeaders(String[] h) {
        this._headers = h;
        this.checkHeaderLines();
    }

    public final void setHeader(int index, String h) {
        this._headers[index] = h;
        this.checkHeaderLines();
    }

    public final Array getData() {
        return this._data;
    }

    public final void setData(Array data) {
        this._data = data;
    }

    public boolean[] getEditable() {
        return this._editable;
    }

    public void setEditable(boolean[] editable) {
        this._editable = editable;
    }

    public void setEditable(int index, boolean editable) {
        this._editable[index] = editable;
    }

    public final boolean[] getEmptyColumnsHidable() {
        return this._emptyColumnsHidable;
    }

    public final boolean isEmptyColumnHidable(int column) {
        if (this._emptyColumnsHidable == null || column >= this._emptyColumnsHidable.length) {
            return false;
        }
        return this._emptyColumnsHidable[column];
    }

    public final void setEmptyColumnsHidable(boolean[] emptyColumnsHidable) {
        this._emptyColumnsHidable = emptyColumnsHidable;
    }

    public final void setEmptyColumnsHidable(int index, boolean emptyColumnsHidable) {
        this._emptyColumnsHidable[index] = emptyColumnsHidable;
    }

    public final boolean isAscending() {
        return this._ascending;
    }

    public final void setErrorComponent(Component errorComponent) {
        this._errorComponent = errorComponent;
    }

    public final Component getErrorComponent() {
        return this._errorComponent;
    }

    @Override
    public int getColumnCount() {
        return this._headers == null ? 0 : this._headers.length;
    }

    @Override
    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this._headers[col];
    }

    public Class getColumnClass(int c) {
        Object o = this.getValueAt(0, c);
        if (o == null) {
            return String.class;
        }
        return o.getClass();
    }

    public Class getColumnClass(int r, int c) {
        Object o = this.getValueAt(r, c);
        if (o == null) {
            return String.class;
        }
        return o.getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this._data == null || row >= this._data.size()) {
            return null;
        }
        Object[] rowData = (Object[])this._data.elementAt(row);
        if (col > rowData.length - 1) {
            return null;
        }
        return rowData[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this._editable != null && this._editable.length > col) {
            if (this._data != null && this._data.size() > 0) {
                return this.isCellActive(row, col) && this._editable[col];
            }
            return this._editable[col];
        }
        return false;
    }

    public boolean isCellActive(int row, int col) {
        return true;
    }

    public boolean isNoSuchInstance(int row, int col) {
        return false;
    }

    public void markUndo(int row, int col, Object aValue) {
        Object[] values = (Object[])this._data.elementAt(row);
        Object[] changed = (Object[])values[this._headers.length];
        if (changed == null) {
            changed = new Object[this._headers.length];
            values[this._headers.length] = changed;
        }
        if (changed[col] == null) {
            changed[col] = values[col] == null ? "" : values[col];
        } else {
            String aValueStr;
            String changedStr = changed[col].toString() != null ? changed[col].toString() : "";
            String string = aValueStr = aValue != null && aValue.toString() != null ? aValue.toString() : "";
            if (changedStr.equals(aValueStr)) {
                changed[col] = null;
            }
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        Object[] values = (Object[])this._data.elementAt(row);
        if (aValue == null) {
            return;
        }
        if (values[col] != null && (aValue == values[col] || aValue.toString().equals(values[col].toString()))) {
            return;
        }
        if (aValue.getClass() == this.getColumnClass(row, col)) {
            this.assignCellValueSameClass(aValue, row, col, values);
            this.normalizeChangedDataCell(row, col);
        } else {
            try {
                this.assignCellValue(aValue, row, col, values);
                this.normalizeChangedDataCell(row, col);
            }
            catch (InvocationTargetException ex) {
                String msg;
                Exception realEx = (Exception)ex.getTargetException();
                if (realEx == null) {
                    realEx = ex;
                }
                if ((msg = realEx.getMessage()).length() == 0) {
                    msg = "(row=" + (row + 1) + ",col=" + (col + 1) + ")  Bad assignment";
                }
                Util.errorMessage(this._errorComponent, msg);
            }
            catch (NoSuchMethodException ex) {
                String str = aValue.toString();
                if (str.equals("")) {
                    str = "\"\"";
                }
                Util.errorMessage(this._errorComponent, this._headers[col] + " can't be assigned to " + str);
            }
            catch (Exception ex) {
                Util.errorMessage(this._errorComponent, ex);
            }
        }
        this.fireTableChanged(new TableModelEvent(this, row, row, col, 0));
    }

    private void normalizeChangedDataCell(int row, int col) {
        Object[] values = (Object[])this._data.elementAt(row);
        Object[] changed = (Object[])values[this._headers.length];
        if (changed != null && changed[col] == null) {
            for (int i = 0; i < changed.length; ++i) {
                if (changed[i] == null) continue;
                return;
            }
            values[this._headers.length] = null;
        }
    }

    protected void assignCellValue(Object aValue, int row, int col, Object[] values) throws Exception {
        Class c = this.getColumnClass(row, col);
        Class[] types = new Class[]{aValue.getClass()};
        Constructor con = c.getConstructor(types);
        Object[] params = new Object[]{aValue};
        Object newValue = con.newInstance(params);
        this.markUndo(row, col, aValue);
        values[col] = newValue;
    }

    protected void assignCellValueSameClass(Object aValue, int row, int col, Object[] values) {
        this.markUndo(row, col, aValue);
        values[col] = aValue;
    }

    public Array getChanged() {
        if (this._data == null) {
            return null;
        }
        Array<Cell> cells = null;
        for (int r = 0; r < this._data.size(); ++r) {
            Object[] changed = (Object[])((Object[])this._data.elementAt(r))[this._headers.length];
            if (changed == null) continue;
            if (cells == null) {
                cells = new Array<Cell>();
            }
            for (int c = 0; c < this._headers.length; ++c) {
                if (changed[c] == null || !this.isCellActive(r, c)) continue;
                cells.addElement(new Cell(r, c));
            }
        }
        return cells;
    }

    public Object getChanged(int row, int col) {
        Object[] changed;
        if (this._editable == null || !this._editable[col] || row >= this._data.size()) {
            return null;
        }
        Object cacheOb = ((Object[])this._data.elementAt(row))[this._headers.length];
        Object[] objectArray = changed = cacheOb != null && cacheOb instanceof Object[] ? (Object[])cacheOb : null;
        if (changed == null) {
            return null;
        }
        return changed[col];
    }

    public boolean isChanged() {
        if (this._data == null) {
            return false;
        }
        for (int r = 0; r < this._data.size(); ++r) {
            Object[] changed = (Object[])((Object[])this._data.elementAt(r))[this._headers.length];
            if (changed == null) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(int row, int col) {
        if (this._editable == null || col > this._editable.length || !this._editable[col] || row >= this._data.size()) {
            return false;
        }
        Object[] changed = (Object[])((Object[])this._data.elementAt(row))[this._headers.length];
        if (changed == null) {
            return false;
        }
        return changed[col] != null;
    }

    public final void undo() {
        this.resetChanges(true);
    }

    public void resetChanges(boolean undo) {
        if (this._data == null || this._editable == null) {
            return;
        }
        for (int r = 0; r < this._data.size(); ++r) {
            Object[] values = (Object[])this._data.elementAt(r);
            if (undo) {
                Object[] changed = (Object[])values[this._headers.length];
                if (changed == null) continue;
                for (int c = 0; c < this._headers.length; ++c) {
                    if (changed[c] == null) continue;
                    values[c] = changed[c];
                }
            }
            values[this._headers.length] = null;
        }
        this.fireTableDataChanged();
    }

    public void sort(int sortColumn, boolean ascending) {
        this.sort(sortColumn, ascending, null);
    }

    public void sort(int sortColumn, boolean ascending, ListSelectionModel selection) {
        this._sortColumn = sortColumn;
        this._ascending = ascending;
        Object[] from = new Object[this._data.size()];
        for (int i = 0; i < from.length; ++i) {
            from[i] = this._data.elementAt(i);
        }
        KTableModel.shuttlesort(this, from, this._data._elementData, 0, from.length, selection);
        this.performPostSorting();
    }

    protected void performPostSorting() {
    }

    public int compare(Object first, Object second) {
        String secondStr;
        if (first == second) {
            return 0;
        }
        if (first == null) {
            return -1;
        }
        if (second == null) {
            return 1;
        }
        if (first instanceof Number && second instanceof Number) {
            int i1 = ((Number)first).intValue();
            int i2 = ((Number)second).intValue();
            return i1 - i2;
        }
        if (first instanceof Boolean && second instanceof Boolean) {
            boolean b2;
            boolean b1 = (Boolean)first;
            if (b1 == (b2 = ((Boolean)second).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        if (first instanceof Comparable && second instanceof Comparable && !(first instanceof String) && !(second instanceof String)) {
            return ((Comparable)first).compareTo(second);
        }
        String firstStr = first.toString();
        if (firstStr.equals(secondStr = second.toString())) {
            return 0;
        }
        if (firstStr == null) {
            return -1;
        }
        if (secondStr == null) {
            return 1;
        }
        if (firstStr.matches("\\d+") && secondStr.matches("\\d+")) {
            return Integer.parseInt(firstStr) - Integer.parseInt(secondStr);
        }
        return firstStr.compareToIgnoreCase(secondStr);
    }

    public int compareTo(Object o1, Object o2) {
        Object first = this.getSortColumnObj(o1);
        Object second = this.getSortColumnObj(o2);
        if (first == null && second == null) {
            return 0;
        }
        if (first == null) {
            return this._ascending ? -1 : 1;
        }
        if (second == null) {
            return this._ascending ? 1 : -1;
        }
        int result = this.compare(first, second);
        return this._ascending ? result : -result;
    }

    protected Object getSortColumnObj(Object row) {
        return ((Object[])row)[this._sortColumn];
    }

    public static void shuttlesort(KTableModel model, Object[] from, Object[] to, int low, int high, ListSelectionModel selection) {
        int i;
        BitSet listSelection = new BitSet(high - low);
        boolean anySelection = false;
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        KTableModel.shuttlesort(model, to, from, low, middle, selection);
        KTableModel.shuttlesort(model, to, from, middle, high, selection);
        int p = low;
        int q = middle;
        if (high - low >= 4 && model.compareTo(from[middle - 1], from[middle]) <= 0) {
            for (i = low; i < high; ++i) {
                to[i] = from[i];
            }
        } else {
            for (i = low; i < high; ++i) {
                if (q >= high || p < middle && model.compareTo(from[p], from[q]) <= 0) {
                    if (selection != null && selection.isSelectedIndex(p)) {
                        listSelection.set(low + i);
                        if (!anySelection) {
                            anySelection = true;
                        }
                    }
                    to[i] = from[p++];
                    continue;
                }
                if (selection != null && selection.isSelectedIndex(q)) {
                    listSelection.set(low + i);
                    if (!anySelection) {
                        anySelection = true;
                    }
                }
                to[i] = from[q++];
            }
        }
        if (selection != null && anySelection) {
            selection.removeSelectionInterval(low, high - 1);
        }
        for (i = low; i < high; ++i) {
            if (selection != null && anySelection && listSelection.get(low + i)) {
                selection.addSelectionInterval(i, i);
            }
            from[i] = to[i];
        }
    }

    public boolean isPopulated() {
        return true;
    }

    public int get_sortColumn() {
        return this._sortColumn;
    }
}

