/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.tree;

import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.tree.TreeTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.CellEditor;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable
implements TreeExpansionListener {
    protected TreeTableCellRenderer tree;
    private TreeTableModelAdapter adapter;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.tree.addTreeExpansionListener(this);
        this.adapter = new TreeTableModelAdapter(treeTableModel, this.tree);
        super.setModel(this.adapter);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setClosedIcon(null);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setLeafIcon(null);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
        this.setBackground(KTable._BgColor);
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path = JTreeTable.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    if (JTreeTable.this.tree.isPathSelected(path)) {
                        JTreeTable.this.tree.removeSelectionPath(path);
                    } else {
                        JTreeTable.this.tree.addSelectionPath(path);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public TreeTableModelAdapter getAdapter() {
        return this.adapter;
    }

    public TreeTableCellRenderer getTree() {
        return this.tree;
    }

    public Object getFileNodeForRow(int selectedRow) {
        TreePath path = this.tree.getPathForRow(selectedRow);
        return path.getLastPathComponent();
    }

    public Object[] getFullPathForRow(int selectedRow) {
        TreePath path = this.tree.getPathForRow(selectedRow);
        Object[] pathArray = path.getPath();
        return pathArray;
    }

    public String getNodeNameForRow(int selectedRow) {
        TreePath path = this.tree.getPathForRow(selectedRow);
        return (String)path.getLastPathComponent();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent e) {
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent e) {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
        this.setBackground(KTable._BgColor);
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public class TreeTableModelAdapter
    extends AbstractTableModel {
        JTree tree;
        TreeTableModel treeTableModel;

        public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
            this.tree = tree;
            this.treeTableModel = treeTableModel;
            tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
            treeTableModel.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    TreeTableModelAdapter.this.delayedFireTableDataChanged();
                }
            });
        }

        @Override
        public int getColumnCount() {
            return this.treeTableModel.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return this.treeTableModel.getColumnName(column);
        }

        public Class getColumnClass(int column) {
            return this.treeTableModel.getColumnClass(column);
        }

        @Override
        public int getRowCount() {
            return this.tree.getRowCount();
        }

        protected Object nodeForRow(int row) {
            TreePath treePath = this.tree.getPathForRow(row);
            if (treePath != null) {
                return treePath.getLastPathComponent();
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
        }

        protected void delayedFireTableDataChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }
    }

    public class AbstractCellEditor
    implements CellEditor {
        protected EventListenerList listenerList = new EventListenerList();

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(CellEditorListener.class, l);
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                ((CellEditorListener)listeners[i + 1]).editingStopped(new ChangeEvent(this));
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                ((CellEditorListener)listeners[i + 1]).editingCanceled(new ChangeEvent(this));
            }
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            if (isSelected) {
                JTreeTable.this.setBackground(JTreeTable.this.getSelectionBackground());
            } else {
                JTreeTable.this.setBackground(KTable._BgColor);
            }
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.setBackground(KTable._BgColor);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foreground;
            Color background;
            if (isSelected) {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            } else {
                background = table.getBackground();
                foreground = table.getForeground();
            }
            this.visibleRow = row;
            this.setBackground(background);
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (isSelected) {
                    dtcr.setTextSelectionColor(foreground);
                    dtcr.setBackgroundSelectionColor(background);
                } else {
                    dtcr.setTextNonSelectionColor(foreground);
                    dtcr.setBackgroundNonSelectionColor(background);
                }
            }
            return this;
        }
    }
}

