/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.wizard;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardNavigator;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JWizard
extends JDialog {
    protected JPanel _pane;
    CardLayout _layout;
    protected Array _cards = new Array();
    protected int _currentCardIndex;
    protected WizardNavigator _nav;
    protected HashMap _model = new HashMap();
    JLabel _status;
    JPanel _main = new JPanel(new BorderLayout());
    JPanel _north = null;

    @Override
    public void dispose() {
        if (this._nav != null) {
            this._nav.dispose();
        }
        this._nav = null;
        this._model = null;
        this.disposeAllPanels();
        if (this._cards != null) {
            this._cards.clear();
        }
        this._cards = null;
        this._layout = null;
        this._pane = null;
        this._main = null;
        this._north = null;
        super.dispose();
    }

    private synchronized void disposeAllPanels() {
        while (this._cards != null && this._cards.size() > 0) {
            Object[] o = (Object[])this._cards.elementAt(this._cards.size() - 1);
            WizardPanel wPanel = (WizardPanel)o[1];
            this._pane.remove(wPanel);
            this._cards.removeElementAt(this._cards.size() - 1);
            wPanel.dispose();
        }
    }

    public JWizard(Frame parent) {
        super(parent);
        this._layout = new CardLayout();
        this._pane = new JPanel(this._layout);
        this._main.add((Component)this._pane, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        this._nav = new WizardNavigator(this);
        southPanel.add("Center", this._nav);
        this._status = new JLabel(" ");
        this._status.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this._status.setBorder(null);
        southPanel.add("South", this._status);
        this._main.add((Component)southPanel, "South");
        this.getContentPane().add(this._main);
        this.setLocationRelativeTo(parent);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
    }

    public void setBusy(boolean busy) {
        Util.setBusy(busy, this.getRootPane());
    }

    public void setStatus(String status) {
        this._status.setText(status);
    }

    public WizardNavigator getNavigator() {
        return this._nav;
    }

    public void addPanel(String cardName, Component panel) {
        this._pane.add(cardName, panel);
        this._cards.addElement(new Object[]{cardName, panel});
    }

    public Object[] getPanelComponentAt(int index) {
        Object[] o = (Object[])this._cards.elementAt(index - 1);
        return o;
    }

    public void removePanelAt(int index) {
        Object[] o = (Object[])this._cards.elementAt(index - 1);
        WizardPanel wPanel = (WizardPanel)o[1];
        this._pane.remove(wPanel);
        this._cards.removeElementAt(index - 1);
    }

    public void removeAllPanelAfterCurrent() {
        while (this._currentCardIndex + 1 < this.getPanelCount()) {
            this.removePanelAt(this._currentCardIndex + 2);
        }
    }

    public int getPanelCount() {
        return this._cards != null ? this._cards.size() : 0;
    }

    public WizardPanel getCurrent() {
        if (this._cards == null) {
            return null;
        }
        Object[] o = null;
        if (this._currentCardIndex > -1) {
            o = (Object[])this._cards.elementAt(this._currentCardIndex);
        }
        if (o != null && o.length > 0) {
            return (WizardPanel)o[1];
        }
        return null;
    }

    public WizardPanel get(int index) {
        if (index >= 0 && index < this._cards.size()) {
            Object[] o = (Object[])this._cards.elementAt(index);
            return (WizardPanel)o[1];
        }
        return null;
    }

    public WizardPanel getNext() {
        if (this._currentCardIndex == this._cards.size() - 1) {
            return null;
        }
        Object[] o = (Object[])this._cards.elementAt(this._currentCardIndex + 1);
        return (WizardPanel)o[1];
    }

    public WizardPanel getPrevious() {
        if (this._currentCardIndex == 0) {
            return null;
        }
        Object[] o = (Object[])this._cards.elementAt(this._currentCardIndex - 1);
        return (WizardPanel)o[1];
    }

    public void first() {
        this._layout.first(this._pane);
        this._currentCardIndex = 0;
        this.updateNavBtn();
        this.updateTitleDescArea();
    }

    public void next() {
        this._layout.next(this._pane);
        ++this._currentCardIndex;
        this.updateNavBtn();
        this.updateTitleDescArea();
        this.setVisiblePane(this.getCurrent());
    }

    public void previous() {
        this._layout.previous(this._pane);
        --this._currentCardIndex;
        this.updateNavBtn();
        this.updateTitleDescArea();
    }

    public void last() {
        this._layout.last(this._pane);
        this._currentCardIndex = this._cards.size() - 1;
        this.updateNavBtn();
        this.updateTitleDescArea();
    }

    public void show(String cardName) {
        this._layout.show(this._pane, cardName);
        for (int i = 0; i < this._cards.size(); ++i) {
            Object[] o = (Object[])this._cards.elementAt(i);
            if (!o[0].equals(cardName)) continue;
            this._currentCardIndex = i;
            break;
        }
        this.updateNavBtn();
        this.updateTitleDescArea();
    }

    public void updateTitleDescArea() {
        WizardPanel current = this.getCurrent();
        if (current != null) {
            if (this._north != null) {
                this._main.remove(this._north);
            }
            this._north = current.getNorthDescPanel();
            this._main.add((Component)this._north, "North");
        }
        this.repaint();
    }

    public void updateNavBtn() {
        this._nav.setButtonAttr(this._currentCardIndex > 0, this._currentCardIndex == this._cards.size() - 1);
    }

    public void setModelValue(String name, Object value) {
        this._model.put(name, value);
    }

    public Object getModelValue(String name) {
        return this._model.get(name);
    }

    public void setVisiblePane(WizardPanel pnl) {
        for (int i = 0; i < this._pane.getComponentCount(); ++i) {
            Component cmp;
            cmp.setVisible((cmp = this._pane.getComponent(i)) == pnl);
        }
    }

    public int getCurrentCardIndex() {
        return this._currentCardIndex + 1;
    }
}

