/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import java.util.Date;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;

public class Log4jUtil {
    static final String DEFAULT_THRESHOLD = "ALL";
    static final String DEFAULT_FILE_SIZE = "1MB";
    static final Level DEFAULT_LOG_LEVEL = Level.DEBUG;
    static final int DEFAULT_BACKUPS = 5;

    public static Logger createNewLog(String logfile) {
        return Log4jUtil.createNewLog(null, logfile, DEFAULT_THRESHOLD, DEFAULT_FILE_SIZE, 5);
    }

    public static Logger createNewLog(String loggerName, String logfile) {
        return Log4jUtil.createNewLog(loggerName, logfile, DEFAULT_THRESHOLD, DEFAULT_FILE_SIZE, 5);
    }

    public static Logger createNewLog(String loggerName, String logfile, String threashold, String maxFileSize, int maxBackups) {
        return Log4jUtil.createNewLog(loggerName, logfile, DEFAULT_THRESHOLD, DEFAULT_FILE_SIZE, 5, DEFAULT_LOG_LEVEL);
    }

    public static Logger createNewLog(String loggerName, String logfile, String threashold, String maxFileSize, int maxBackups, Level logLevel) {
        Logger newLogger = null;
        if (logfile != null) {
            PatternLayout layout = new PatternLayout("%d{yyyy.MM.dd HH:mm:ss } %-5p [%c{2}] %m%n");
            RollingFileAppender fileAppender = null;
            try {
                fileAppender = new RollingFileAppender((Layout)layout, logfile);
                fileAppender.setThreshold((Priority)(threashold == null ? Level.ALL : Level.toLevel((String)threashold, (Level)Level.ALL)));
                fileAppender.setMaxFileSize(maxFileSize);
                fileAppender.setMaxBackupIndex(maxBackups);
                fileAppender.activateOptions();
                newLogger = Logger.getLogger((String)(loggerName == null ? "newLogger" + new Date() : loggerName));
                newLogger.addAppender((Appender)fileAppender);
                newLogger.setLevel(Level.DEBUG);
                newLogger.info((Object)"New appender created successfully.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newLogger;
    }

    public static void main(String[] args) {
    }
}

