/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.snmp.VshManager;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MDSProxy {
    public static Logger _Logger = LogManager.getLogger((String)"fms.lib");
    public static final int CONNECTION_FAILED = 0;
    public static final int AUTHEN_FAILED = 1;
    public static final int IS_MDS = 2;
    public static final int NOT_MDS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int verifyMDS(String host, String userName, String authPassword) {
        VshBase vsh = null;
        int result = 0;
        if (host == null || host.trim().length() == 0 || userName == null || userName.trim().length() == 0 || authPassword == null || authPassword.trim().length() == 0) {
            return result;
        }
        try {
            _Logger.debug((Object)("proxy  = " + host));
            vsh = VshManager.getInstance().newVsh(host, userName, authPassword);
            if (vsh != null) {
                result = 3;
                vsh.sendAndReply("show hardware \n");
                String reply = vsh.getReply();
                if (reply != null && reply.length() != 0) {
                    int index = reply.indexOf("MDS");
                    if (index != -1) {
                        result = 2;
                    } else {
                        int index2 = reply.indexOf("mds");
                        if (index2 != -1) {
                            result = 2;
                        }
                    }
                }
            } else {
                result = 1;
            }
        }
        catch (Exception ee) {
            if (ee.getMessage().contains("Invalid Credentials")) {
                result = 1;
            }
            _Logger.debug((Object)("MDS Proxy verification: " + ee.getMessage()));
        }
        finally {
            if (vsh != null) {
                vsh.disconnect();
                vsh = null;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        int result1 = MDSProxy.verifyMDS("172.22.31.14", "admin", "nbv12345");
        int result2 = MDSProxy.verifyMDS("172.22.31.14", "admin", "nbv");
        int result3 = MDSProxy.verifyMDS("172.22.31.183", "admin", "nbv12345");
        int result4 = MDSProxy.verifyMDS("100.22.31.183", "admin", "nbv12345");
        System.out.println("MDS Proxy verification test result(MDS/can be authenticated): " + result1);
        System.out.println("MDS Proxy verification test result(MDS/can not be authenticated): " + result2);
        System.out.println("MDS Proxy verification test result: " + result3);
        System.out.println("MDS Proxy verification test result: " + result4);
    }
}

