/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util.fcoe;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigCommandsIf;
import com.cisco.dcbu.lib.util.fcoe.UnAuthorizedUserException;
import java.io.IOException;
import javax.swing.JFrame;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractFCoEConfigCommands
implements FCoEConfigCommandsIf {
    protected SnmpPeer peer;
    protected JFrame frame;
    protected Vsh vsh;
    protected SwitchAttrIf selectedSwitch;
    static Logger _logger = LogManager.getLogger((String)"fms.fcoe");
    public static String AUTHORIZATIONERROR = "Could not open a SSH/Telnet connection to the switch. \n Please verify telnet or secure shell server feature is enabled on the switch and user has the right privileges.";

    protected AbstractFCoEConfigCommands() {
    }

    protected AbstractFCoEConfigCommands(JFrame frame, SnmpPeer peer, SwitchAttrIf selectedSwitch) {
        this.update(frame, peer, selectedSwitch);
    }

    @Override
    public void connect() throws IOException, UnAuthorizedUserException {
        if (this.vsh == null || this.vsh._disconnected) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"AbstractFCoEConfigCommands : Opening a SSH/Telnet connection to the switch.");
            }
            Vsh.setTimeout(0);
            this.vsh = Vsh.get(this.frame, this.peer, true);
        }
        if (this.vsh == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"AbstractFCoEConfigCommands : Could not open a SSH/Telnet connection to the switch, User might not have the privilege.");
            }
            throw new UnAuthorizedUserException(AUTHORIZATIONERROR);
        }
    }

    protected void update(JFrame frame, SnmpPeer peer, SwitchAttrIf selectedSwitch) {
        this.frame = frame;
        this.peer = peer;
        this.selectedSwitch = selectedSwitch;
    }

    public String readPrompt() throws IOException {
        return this.vsh.readPrompt();
    }

    @Override
    public void disconnect() {
        if (this.vsh != null && !this.vsh._disconnected) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"AbstractFCoEConfigCommands : Closing the SSH/Telnet connection to the switch.");
            }
            this.vsh.disconnect();
        }
    }

    public void sendCommand(String cmd) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("AbstractFCoEConfigCommands : sendCommand() Sending the command >>>>>" + cmd));
        }
        if (this.vsh == null || this.vsh._disconnected) {
            throw new UnAuthorizedUserException("Could not open a SSH/Telnet connection to the switch. \n Please verify telnet or secure shell server feature is enabled on the switch and user has the right privileges.");
        }
        this.vsh.send(cmd + "\n");
    }

    @Override
    public boolean isTelnetSSHEnabled() {
        SnmpPDU resp;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"AbstractFCoEConfigCommands : isTelnetSSHEnabled() Checking if SSH or Telnet feature is enabled on the switch .");
        }
        int FEATURE_ENABLED = 1;
        SnmpPeer peer = Discover.getPeer();
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cssServiceActivation").getOid(), 0)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cseSysTelnetServiceActivation").getOid(), 0)));
        try {
            resp = SnmpFetch.get(peer, vbl);
        }
        catch (SnmpException e) {
            return true;
        }
        VarBindList vblResp = resp.getVariables();
        if (vblResp.size() < 2) {
            return false;
        }
        int sshStatus = vblResp.intValue(0);
        int telnetStatus = vblResp.intValue(1);
        if (telnetStatus != FEATURE_ENABLED && sshStatus != FEATURE_ENABLED) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"AbstractFCoEConfigCommands : isTelnetSSHEnabled() Both SSH and Telnet features are disabled on the switch .");
            }
            return false;
        }
        return true;
    }

    public void finalize() {
        this.disconnect();
    }
}

