/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util.fcoe;

import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.fcoe.N7KFCoEConfigurationCommands;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;

public class MDSFCoEConfigurationCommands
extends N7KFCoEConfigurationCommands {
    private static final String MDS_SHOW_ETH_PCHNL_CMD = "show ethernet-port-channel database";

    public MDSFCoEConfigurationCommands(JFrame frame, SnmpPeer peer, SwitchAttrIf selectedSwitch) {
        super(frame, peer, selectedSwitch);
    }

    @Override
    public HashMap<String, ArrayList<String>> getPortChannelMap() throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this.getClass().getName() + " : getPortChannelMap() Getting the port channel map fromt the switch."));
        }
        this.sendCommand(MDS_SHOW_ETH_PCHNL_CMD);
        String result = this.readPrompt();
        return this._parsePortChannelResults(result);
    }

    @Override
    protected HashMap<String, ArrayList<String>> _parsePortChannelResults(String result) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(this.getClass().getName() + " : _parsePortChannelResults() Parsing the show port channel database command result."));
        }
        String ETHERNET_STR = "Ethernet";
        String PORT_CHANNEL_STR = "ethernet-port-channel";
        String PORTS_STR = "Ports:";
        HashMap<String, ArrayList<String>> _portChannelMap = new HashMap<String, ArrayList<String>>();
        StringReader strReader = new StringReader(result);
        BufferedReader bf = new BufferedReader(strReader);
        try {
            String str = bf.readLine();
            str = bf.readLine();
            String portChannel = null;
            while (str != null) {
                if (!(str = str.trim()).equals("")) {
                    ArrayList<String> ports;
                    String port;
                    String[] data;
                    if (str.startsWith(PORT_CHANNEL_STR)) {
                        ArrayList ports2 = new ArrayList();
                        portChannel = str.substring(PORT_CHANNEL_STR.length(), str.length());
                        _portChannelMap.put(portChannel, ports2);
                    } else if (str.startsWith(PORTS_STR) && str.contains(ETHERNET_STR)) {
                        data = str.split("\\s+");
                        port = data[1];
                        ports = _portChannelMap.get(portChannel);
                        ports.add(port);
                    } else if (str.startsWith(ETHERNET_STR)) {
                        data = str.split("\\s+");
                        port = data[0];
                        ports = _portChannelMap.get(portChannel);
                        ports.add(port);
                    }
                }
                str = bf.readLine();
            }
        }
        catch (Exception ex) {
            Util.errorMessage(null, ex.getMessage());
            throw new IOException("Failed to parse port channel map result.");
        }
        return _portChannelMap;
    }
}

