/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util.jboss_4_2;

import com.cisco.dcbu.lib.util.ClientCache;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBoss_7_2XMLFileParser {
    public static final String jboss7_config = ClientCache.getJBossHome() + File.separator + "standalone" + File.separator + "configuration" + File.separator + "standalone-san.xml";
    static String xmlFile = null;
    static Document dom = null;

    public JBoss_7_2XMLFileParser(String fileName) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (publicId.equals("-//JBoss//DTD JBOSS Security Config 3.0//EN")) {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
                return null;
            }
        });
        xmlFile = fileName;
        dom = builder.parse(new File(fileName));
        System.out.println("Finish loading the xml file.");
    }

    private Element findSecurityNode(NodeList nl) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Element profileElement;
            Node nd = nl.item(i);
            if (!(nd instanceof Element) || !(profileElement = (Element)nd).getNodeName().equalsIgnoreCase("profile")) continue;
            NodeList pChildList = profileElement.getChildNodes();
            for (int j = 0; j < pChildList.getLength(); ++j) {
                Element securityElement;
                Node pNode = pChildList.item(j);
                if (!(pNode instanceof Element) || !(securityElement = (Element)pNode).getAttribute("xmlns").contains("urn:jboss:domain:security")) continue;
                securityElement = (Element)securityElement.getChildNodes().item(1);
                pChildList = securityElement.getChildNodes();
                for (j = 0; j < pChildList.getLength(); ++j) {
                    pNode = pChildList.item(j);
                    if (!(pNode instanceof Element) || !(securityElement = (Element)pNode).getAttribute("name").contains("encrypted-fmds")) continue;
                    return securityElement;
                }
            }
        }
        return null;
    }

    private void updateComponent(String updatedContent) throws Exception {
        Element rootElement = dom.getDocumentElement();
        NodeList nl = rootElement.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            throw new Exception("Fail to parse, File is not formatted correctly!");
        }
        Element securityNode = this.findSecurityNode(nl);
        if (securityNode == null) {
            throw new Exception("Fail to parse, File is not formatted correctly!");
        }
        Element pwdNode = (Element)securityNode.getChildNodes().item(1);
        pwdNode = (Element)pwdNode.getChildNodes().item(1);
        NodeList securityNodes = pwdNode.getChildNodes();
        for (int i = 0; i < securityNodes.getLength(); ++i) {
            Node pNode = securityNodes.item(i);
            if (!(pNode instanceof Element) || !(pwdNode = (Element)pNode).getAttribute("name").contains("password")) continue;
            pwdNode.setAttribute("value", updatedContent);
            return;
        }
        throw new Exception("Couldn't locate the right attribute from the xml file!");
    }

    private void writeXMLFile() throws TransformerFactoryConfigurationError, TransformerException, Exception {
        DOMSource source = new DOMSource(dom);
        File file = new File(xmlFile);
        StreamResult result = new StreamResult(new FileOutputStream(file));
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
    }

    public void updateDsPwd(String updatedContent) throws Exception {
        this.updateComponent(updatedContent);
        this.writeXMLFile();
    }

    public static void main(String[] args) throws Exception {
        JBoss_7_2XMLFileParser xmlParser = new JBoss_7_2XMLFileParser(jboss7_config);
        xmlParser.updateDsPwd("hello world");
    }
}

