/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb.dialogs.security;

import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.InterfacePortsCellEditor;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.portland.lib.util.CommonRoleExtUtil;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;

public class EditCommonRoleExtTable
extends EditTable {
    static final int NAME_MDL_COL_IDX = 0;
    static final int DESC_MDL_COL_IDX = 1;
    static final int VSAN_SCOPE_ENABLE_MDL_COL_IDX = 2;
    static final int VSAN_SCOPE_MDL_COL_IDX = 3;
    static final int VLAN_SCOPE_ENABLE_MDL_COL_IDX = 4;
    static final int VLAN_SCOPE_MDL_COL_IDX = 5;
    static final int INTFACE_SCOPE_ENABLE_MDL_COL_IDX = 6;
    static final int INTFACE_SCOPE_MDL_COL_IDX = 7;

    public EditCommonRoleExtTable(String[] vars) {
        super(vars);
    }

    @Override
    protected SnmpPDU getSetPDU() throws Exception {
        this.preGet();
        return super.getSetPDU();
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        Object[] lRow = new Object[this._vars.length + 2];
        SnmpOID lRoleNameIndex = new SnmpOID(responseOid, this._prefixLen, responseOid.length - this._prefixLen);
        lRow[0] = this.getIndexRenderer() != null && !this._tableModel.isEditable() && this._rowStatus == null ? this.getIndexRenderer().getLabel(lRoleNameIndex.getValue()) : lRoleNameIndex;
        SnmpString lDesc = (SnmpString)pdu.getVar(0);
        lDesc.cacheString(true);
        lRow[1] = lDesc;
        SnmpString lPolicies = (SnmpString)pdu.getVar(1);
        lRow[2] = !SnmpString.getBitBase0(lPolicies.getValue(), 0);
        lRow[4] = !SnmpString.getBitBase0(lPolicies.getValue(), 1);
        lRow[6] = !SnmpString.getBitBase0(lPolicies.getValue(), 2);
        HashMap<Integer, ArrayList<CommonRoleExtUtil.CommonRoleExtScope>> lScopesHash = CommonRoleExtUtil.getInstance().getScopesForRole(this.getPeer(), lRoleNameIndex.getValue());
        lRow[3] = StringUtil.getRangeString(this.getScopes(lScopesHash, 1));
        lRow[5] = StringUtil.getRangeString(this.getScopes(lScopesHash, 2));
        lRow[7] = new SnmpIntList(SnmpIntList.valueOf(this.getScopes(lScopesHash, 3)), (IfIndexIf)Discover.getRoot());
        return lRow;
    }

    private int[] getScopes(HashMap<Integer, ArrayList<CommonRoleExtUtil.CommonRoleExtScope>> scopesHash, int scopeRestriction) {
        if (scopesHash == null) {
            return new int[0];
        }
        ArrayList<CommonRoleExtUtil.CommonRoleExtScope> lList = scopesHash.get(scopeRestriction);
        if (lList == null) {
            return new int[0];
        }
        int[] lScopes = new int[lList.size()];
        int i = 0;
        for (CommonRoleExtUtil.CommonRoleExtScope lScope : lList) {
            lScopes[i] = lScope.getValue();
            ++i;
        }
        return lScopes;
    }

    protected boolean validateChanges(Array cells, SnmpTableModel model, String[] mibVars, String message, int offset) {
        for (int i = 0; i < cells.size(); ++i) {
            SnmpIntList lScopes;
            Cell lCell = (Cell)cells.elementAt(i);
            if (lCell._col == 3 || lCell._col == 5) {
                String scopes = (String)model.getValueAt(lCell._row, lCell._col);
                if (!(lCell._col == 3 ? !CommonRoleExtUtil.validateVlanVsanScopes(this._parent, scopes, "Vsan Scope") : lCell._col == 5 && !CommonRoleExtUtil.validateVlanVsanScopes(this._parent, scopes, "Vlan Scope"))) continue;
                return false;
            }
            if (lCell._col != 7 || CommonRoleExtUtil.validateIntFaceScopes(this._parent, lScopes = (SnmpIntList)model.getValueAt(lCell._row, lCell._col), "Interface Scope", Discover.getRoot())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        super.sendPdu(pdu);
        this.setCFSPending(this.getPeer());
    }

    @Override
    protected void sendDeletePdu(SnmpPDU pdu) throws SnmpException {
        super.sendDeletePdu(pdu);
        this.setCFSPending(this.getPeer());
    }

    @Override
    protected Array getButtons() {
        Array lBtns = super.getButtons();
        lBtns.insertElementAt("Rules...", 0);
        return lBtns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("L");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('L', this._table.getSelectedRowCount() == 1);
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        this.enableButton('L', false);
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'L') {
            String lMsg = this.getStatus();
            this.setStatus("Retrieving features and rules, please wait...");
            this._parent.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new RoleRuleWorker(e, lMsg));
        } else {
            super.doIt(ch, e);
        }
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        InterfacePortsCellEditor lEdtr = new InterfacePortsCellEditor(Discover.getDeviceName(), 3, false, Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{1}), this.getPeer(), 18);
        this._table.getColumnModel().getColumn(this._table.convertColumnIndexToView(7)).setCellEditor(lEdtr);
        this._table.getColumnModel().getColumn(this._table.convertColumnIndexToView(2)).setCellEditor(null);
        this._table.getColumnModel().getColumn(this._table.convertColumnIndexToView(4)).setCellEditor(null);
        this._table.getColumnModel().getColumn(this._table.convertColumnIndexToView(6)).setCellEditor(null);
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new CommonRoleExtTableModel();
    }

    class CommonRoleExtTableModel
    extends DmTableModel {
        CommonRoleExtTableModel() {
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (col == 3 || col == 5 || col == 7) {
                boolean scopeEnabled;
                Object o = this.getValueAt(row, col - 1);
                boolean bl = scopeEnabled = o != null && (Boolean)o != false;
                if (!scopeEnabled) {
                    this.setValueAt("", row, col);
                }
                return scopeEnabled;
            }
            return super.isCellActive(row, col);
        }

        @Override
        public Class getColumnClass(int r, int c) {
            if (c == 7) {
                return SnmpIntList.class;
            }
            return super.getColumnClass(r, c);
        }

        @Override
        public Object getSetValueAt(Object aValue, int row, int col) {
            if (col == 7) {
                try {
                    aValue = new SnmpIntList(aValue.toString().trim(), this.getIfIndexIf(row));
                }
                catch (SnmpException ex) {
                    Util.errorMessage(this.getErrorComponent(), ex);
                }
            } else {
                aValue = super.getSetValueAt(aValue, row, col);
            }
            return aValue;
        }

        @Override
        public SnmpPDU setChangedCells() throws Exception {
            Array lCells = this.getChanged();
            if (lCells == null || lCells.size() == 0) {
                return null;
            }
            ArrayList<Integer> lScopeEnableForRows = new ArrayList<Integer>();
            ArrayList<Integer> lScopesSetForRows = new ArrayList<Integer>();
            SnmpPDU lPdu = new SnmpPDU(-93, new VarBindList());
            SnmpPDU lScopeDelPdu = new SnmpPDU(-93, new VarBindList());
            SnmpPDU lScopePdu = new SnmpPDU(-93, new VarBindList());
            for (int i = 0; i < lCells.size(); ++i) {
                Cell lCell = (Cell)lCells.elementAt(i);
                int lCol = lCell._col;
                int lRow = lCell._row;
                int[] lRoleNameIndex = this.getIndex(lCell._row, lCell._col);
                SnmpOID lOid = new SnmpOID(this._mibNodes[lCell._col].getOid(), lRoleNameIndex);
                if (lCol == 3 || lCol == 5 || lCol == 7) {
                    if (lScopesSetForRows.contains(lRow)) continue;
                    lScopesSetForRows.add(lRow);
                    this.deleteScopes(lScopeDelPdu, lRoleNameIndex);
                    this.addScopes(lScopePdu, lRow);
                    continue;
                }
                if (lCol == 2 || lCol == 4 || lCol == 6) {
                    if (lScopeEnableForRows.contains(lRow)) continue;
                    lScopeEnableForRows.add(lRow);
                    lPdu.addVar(lOid, this.getUpdatedPolicyString(lRow));
                    continue;
                }
                lPdu.addVar(lOid, this.getChangedCell(lRow, lCol));
            }
            if (lPdu != null) {
                EditCommonRoleExtTable.this.getPeer().set(lPdu);
            }
            if (lScopeDelPdu != null) {
                EditCommonRoleExtTable.this.sendDeletePdu(lScopeDelPdu);
            }
            if (lScopePdu != null) {
                EditCommonRoleExtTable.this.getPeer().set(lScopePdu);
            }
            return null;
        }

        private int[] getScopesToBeInserted(Object o, int col) throws Exception {
            int[] lScopeValues = null;
            if (col == 3 || col == 5) {
                Array ids = StringUtil.tokenize(o.toString(), ",", "-", 10, true, 1, 4096, true);
                lScopeValues = new int[ids.size()];
                for (int i = 0; i < ids.size(); ++i) {
                    lScopeValues[i] = (Integer)ids.elementAt(i);
                }
            } else if (col == 7) {
                lScopeValues = SnmpIntList.valueOf(((SnmpIntList)o).getValue());
            }
            return lScopeValues;
        }

        private int getRestrictionToBeInserted(int col) {
            switch (col) {
                case 3: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
                case 7: {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Scope Restriction not defined for col: " + col);
        }

        private void addScopes(SnmpPDU pdu, int row) throws Exception {
            int[] lRoleNameIndex = this.getIndex(row);
            int[] lCols = new int[]{3, 5, 7};
            int lCount = 1;
            for (int lCol : lCols) {
                Object o = this.getValueAt(row, lCol);
                if (o == null || o.toString() == null || o.toString().length() == 0) continue;
                int[] lValues = this.getScopesToBeInserted(o, lCol);
                int rest = this.getRestrictionToBeInserted(lCol);
                if (lValues == null) continue;
                for (int value : lValues) {
                    SnmpOID index = new SnmpOID(lRoleNameIndex, lCount);
                    CommonRoleExtUtil.getInstance().createNewScope(pdu, index.getValue(), new SnmpInt(rest), new SnmpInt(value));
                    ++lCount;
                }
            }
        }

        private void deleteScopes(SnmpPDU pdu, int[] roleNameIndex) throws SnmpException {
            HashMap<Integer, ArrayList<CommonRoleExtUtil.CommonRoleExtScope>> lScopesHash = CommonRoleExtUtil.getInstance().getScopesForRole(EditCommonRoleExtTable.this.getPeer(), roleNameIndex);
            if (lScopesHash != null) {
                int totalScopes = 0;
                for (int lRestType : lScopesHash.keySet()) {
                    ArrayList<CommonRoleExtUtil.CommonRoleExtScope> lScopesList = lScopesHash.get(lRestType);
                    if (lScopesList == null) continue;
                    totalScopes += lScopesList.size();
                }
                if (totalScopes > 0) {
                    int[] lRowStatusOid = MibNode.get("ccreRoleScopeRowStatus").getOid();
                    int[] lFullScopeIndex = new int[roleNameIndex.length + 1];
                    System.arraycopy(roleNameIndex, 0, lFullScopeIndex, 0, roleNameIndex.length);
                    int i = totalScopes;
                    while (i > 0) {
                        lFullScopeIndex[lFullScopeIndex.length - 1] = i--;
                        SnmpOID lOid = new SnmpOID(lRowStatusOid, lFullScopeIndex);
                        pdu.addVar(lOid, new SnmpInt(EditCommonRoleExtTable.this._deleteValue));
                    }
                }
            }
        }

        private SnmpString getUpdatedPolicyString(int row) {
            byte[] b = new byte[1];
            if (!((Boolean)this.getValueAt(row, 2)).booleanValue()) {
                SnmpString.setBitBase0(b, 0);
            }
            if (!((Boolean)this.getValueAt(row, 4)).booleanValue()) {
                SnmpString.setBitBase0(b, 1);
            }
            if (!((Boolean)this.getValueAt(row, 6)).booleanValue()) {
                SnmpString.setBitBase0(b, 2);
            }
            return new SnmpString(b);
        }
    }

    class RoleRuleWorker
    implements Runnable {
        ActionEvent _event;
        String _message;

        public RoleRuleWorker(ActionEvent event, String message) {
            this._event = event;
            this._message = message;
        }

        @Override
        public void run() {
            CommonRoleExtUtil.getInstance().initialize(EditCommonRoleExtTable.this._parent, EditCommonRoleExtTable.this.getPeer());
            int[] lName = ((SnmpOID)EditCommonRoleExtTable.this._tableModel.getValueAt(EditCommonRoleExtTable.this._table.getSelectedRow(), 0)).getValue();
            DialogListener.getInstance().dialogAction("Edit_Role_Rules", lName);
            EditCommonRoleExtTable.this.setStatus(this._message);
            EditCommonRoleExtTable.this._parent.setCursor(Cursor.getDefaultCursor());
        }
    }
}

