/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb.elements;

import com.cisco.dcbu.dm.CollapsibleIf;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.elements.Card;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis_Container;
import com.cisco.dcbu.dmdb.andiamo.elements.CollapseRestoreControl;
import com.cisco.dcbu.dmdb.andiamo.elements.SatChassisIf;
import com.cisco.dcbu.dmdb.andiamo.elements.SystemStatusLED;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.portland.dmdb.N5KDmSystem;
import com.cisco.dcbu.portland.dmdb.elements.Chassis_N5K;
import com.cisco.dcbu.portland.dmdb.elements.N5KFan;
import com.cisco.dcbu.portland.dmdb.elements.N5KPower;
import com.cisco.dcbu.portland.dmdb.elements.UnsupportedSatCard;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;

public abstract class Chassis_Sat
extends Chassis_N5K
implements SatChassisIf,
CollapsibleIf {
    Class[] _ChildrenWhenMinimized = new Class[]{CollapseRestoreControl.class};
    protected int _satSwitchId = -1;
    protected int _satSwitchType = -1;

    public Chassis_Sat() {
        this._CardType = new int[0];
        this._Children = new Class[]{N5KFan.class, N5KPower.class, SystemStatusLED.class, Card.class, CollapseRestoreControl.class};
    }

    public abstract String getExpandedBitmap();

    @Override
    public int getSatSwitchId() {
        return this._satSwitchId;
    }

    @Override
    public int getSatSwitchType() {
        return this._satSwitchType;
    }

    @Override
    public void setSatSwitchId(int satSwitchId) {
        this._satSwitchId = satSwitchId;
    }

    public void setSatSwitchType(int satSwitchType) {
        this._satSwitchType = satSwitchType;
    }

    @Override
    public Point getSatIdOffset() {
        return new Point(40, 20);
    }

    @Override
    public Point getVersionStringOffset() {
        Rectangle r = this.getRect();
        int x = r.x + r.width - 60;
        if (this.isCollapsed()) {
            x -= 10;
        }
        int y = r.y + r.height - 10;
        return new Point(x, y);
    }

    public Point getTypeStringOffset() {
        Point p = this.getSatIdOffset();
        p.x += 40;
        return p;
    }

    @Override
    public JPopupMenu getMenu() {
        return null;
    }

    @Override
    public int[] getStatusIndex(int[] index) {
        int idx = index[index.length - 1];
        if (idx > 0) {
            this.setSatSwitchId(((Chassis_Container)this.getParent()).getSwitchIds()[idx - 1]);
            this.setSatSwitchType(((Chassis_Container)this.getParent()).getSwitchTypes()[idx - 1]);
        }
        return new int[]{0};
    }

    @Override
    public boolean isCollapsed() {
        return Chassis_Container.isSatSwitchCollapsed(this.getSatSwitchId());
    }

    @Override
    public void setCollapsed(boolean minimized) {
        Chassis_Container.setSatSwitchCollapsed(this.getSatSwitchId(), minimized);
    }

    @Override
    public Class[] getChildren() {
        return this.isCollapsed() ? this._ChildrenWhenMinimized : this._Children;
    }

    @Override
    protected Class getUnSupportedCardClass(int slotNum) {
        return UnsupportedSatCard.class;
    }

    @Override
    public Class[] getChildSubclass(Class child) throws Exception {
        if (child == CollapseRestoreControl.class) {
            return null;
        }
        return super.getChildSubclass(child);
    }

    @Override
    public int[] getChildIndex(Class child, int index) {
        if (child == CollapseRestoreControl.class) {
            return null;
        }
        return super.getChildIndex(child, index);
    }

    @Override
    public int getCardOffset() {
        return FRUConstants.getCardOffset() + FRUConstants.getSatelliteSwitchComponentOffset(this.getSatSwitchId());
    }

    @Override
    public int getPowerSupplyOffset() {
        return FRUConstants.getPowerSupplyOffset(Discover.isSysVersionGreaterThanEqual("3.0(0)")) + FRUConstants.getSatelliteSwitchComponentOffset(this.getSatSwitchId());
    }

    @Override
    public int getFanOffset() {
        return FRUConstants.getFanOffset(Discover.isSysVersionGreaterThanEqual("3.0(0)")) + FRUConstants.getSatelliteSwitchComponentOffset(this.getSatSwitchId());
    }

    @Override
    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        super.setStatus(varBindList, offset, view);
        N5KDmSystem.printSatSwitchIdOnPhysicalView(this);
        if (this.isCollapsed()) {
            N5KDmSystem.printSatSwitchTypeOnPhysicalView(this);
        }
    }

    @Override
    public String getBitmap() {
        return this.isCollapsed() ? "chassis-sat-mini.gif" : this.getExpandedBitmap();
    }
}

