/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.SM;
import com.cisco.dcbu.sm.client.lic.LICServer;
import com.cisco.dcbu.sm.client.lic.Logger;
import com.cisco.dcbu.sm.client.lic.McastReceiver;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Random;
import javax.net.ServerSocketFactory;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.restlet.Client;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Launcher {
    static String server = "169.254.1.1";
    static int DEFAULT_PORT = 8182;
    static int replyPort = -1;
    static String tmpToken = "dajfdlfjaldfj";
    protected static int port = -1;
    static boolean isOpen = false;
    private static final Launcher self = new Launcher();

    private Launcher() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            LookAndFeelFactory.installJideExtension((int)3);
            ((Office2003Painter)Office2003Painter.getInstance()).setColorName("Default");
        }
    }

    public static Launcher getInstance() {
        return self;
    }

    public static int getPort() {
        return port;
    }

    public void startConnector() {
        try {
            port = this.findAvailPort();
        }
        catch (Exception ex) {
            System.err.println("Unable to find available port.");
            throw new RuntimeException(ex);
        }
        try {
            LICServer listener = new LICServer(port);
            listener.start();
            Thread lifeCycleDaemon = new Thread(){

                @Override
                public void run() {
                    for (int cnt = 120; cnt > 0 && !isOpen; --cnt) {
                        try {
                            1.sleep(1000L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!isOpen) {
                        System.exit(0);
                    }
                }
            };
            lifeCycleDaemon.setDaemon(true);
            lifeCycleDaemon.start();
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    McastReceiver.getInstance().receive();
                }
            });
            t.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to start LIC Server: " + ex.getMessage());
        }
    }

    public int findAvailPort() throws Exception {
        int port;
        int maxTry = 20;
        for (port = DEFAULT_PORT; !Launcher.testServerPort(port) || port == replyPort; port += new Random().nextInt(1000)) {
            if (--maxTry >= 0) continue;
            throw new Exception("Unable to find available port");
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testServerPort(int port) {
        ServerSocket ss = null;
        try {
            ServerSocketFactory factory = ServerSocketFactory.getDefault();
            ss = factory.createServerSocket(port);
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException ioex) {
                    System.err.println(ioex.getMessage());
                }
            }
        }
        return true;
    }

    public static void main(String ... args) {
        SM.loadLog4jConfiguration();
        try {
            block9: for (int i = 0; i < args.length; ++i) {
                if (args[i].charAt(0) != '-') continue;
                switch (args[i].charAt(1)) {
                    case 'r': {
                        try {
                            String replyPortStr = args[++i];
                            replyPort = Integer.parseInt(replyPortStr);
                        }
                        catch (NumberFormatException ne) {
                            System.err.println(ne.getMessage());
                        }
                        continue block9;
                    }
                    case 's': {
                        server = args[++i];
                        continue block9;
                    }
                    case 't': {
                        tmpToken = args[++i];
                        continue block9;
                    }
                }
            }
            if (replyPort < 0) {
                SM.main(args);
                return;
            }
            Launcher connector = Launcher.getInstance();
            connector.startConnector();
            Launcher.handshakeRespond(replyPort, tmpToken, Launcher.getPort());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void handshakeRespond(int replyPort, String tmpToken, int myPort) throws UnknownHostException {
        Client client = new Client(Protocol.HTTP);
        String uri = "http://" + InetAddress.getLocalHost().getHostName() + ":" + replyPort;
        System.out.println("Respondinng to DCNM @ uri: " + uri);
        String dcnmURI = uri + "/dcnm";
        Request regRes = new Request(Method.POST, dcnmURI);
        regRes.setReferrerRef(uri);
        Representation entity = Launcher.createLaunchReply(Integer.toString(myPort), tmpToken);
        regRes.setEntity(entity);
        client.handle(regRes);
    }

    private static Representation createLaunchReply(String port, String token) {
        DomRepresentation rep = null;
        try {
            Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element elRoot = d.createElement("root");
            d.appendChild(elRoot);
            Element elPort = d.createElement("port");
            elPort.appendChild(d.createTextNode(port));
            elRoot.appendChild(elPort);
            Element elToken = d.createElement("token");
            elToken.appendChild(d.createTextNode(token));
            elRoot.appendChild(elToken);
            d.normalizeDocument();
            rep = new DomRepresentation(MediaType.TEXT_XML, d);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return rep;
    }

    public static void login(String username, String password) throws Exception {
        if (server == null || server.startsWith("169.254") || "".equals(server.trim())) {
            String msg = "You're not logged in.";
            Logger.error(msg);
            Util.errorMessage(null, msg);
            return;
        }
        boolean isLocal = true;
        boolean useToken = false;
        ClientController.getInstance().login(server, username, password.toCharArray(), false, false, isLocal, useToken);
        ClientController.getInstance().showBrowseFrame();
        isOpen = true;
    }

    public static void setServer(String serverAddr) {
        server = serverAddr;
    }
}

