/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cfs.callhome;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.cfs.CfsClientActionCommiter;
import com.cisco.dcbu.sm.client.cfs.CfsConfigWizard;
import com.cisco.dcbu.sm.client.cfs.CfsSwitchPeer;
import com.cisco.dcbu.sm.client.cfs.callhome.CallHomeStatusPanel;
import com.cisco.dcbu.sm.client.cfs.callhome.CallHomeWizard;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CallHomeEmailSetupPanel
extends WizardPanel
implements SnmpAggregrateIf,
ActionListener,
ItemListener,
ListSelectionListener {
    private JComponent[] _labels;
    private SnmpKTable _table;
    private KTableModel _tableModel;
    private JButton[] _buttons;
    private JComboBox _protCbox;
    private JTextField _fromTf;
    private JTextField _priSmtpTf;
    private JTextField _secSmtpTf;
    private JLabel _optLabel = new JLabel(" (Optional)");
    private static int _state = 0;
    private static boolean _clearMerge = false;
    private CfsClientActionCommiter _cfsCommitter;
    private SnmpPeer _masterPeer;
    private ArrayList _swList = new ArrayList();
    private CallHomeStatusPanel _statusDlg = null;
    private boolean _isVersion4_2 = false;
    private boolean _isVersion5_0 = false;
    private int _numPeers = 0;
    private static final String LABEL_SMTP = "    SMTP Server:";
    private static final String LABEL_PRI_SMTP = "    Primary SMTP Server:";
    private static final String LABEL_SEC_SMTP = "    Secondary SMTP Server:";
    private static final String LABEL_FROM = "    From:";
    private static final String WARN_TEXT = "Please specify parameter: ";
    private static final String[] HEADERS = new String[]{"Protocol", "To", "Profile"};
    private static final String[] PROFILE = new String[]{"xml", "short_txt", "full_txt"};
    private static final String[] PROTOCOL = new String[]{"email", "http"};
    public static final int COL_PROTOCOL = 0;
    public static final int COL_TO = 1;
    public static final int COL_PROFILE = 2;
    public static final int POS_PRI_SMTP = 1;
    public static final int POS_SEC_SMTP = 2;
    private static final int SMTP_PORT = 25;
    private static final int MAX_DESTINATION = 3;
    private static final String DEF_EMAIL = "admin@cisco.com";
    private static final String DEF_HTML = "http://callhome.cisco.com";
    private static final int STATE_ENABLE_CFS = 1;
    private static final int STATE_COMMIT_MERGE_CLEAR = 2;
    private static final int STATE_COMMIT_SET_GENERAL = 3;
    private static final int STATE_COMMIT_FEATURE_ENABLE = 4;
    private static final int STATE_COMMIT_SET_EMAILS = 5;
    private static final int STATE_ENABLE_CFS_NO_NEED = 6;
    private static final String STR_CMD_GEN_INFO = "Commit-general-info-config";
    private static final String STR_CMD_EMAIL_CONFIG = "Email-config";
    private static final String STR_CMD_FEATURE_ENABLE = "Feature-enable";
    private static final String STR_CMD_CLEAR_MERGE_FAILURE = "Clear-Merge-Failure";
    private static final String STR_CMD_CFS_ENABLE = "CFS Enable";
    private static final String[] names = new String[]{null, "    Primary SMTP Server:", "    Secondary SMTP Server:", "    From:", null, "    "};
    private static final String STR_BEGIN = "===== CallHome configuration BEGIN =====";
    private static final String STR_END = "===== CallHome configuration END =====";
    private static final String STR_SUCCESS = "===== CallHome configuration succeeded =====";
    private static final String STR_FAIL = "\n\nCallHome configuration failed. Check DCNM-SAN client logs for details.\n\n";
    protected final SyncedInt _numOutstanding = new SyncedInt(0);

    public CallHomeEmailSetupPanel(JWizard wizard) {
        super("3 of 3: Email Setup", "Specify SMTP server, source and destination addresses.HTTP destination is supported from NX-OS release 4.2 and onwards. Secondary SMTP server is supported from NX-OS release 5.0 and onwards.", wizard, CfsConfigWizard._Image);
        this._fromTf = new JTextField(18);
        this._priSmtpTf = new JTextField(18);
        this._secSmtpTf = new JTextField(18);
        JPanel priSmtpPn = new JPanel(new BorderLayout());
        priSmtpPn.add("West", this._priSmtpTf);
        priSmtpPn.add("Center", new JLabel(" "));
        JPanel secSmtpPn = new JPanel(new BorderLayout());
        secSmtpPn.add("West", this._secSmtpTf);
        secSmtpPn.add("Center", this._optLabel);
        JPanel fromPn = new JPanel(new BorderLayout());
        fromPn.add("West", this._fromTf);
        fromPn.add("Center", new JLabel(" "));
        this._fromTf.setText(DEF_EMAIL);
        this._priSmtpTf.setText("email.cisco.com");
        this._tableModel = new KTableModel();
        this._tableModel.setData(new Array());
        this._tableModel.setHeaders(HEADERS);
        this._tableModel.setEditable(new boolean[]{true, true, true});
        this._table = new SnmpKTable(this._tableModel);
        this._table.getSelectionModel().addListSelectionListener(this);
        JComboBox<String> profileCbox = new JComboBox<String>(PROFILE);
        profileCbox.setEditable(false);
        this._table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(profileCbox));
        this._protCbox = new JComboBox<String>(PROTOCOL);
        this._protCbox.setEditable(false);
        this._table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this._protCbox));
        this._protCbox.addItemListener(this);
        this._table.getColumnModel().getColumn(1).setMinWidth(180);
        this._table.getColumnModel().getColumn(2).setMinWidth(90);
        JScrollPane sp = new JScrollPane(this._table);
        sp.setPreferredSize(new Dimension(250, 200));
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 6, 4));
        this._buttons = DialogUtil.buildButtons(new String[]{"Add", "Remove"}, (ActionListener)this);
        for (int i = 0; i < this._buttons.length; ++i) {
            buttonPanel.add(this._buttons[i]);
            if (i <= 0) continue;
            this._buttons[i].setEnabled(false);
        }
        JPanel tp = new JPanel(new BorderLayout());
        tp.add("Center", sp);
        tp.add("South", buttonPanel);
        this._labels = DialogUtil.buildLabels(names);
        JComponent[] values = new JComponent[this._labels.length];
        values[0] = new DialogSeparator("Email SMTP Servers");
        values[1] = priSmtpPn;
        values[2] = secSmtpPn;
        values[3] = fromPn;
        values[4] = new DialogSeparator("Destinations");
        JPanel pnlAll = new JPanel(new BorderLayout());
        pnlAll.add((Component)DialogUtil.buildPanel(this._labels, values), "Center");
        this.add((Component)pnlAll, "North");
        this.add((Component)tp, "Center");
    }

    public void updatePanel() {
        this._swList.clear();
        this._masterPeer = ((CfsSwitchPeer)this.getModelValue((String)"CFS_MASTER_SWITCH"))._peer;
        this._swList.add(this._masterPeer);
        Switch sw = ClientController.findFabricSwitchByIpAddress(this._masterPeer.getAddress());
        this._isVersion4_2 = sw.isVersionGreaterThanEqual("4.2(0)");
        this._isVersion5_0 = sw.isVersionGreaterThanEqual("5.0(0)");
        if (this._isVersion5_0) {
            this._secSmtpTf.setEditable(true);
            this._secSmtpTf.setVisible(true);
            ((JLabel)this._labels[1]).setText(LABEL_PRI_SMTP);
            ((JLabel)this._labels[2]).setVisible(true);
            this._optLabel.setVisible(true);
        } else {
            this._secSmtpTf.setEditable(false);
            this._secSmtpTf.setVisible(false);
            ((JLabel)this._labels[1]).setText(LABEL_SMTP);
            ((JLabel)this._labels[2]).setVisible(false);
            this._optLabel.setVisible(false);
        }
        if (this._isVersion4_2) {
            this._tableModel.setEditable(new boolean[]{true, true, true});
        } else {
            this._tableModel.setEditable(new boolean[]{false, true, true});
            this.checkExistingEmailsAddress();
        }
    }

    public void checkExistingEmailsAddress() {
        Array data = this._tableModel.getData();
        boolean bWarn = false;
        int numRows = data.size();
        for (int row = 0; row < numRows; ++row) {
            Object[] rowData = (Object[])data.elementAt(row);
            String protocol = (String)rowData[0];
            if (protocol == null || protocol.equals(PROTOCOL[0])) continue;
            bWarn = true;
            break;
        }
        if (bWarn) {
            Util.errorMessage((Component)this.getWizard(), "Error found in \"Email Setup\" destination address type:\nSelected master switch does not support \"http\". Please correct the error before continue.");
        }
    }

    private void debug(String message) {
        CallHomeWizard._logger.debug((Object)message);
    }

    private void info(String message) {
        CallHomeWizard._logger.info((Object)message);
    }

    private void warn(String message) {
        CallHomeWizard._logger.warn((Object)message);
    }

    private void error(String message) {
        CallHomeWizard._logger.error((Object)message);
    }

    private void error(String message, Throwable ex) {
        CallHomeWizard._logger.error((Object)message, ex);
    }

    @Override
    public void doFinish() {
        String msg = this.validateData();
        if (msg.length() > 0) {
            Util.errorMessage((Component)this.getWizard(), msg);
            return;
        }
        super.doNext();
        this.getWizard().getNavigator().getBackBtn().setVisible(false);
        this.getWizard().getNavigator().setCancelButton("Close");
        this.getWizard().getNavigator().setFinishButton("Run Test");
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        int errCount = 0;
        this.info(STR_BEGIN);
        try {
            this.info("Configuring system contact information...");
            this.print("Configuring system contact information...");
            this.setSysContact();
        }
        catch (SnmpException ex) {
            this.error("CallHome SET sysContact error", ex);
            ++errCount;
        }
        if (errCount > 0) {
            this.print("Configuring system contact information failed on " + errCount + " of " + this._numPeers + " switches.");
            this.reportFailure();
        } else {
            this.info("Configuring system contact information successful for " + this._numPeers + " out of " + this._numPeers + " switches.");
            errCount = 0;
            boolean result = false;
            try {
                result = this.doEnableCFS();
            }
            catch (SnmpException ex) {
                ++errCount;
                this.error("CallHome enable cfs exception", ex);
            }
            if (!result || errCount > 0) {
                this.print("Enabling CFS failed. Check client log for details.\n\n");
                this.error("Enabling CFS failed. Check client log for details.\n\n");
                this.reportFailure();
            }
        }
    }

    private void setSysContact() throws SnmpException {
        VarBindList vbl = new VarBindList();
        JTextField contactTf = (JTextField)this.getModelValue("SYS_CONTACT");
        vbl.add(MibNode.get("sysContact").getOid(), new int[]{0}, (SnmpVar)new SnmpString(contactTf.getText()));
        SnmpPeer[] peers = ((CallHomeWizard)this.getWizard()).getPeers();
        if (this._numPeers == 0) {
            this._numPeers = peers.length;
        }
        for (int i = 0; i < peers.length; ++i) {
            SnmpFetch.set(peers[i], new SnmpPDU(-93, vbl));
        }
    }

    private boolean setGeneralInfo() {
        this.print("Configuring general contact information...");
        this.info("Configuring general contact information on master switch...");
        CfsSwitchPeer pr = (CfsSwitchPeer)this.getModelValue("CFS_MASTER_SWITCH");
        VarBindList vbl = new VarBindList();
        JTextField phoneNumTf = (JTextField)this.getModelValue("PHONE_NUMBER");
        JTextField emailAddrTf = (JTextField)this.getModelValue("CONTACT_EMAIL");
        JTextField streetAddrTf = (JTextField)this.getModelValue("STREET_ADDR");
        JTextField custIdTf = (JTextField)this.getModelValue("CUSTOMER_ID");
        JTextField contractIdTf = (JTextField)this.getModelValue("CONTRACT_ID");
        JTextField siteIdTf = (JTextField)this.getModelValue("SITE_ID");
        vbl.add(MibNode.get("sysContactPhoneNumber").getOid(), new int[]{0}, (SnmpVar)new SnmpString(phoneNumTf.getText()));
        vbl.add(MibNode.get("sysContactEmailAddress").getOid(), new int[]{0}, (SnmpVar)new SnmpString(emailAddrTf.getText()));
        vbl.add(MibNode.get("sysStreetAddress").getOid(), new int[]{0}, (SnmpVar)new SnmpString(streetAddrTf.getText()));
        if (custIdTf.getText().trim().length() > 0) {
            vbl.add(MibNode.get("callHomeCustomerId").getOid(), new int[]{0}, (SnmpVar)new SnmpString(custIdTf.getText()));
        }
        if (contractIdTf.getText().trim().length() > 0) {
            vbl.add(MibNode.get("callHomeContractId").getOid(), new int[]{0}, (SnmpVar)new SnmpString(contractIdTf.getText()));
        }
        if (siteIdTf.getText().trim().length() > 0) {
            vbl.add(MibNode.get("callHomeSiteId").getOid(), new int[]{0}, (SnmpVar)new SnmpString(siteIdTf.getText()));
        }
        SnmpPeer[] peers = new SnmpPeer[]{pr._peer};
        for (int i = 0; i < peers.length; ++i) {
            try {
                SnmpFetch.set(peers[i], new SnmpPDU(-93, vbl));
                continue;
            }
            catch (SnmpException ex) {
                this.error("Configuring general contact information...failed.", ex);
                this.print("Configuring general contact information...failed.");
                return false;
            }
        }
        this.info("Configuring general contact information on master switch...Done.");
        this.info("CFS commit general contact information...");
        this.print("CFS commit...");
        try {
            this.startCommit(3, STR_CMD_GEN_INFO);
        }
        catch (SnmpException ex) {
            this.error("Commit general information configuration failed", ex);
            this.print("CFS commit failed.");
            return false;
        }
        return true;
    }

    private int getAddressType(String address) {
        IPAddressValidator validator = new IPAddressValidator();
        if (validator.validate(address)) {
            return 1;
        }
        return 16;
    }

    private boolean setupEmails() {
        int[] profileIndex;
        String profileName;
        int i;
        CfsSwitchPeer pr = (CfsSwitchPeer)this.getModelValue("CFS_MASTER_SWITCH");
        int addrType = 0;
        int[] index = new int[]{};
        int[] addrIndex = new int[]{};
        byte[] addrByte = new byte[]{};
        VarBindList vbl = new VarBindList();
        addrType = this.getAddressType(this._priSmtpTf.getText());
        vbl.add(MibNode.get("callHomeEmailFrom").getOid(), new int[]{0}, (SnmpVar)new SnmpString(this._fromTf.getText()));
        vbl.add(MibNode.get("callHomeEmailReplyTo").getOid(), new int[]{0}, (SnmpVar)new SnmpString(this._fromTf.getText()));
        vbl.add(MibNode.get("callHomeSmtpServerAddrType").getOid(), new int[]{0}, (SnmpVar)new SnmpInt(addrType));
        if (addrType == 1) {
            try {
                byte[] bytes = SnmpIpAddress.parse(this._priSmtpTf.getText());
                vbl.add(MibNode.get("callHomeSmtpServerAddr").getOid(), new int[]{0}, (SnmpVar)new SnmpString(bytes));
            }
            catch (SnmpException ex) {
                this.print(ex.getMessage());
            }
        } else {
            vbl.add(MibNode.get("callHomeSmtpServerAddr").getOid(), new int[]{0}, (SnmpVar)new SnmpString(this._priSmtpTf.getText()));
        }
        vbl.add(MibNode.get("callHomeSmtpServerPort").getOid(), new int[]{0}, (SnmpVar)new SnmpGauge(25L));
        SnmpPeer[] peers = new SnmpPeer[]{pr._peer};
        this.print("Configuring SMTP server...");
        this.info("Configuring primary SMTP server on master switch...");
        try {
            for (i = 0; i < peers.length; ++i) {
                SnmpFetch.set(peers[i], new SnmpPDU(-93, vbl));
            }
        }
        catch (SnmpException ex) {
            this.error(ex.getMessage(), ex);
            return false;
        }
        this.info("Configuring primary SMTP server on master switch...Done.");
        if (!this._secSmtpTf.getText().trim().equals("")) {
            vbl.clear();
            addrType = this.getAddressType(this._secSmtpTf.getText());
            try {
                addrByte = addrType == 1 ? SnmpIpAddress.parse(this._secSmtpTf.getText()) : new SnmpString(this._secSmtpTf.getText()).getValue();
            }
            catch (SnmpException ex) {
                this.error("parse secondary smtp server input...error", ex);
            }
            addrIndex = new int[addrByte.length + 1];
            addrIndex[0] = addrByte.length;
            for (i = 0; i < addrByte.length; ++i) {
                addrIndex[i + 1] = addrByte[i] & 0xFF;
            }
            index = new int[addrIndex.length + 1];
            index[0] = addrType;
            System.arraycopy(addrIndex, 0, index, 1, addrIndex.length);
            vbl.add(MibNode.get("ccmSmtpServersStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
            vbl.add(MibNode.get("ccmSmtpServersPort").getOid(), index, (SnmpVar)new SnmpGauge(25L));
            vbl.add(MibNode.get("ccmSmtpServersPriority").getOid(), index, (SnmpVar)new SnmpGauge(30L));
            this.info("Configuring secondary SMTP server on master switch...");
            this.print("Configuring secondary SMTP server...");
            try {
                for (i = 0; i < peers.length; ++i) {
                    SnmpFetch.set(peers[i], new SnmpPDU(-93, vbl));
                }
            }
            catch (SnmpException ex) {
                this.print(ex.getMessage());
                return false;
            }
            this.info("Configuring secondary SMTP server on master switch...Done.");
        }
        vbl.clear();
        Array data = this._tableModel.getData();
        int destId = 0;
        HashMap<String, ProfileIndexPool> poolMap = new HashMap<String, ProfileIndexPool>();
        int numRows = data.size();
        for (int row = 0; row < numRows; ++row) {
            Object[] rowData = (Object[])data.elementAt(row);
            profileName = (String)rowData[2];
            this.getProfileIndexPool(pr._peer, profileName, poolMap);
        }
        this.print("Configuring email destination...");
        this.info("Configuring email destinations on master switch...");
        HashMap<String, DestTypeChecker> destTypeMap = new HashMap<String, DestTypeChecker>();
        DestTypeChecker checker = null;
        for (int row = 0; row < numRows; ++row) {
            Object[] rowData = (Object[])data.elementAt(row);
            profileName = (String)rowData[2];
            String destAddress = (String)rowData[1];
            int destType = ((String)rowData[0]).equalsIgnoreCase("email") ? 1 : 2;
            checker = (DestTypeChecker)destTypeMap.get(profileName);
            if (checker == null) {
                checker = new DestTypeChecker();
                destTypeMap.put(profileName, checker);
            }
            if (!checker._usedType.equals((String)rowData[0])) {
                if (checker._usedType.equals("")) {
                    checker._usedType = (String)rowData[0];
                } else {
                    checker._both = true;
                }
            }
            profileIndex = new SnmpOID(this.getSnmpOidFromString(profileName)).getValue();
            index = new int[profileIndex.length + 1];
            System.arraycopy(profileIndex, 0, index, 0, profileIndex.length);
            index[index.length - 1] = destId = poolMap.get(profileName).getNextIndex();
            vbl.clear();
            vbl.add(MibNode.get("callHomeDestEmailAddressStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
            if (this._isVersion4_2) {
                vbl.add(MibNode.get("callHomeDestType").getOid(), index, (SnmpVar)new SnmpInt(destType));
            }
            if (destType == 1) {
                vbl.add(MibNode.get("callHomeDestEmailAddress").getOid(), index, (SnmpVar)new SnmpString(destAddress));
            } else {
                vbl.add(MibNode.get("callHomeDestHttpUrl").getOid(), index, (SnmpVar)new SnmpString(destAddress));
            }
            try {
                for (int i2 = 0; i2 < peers.length; ++i2) {
                    SnmpFetch.set(peers[i2], new SnmpPDU(-93, vbl));
                }
                continue;
            }
            catch (SnmpException ex) {
                this.print("Configuring email destination...failed.");
                this.error("Configuring email destination...failed.", ex);
                return false;
            }
        }
        this.info("Configuring email destinations on master switch...Done");
        this.info("Checking email profile transport method on master switch...");
        Set keySet = destTypeMap.keySet();
        for (String profile : keySet) {
            checker = (DestTypeChecker)destTypeMap.get(profile);
            if (!checker._both) continue;
            this.info("Setting email transport method to emailAndHttp for profile " + profile + "...");
            profileIndex = new SnmpOID(this.getSnmpOidFromString(profile)).getValue();
            vbl.clear();
            vbl.add(MibNode.get("callHomeDestProfileTrnsprtMthd").getOid(), profileIndex, (SnmpVar)new SnmpInt(4));
            try {
                SnmpFetch.set(pr._peer, new SnmpPDU(-93, vbl));
            }
            catch (SnmpException ex) {
                this.print("Setting email transport method to emailAndHttp...failed");
                this.error("Setting email transport method to emailAndHttp...failed", ex);
                return false;
            }
            this.info("Setting email transport method to emailAndHttp for profile " + profile + "...Done.");
        }
        this.info("Checking email profile transport method on master switch...Done.");
        this.print("CFS commit...");
        this.info("CFS commit SMTP server and email configuration...");
        try {
            this.startCommit(5, STR_CMD_EMAIL_CONFIG);
        }
        catch (SnmpException ex) {
            this.error("CFS commit failed", ex);
            this.print("CFS commit failed.");
            return false;
        }
        return true;
    }

    private void getProfileIndexPool(SnmpPeer peer, String name, HashMap<String, ProfileIndexPool> map) {
        ProfileIndexPool pool = map.get(name);
        if (pool != null) {
            return;
        }
        pool = new ProfileIndexPool();
        map.put(name, pool);
        int destId = 1;
        int total = 0;
        VarBindList vbl = new VarBindList();
        VarBindList respVbl = null;
        int[] profileIndex = new SnmpOID(this.getSnmpOidFromString(name)).getValue();
        int[] index = new int[profileIndex.length + 1];
        System.arraycopy(profileIndex, 0, index, 0, profileIndex.length);
        for (int loop = 0; loop <= 50 && total < 3; ++loop) {
            index[index.length - 1] = destId;
            vbl.clear();
            vbl.add(MibNode.get("callHomeDestEmailAddress").getOid(), index);
            SnmpPeer[] peers = new SnmpPeer[]{peer};
            SnmpPDU resp = null;
            try {
                for (int i = 0; i < peers.length; ++i) {
                    resp = SnmpFetch.get(peers[i], vbl);
                }
            }
            catch (SnmpException ex) {
                this.print(ex.getMessage());
            }
            respVbl = resp.getVariables();
            if (respVbl != null && respVbl.stringValue(0).equalsIgnoreCase("n/a")) {
                pool.add(destId);
                ++total;
            }
            ++destId;
        }
    }

    private boolean enableFeature() {
        this.info("Enabling feature control on master switch...");
        this.print("Enabling feature control...");
        CfsSwitchPeer pr = (CfsSwitchPeer)this.getModelValue("CFS_MASTER_SWITCH");
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("callHomeEnable").getOid(), new int[]{0}, (SnmpVar)new SnmpInt(1));
        try {
            SnmpPeer[] peers = new SnmpPeer[]{pr._peer};
            for (int i = 0; i < peers.length; ++i) {
                SnmpFetch.set(peers[i], new SnmpPDU(-93, vbl));
            }
        }
        catch (SnmpException ex) {
            this.error("Enabling feature control...failed", ex);
            return false;
        }
        this.info("enabling feature control on master switch...Done.");
        this.info("CFS commit call-home feature...");
        try {
            this.print("CFS commit...");
            this.startCommit(4, STR_CMD_FEATURE_ENABLE);
        }
        catch (SnmpException ex) {
            this.error("CFS commit feature control...failed", ex);
            this.print("CFS commit failed.");
            return false;
        }
        return true;
    }

    private int[] getSnmpOidFromString(String data) {
        char[] ch = data.toCharArray();
        int[] out = new int[data.length() + 1];
        out[0] = out.length - 1;
        for (int i = 0; i < ch.length; ++i) {
            out[i + 1] = ch[i];
        }
        return out;
    }

    private String validateData() {
        String msg = "";
        Array data = this._tableModel.getData();
        if (this._table.isEditing()) {
            this._table.editingStopped(null);
        }
        if (!this._isVersion5_0 && this._secSmtpTf.getText().trim().length() > 0) {
            return "Secondary SMTP server is not supported on master switch version less that 5.0";
        }
        for (int i = 0; i < data.size(); ++i) {
            Object[] rowData = (Object[])data.elementAt(i);
            if (this._isVersion4_2 || !((String)rowData[0]).equalsIgnoreCase("http")) continue;
            return "HTTP destination is not supported on master switch version less that 4.2";
        }
        if (this._fromTf.getText().trim().length() == 0) {
            return "Please specify parameter: From Email";
        }
        if (this._priSmtpTf.getText().trim().length() == 0) {
            return "Please specify parameter: Primary SMTP server Address";
        }
        if (data.size() < 1) {
            return "Please specify at least one destination";
        }
        if (this._secSmtpTf.getText().trim().length() > 0) {
            byte[] addrByte = new byte[]{};
            int[] addrIndex = new int[]{};
            int[] index = new int[]{};
            VarBindList vbl = new VarBindList();
            int addrType = this.getAddressType(this._secSmtpTf.getText());
            try {
                addrByte = addrType == 1 ? SnmpIpAddress.parse(this._secSmtpTf.getText()) : new SnmpString(this._secSmtpTf.getText()).getValue();
            }
            catch (SnmpException ex) {
                // empty catch block
            }
            addrIndex = new int[addrByte.length + 1];
            addrIndex[0] = addrByte.length;
            for (int i = 0; i < addrByte.length; ++i) {
                addrIndex[i + 1] = addrByte[i] & 0xFF;
            }
            index = new int[addrIndex.length + 1];
            index[0] = addrType;
            System.arraycopy(addrIndex, 0, index, 1, addrIndex.length);
            vbl.add(MibNode.get("ccmSmtpServersPort").getOid(), index, (SnmpVar)new SnmpGauge(25L));
            CfsSwitchPeer pr = (CfsSwitchPeer)this.getModelValue("CFS_MASTER_SWITCH");
            SnmpPeer[] peers = new SnmpPeer[]{pr._peer};
            SnmpPDU resp = null;
            try {
                for (int i = 0; i < peers.length; ++i) {
                    resp = SnmpFetch.get(peers[i], vbl);
                }
            }
            catch (SnmpException ex) {
                return "Failed to verify secondary SMTP server on master switch.";
            }
            int port = resp.getVariables().get(0).intValue();
            if (port > 0) {
                return "User specified secondary SMTP server exists on master switch already.";
            }
        }
        return msg;
    }

    private void startCommit(int state, String name) throws SnmpException {
        this._cfsCommitter = new CfsClientActionCommiter(this._swList, (CallHomeWizard)this.getWizard(), CallHomeWizard.CALLHOME_INDEX, 4, name);
        _state = state;
        this._cfsCommitter.startAction();
    }

    private void setReadFrom(boolean running) throws SnmpException {
        String from = running ? "running" : "pending";
        this.info("read from " + from + " config database");
        VarBindList vbl = new VarBindList();
        CallHomeWizard.appendReadFromVbl(vbl, running);
        SnmpFetch.set(this._masterPeer, vbl);
    }

    private boolean doEnableCFS() throws SnmpException {
        CfsSwitchPeer pr = (CfsSwitchPeer)this.getModelValue("CFS_MASTER_SWITCH");
        boolean locked = pr.isLocked() && pr.isLockedByMe();
        this.info("Setting config database... pr.isLocked=" + pr.isLocked() + " pr.isLockedByMe=" + pr.isLockedByMe());
        if (pr._featureState) {
            this.setReadFrom(!locked);
        }
        _state = 0;
        ArrayList featureList = (ArrayList)this.getModelValue("FEATURE_LIST");
        if (featureList != null && featureList.size() > 0) {
            this.enableCFS();
            return true;
        }
        return false;
    }

    private boolean clearMergeFailure() {
        int count = 0;
        VarBindList vbl = new VarBindList();
        this.info("Retrieving merge status on master switch....");
        while (count < 12) {
            vbl.clear();
            vbl.add(MibNode.get("cfsMergeStatusValue").getOid(), CallHomeWizard.CALLHOME_CFS_INDEX);
            CfsSwitchPeer pr = (CfsSwitchPeer)this.getModelValue("CFS_MASTER_SWITCH");
            if (pr == null) {
                this.error("Primary switch is NULL!");
                return false;
            }
            try {
                VarBindList resp = SnmpFetch.get(pr._peer, vbl).getVariables();
                this.info("primary._isMergeFailed: " + pr._isMergeFailed + " cfsMergeStatusValue: " + resp.intValue(0));
                this.info("   1-success 2-inProgress 3-failure 4-waiting 5-other");
                this.info("Retrieving merge status on master switch.... count " + count);
                if (pr._isMergeFailed || resp.intValue(0) == 3) {
                    ArrayList<SnmpPeer> enableFeatureList = new ArrayList<SnmpPeer>();
                    enableFeatureList.add(pr._peer);
                    this.info("CFS commit to clear merge failure....");
                    this.print("Clear cfs merge failure....");
                    this._cfsCommitter = new CfsClientActionCommiter(enableFeatureList, (CallHomeWizard)this.getWizard(), CallHomeWizard.CALLHOME_INDEX, 4, STR_CMD_CLEAR_MERGE_FAILURE);
                    this.print("CFS commit....");
                    this._cfsCommitter.startAction();
                    ++count;
                    Thread.sleep(3000L);
                    continue;
                }
                if (resp.intValue(0) == 1) {
                    return true;
                }
                ++count;
                Thread.sleep(5000L);
            }
            catch (SnmpException ex) {
                this.error("Retrieving merge status failed", ex);
                this.print("Retrieving merge status failed");
                return false;
            }
            catch (InterruptedException ex) {
                this.error("Retrieving merge status failed", ex);
                this.print("Retrieving merge status failed");
                return false;
            }
        }
        this.error("Problem occurs in CFS merge. Please resolve the issue then launch CallHome Wizard tool.");
        this.print("Problem occurs in CFS merge. Please resolve the issue then launch CallHome Wizard tool.");
        return false;
    }

    private void enableCFS() throws SnmpException {
        ArrayList<Object> enableFeatureList = new ArrayList<Object>();
        ArrayList featureList = (ArrayList)this.getModelValue("FEATURE_LIST");
        Iterator itr = featureList.iterator();
        while (itr.hasNext()) {
            Object[] obb = (Object[])itr.next();
            if (obb[1] == null || ((int[])obb[1])[0] == 2) continue;
            enableFeatureList.add(obb[0]);
            itr.remove();
        }
        if (enableFeatureList.size() > 0) {
            this._cfsCommitter = new CallHomeActionCommiter(enableFeatureList, (CallHomeWizard)this.getWizard(), CallHomeWizard.CALLHOME_INDEX, 2, STR_CMD_CFS_ENABLE);
            _state = 1;
            this.print("Enabling CFS service...");
            this.info("Enabling CFS service on switches...");
            ((CallHomeWizard)this.getWizard()).setCursor(true);
            this._cfsCommitter.startAction();
        } else {
            _state = 6;
            this.error("Feature list is empty for enabling CFS on switches...");
            this.actionFinished(true);
        }
    }

    public void testCallHome() {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("callHomeAlertAction").getOid(), 0, (SnmpVar)new SnmpInt(2));
        SnmpPeer[] peers = ((CallHomeWizard)this.getWizard()).getPeers();
        int count = 0;
        this.info("Start CallHome Test...");
        this.print("Start CallHome Test...");
        for (int i = 0; i < peers.length; ++i) {
            try {
                SnmpFetch.set(peers[i], new SnmpPDU(-93, vbl));
                continue;
            }
            catch (SnmpException ex) {
                ++count;
                this.error("Test failed on switch: " + peers[i].getSysName(), ex);
            }
        }
        if (count > 0) {
            this.error("CallHome test failed on " + count + " of " + peers.length + " switches.");
            this.print("CallHome test failed on " + count + " of " + peers.length + " switches. Check DCNM-SAN client logs for details.\n\n");
        } else {
            this.info("CallHome test completed. Check message destination to make sure all test messages are received");
            this.print("CallHome test completed. Check message destination to make sure all test messages are received");
        }
    }

    @Override
    public void actionFinished(boolean success) {
        this.info("---actionFinished: " + success + " state:" + _state);
        try {
            switch (_state) {
                case 1: {
                    if (!this.validateAction(STR_CMD_CFS_ENABLE)) {
                        this.warn("duplicated callback action STR_CMD_CFS_ENABLE...ignore.");
                        return;
                    }
                    _state = 0;
                    this.info("Enabling CFS on switches...Done.");
                    this.updateListModel(2);
                    this._cfsCommitter = null;
                    this.setReadFrom(true);
                    _state = 2;
                    if (this.clearMergeFailure()) {
                        if (!this.setGeneralInfo()) {
                            this.reportFailure();
                        }
                        break;
                    }
                    this.reportFailure();
                    break;
                }
                case 6: {
                    CallHomeWizard._logger.info((Object)"CFS already enabled on switches. Check merge status...");
                    this.updateListModel(2);
                    this._cfsCommitter = null;
                    this.setReadFrom(true);
                    _state = 2;
                    if (this.clearMergeFailure()) {
                        if (!this.setGeneralInfo()) {
                            this.reportFailure();
                        }
                        break;
                    }
                    this.reportFailure();
                    break;
                }
                case 2: {
                    if (!this.validateAction(STR_CMD_CLEAR_MERGE_FAILURE)) {
                        this.warn("duplicated callback action STR_CMD_CLEAR_MERGE_FAILURE...ignore.");
                        return;
                    }
                    if (_clearMerge) {
                        return;
                    }
                    _clearMerge = true;
                    _state = 0;
                    this._cfsCommitter = null;
                    this.setReadFrom(true);
                    CallHomeWizard._logger.info((Object)"commit to clear merge failure....Done.");
                    this.updateListModel(3);
                    if (!this.setGeneralInfo()) {
                        this.reportFailure();
                        return;
                    }
                    break;
                }
                case 3: {
                    if (!this.validateAction(STR_CMD_GEN_INFO)) {
                        this.warn("duplicated callback action STR_CMD_GEN_INFO...ignore.");
                        return;
                    }
                    _state = 0;
                    this._cfsCommitter = null;
                    this.setReadFrom(true);
                    this.info("CFS commit general contact information...Done.");
                    if (!this.enableFeature()) {
                        this.reportFailure();
                        return;
                    }
                    break;
                }
                case 4: {
                    if (!this.validateAction(STR_CMD_FEATURE_ENABLE)) {
                        this.warn("duplicated callback action STR_CMD_FEATURE_ENABLE...ignore.");
                        return;
                    }
                    _state = 0;
                    this._cfsCommitter = null;
                    this.setReadFrom(true);
                    this.info("CFS commit feature control enable...Done.");
                    if (!this.setupEmails()) {
                        this.reportFailure();
                        return;
                    }
                    break;
                }
                case 5: {
                    if (!this.validateAction(STR_CMD_EMAIL_CONFIG)) {
                        this.warn("duplicated callback action STR_CMD_EMAIL_CONFIG...ignore.");
                        return;
                    }
                    _state = 0;
                    this._cfsCommitter = null;
                    this.setReadFrom(true);
                    this.info("CFS commit SMTP server and email configuration...Done.");
                    this.info(STR_SUCCESS);
                    this.info(STR_END);
                    this.print(STR_SUCCESS);
                    this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                    ((CallHomeWizard)this.getWizard()).setCursor(false);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (SnmpException ex) {
            this.error("Exception caught", ex);
            this.reportFailure();
        }
    }

    private String getActionName() {
        if (this._cfsCommitter != null) {
            return this._cfsCommitter.getActionName();
        }
        return null;
    }

    private boolean validateAction(String command) {
        String cmd = this.getActionName();
        this.info("validate command " + command);
        return cmd != null && cmd.equals(command);
    }

    private void reportFailure() {
        this.warn(STR_END);
        this.print(STR_FAIL);
        ((CallHomeWizard)this.getWizard()).setCursor(false);
    }

    private void print(String msg) {
        if (this._statusDlg == null) {
            this._statusDlg = (CallHomeStatusPanel)this.getWizard().getCurrent();
        }
        this._statusDlg.display(msg);
    }

    private void updateListModel(int value) {
        DefaultListModel model = (DefaultListModel)((JList)this.getModelValue("SWITCH_LIST")).getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CfsSwitchPeer pr = (CfsSwitchPeer)model.get(i);
            if (value == 1) {
                pr._featureState = true;
                pr._cfs = true;
                continue;
            }
            if (value == 2) {
                pr._cfs = true;
                continue;
            }
            if (value != 3) continue;
            pr._isMergeFailed = false;
        }
    }

    @Override
    public void dispose() {
        if (this._cfsCommitter != null) {
            this._cfsCommitter.stopPolling();
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Array data = this._tableModel.getData();
        if (this._table.isEditing()) {
            this._table.editingStopped(null);
        }
        switch (((AbstractButton)e.getSource()).getActionCommand().charAt(0)) {
            case 'A': {
                if (data.size() >= 3) {
                    Util.errorMessage((Component)this, "Reached maximum number of destinations.");
                    return;
                }
                String wildcardString = DEF_EMAIL;
                data.addElement(new Object[]{PROTOCOL[0], wildcardString, PROFILE[0], null});
                this._tableModel.fireTableDataChanged();
                break;
            }
            case 'R': {
                int[] selectedRows = this._table.getSelectedRows();
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    data.removeElementAt(selectedRows[i]);
                }
                this._tableModel.fireTableDataChanged();
            }
        }
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        VarBindList vbl = pdu.getVariables();
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (err == null || err.length() != 0) {
            // empty if block
        }
        new Thread(new TestPoller(peer)).start();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (e.getSource() == this._protCbox) {
            int[] sels = this._table.getSelectedRows();
            if (sels.length < 1) {
                return;
            }
            Array data = this._tableModel.getData();
            Object[] rowData = (Object[])data.elementAt(sels[0]);
            rowData[1] = ((String)rowData[0]).equalsIgnoreCase("http") ? DEF_EMAIL : DEF_HTML;
            this._tableModel.fireTableDataChanged();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean isSelected = this._table.getSelectedRowCount() > 0;
        for (int i = 1; i < this._buttons.length; ++i) {
            this._buttons[i].setEnabled(isSelected);
        }
    }

    class ProfileIndexPool {
        public int[] _pool = new int[3];
        short _pos = 0;

        ProfileIndexPool() {
        }

        public void add(int index) {
            if (this._pos < 3) {
                short s = this._pos;
                this._pos = (short)(s + 1);
                this._pool[s] = index;
            }
        }

        public int getNextIndex() {
            int index = 0;
            for (int i = 0; i < 3; ++i) {
                if (this._pool[i] <= 0) continue;
                index = this._pool[i];
                this._pool[i] = 0;
                break;
            }
            return index;
        }
    }

    class CallHomeActionCommiter
    extends CfsClientActionCommiter {
        public CallHomeActionCommiter(ArrayList taskList, StatusIf statusIf, int[] cfsIndex, int action, String actionName) {
            super(taskList, statusIf, cfsIndex, action, actionName);
        }

        @Override
        public void success(PollerManager manager, StringBuffer status) {
            super.success(manager, status);
            CallHomeEmailSetupPanel.this.debug("enableCFS success: " + manager.getSwitchPeer().getSysName() + " status:" + status.toString());
        }

        @Override
        public void failed(PollerManager manager, SnmpException ex) {
            super.failed(manager, ex);
            CallHomeEmailSetupPanel.this.error("enableCFS failed: " + manager.getSwitchPeer().getSysName(), ex);
        }
    }

    class IPAddressValidator {
        private Pattern pattern = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
        private Matcher matcher;
        private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

        public boolean validate(String ip) {
            this.matcher = this.pattern.matcher(ip);
            return this.matcher.matches();
        }
    }

    class DestTypeChecker {
        public boolean _both = false;
        public String _usedType = "";

        DestTypeChecker() {
        }
    }

    class TestPoller
    implements Runnable {
        SnmpPeer _peer;

        public TestPoller(SnmpPeer peer) {
            this._peer = peer;
        }

        @Override
        public void run() {
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("callHomeAlertActionStatus").getOid(), 0);
            vbl.add(MibNode.get("callHomeAlertActionFailureCause").getOid(), 0);
            SnmpPDU resp = null;
            int count = 0;
            while (count < 5) {
                try {
                    String[] values;
                    resp = SnmpFetch.get(this._peer, vbl);
                    VarBindList respVbl = resp.getVariables();
                    if (respVbl != null && (respVbl.intValue(0) == 1 || respVbl.intValue(0) == 3)) {
                        count = (short)(count + 1);
                        Thread.sleep(100L);
                        continue;
                    }
                    if (respVbl != null && respVbl.intValue(0) == 2) {
                        CallHomeEmailSetupPanel.this.print(this._peer.getSysName() + " - CallHome test successful.");
                        break;
                    }
                    if (respVbl == null || respVbl.intValue(0) != 4) continue;
                    StringBuffer buf = new StringBuffer();
                    buf.append(this._peer.getSysName() + ": ");
                    for (String val : values = respVbl.stringValue(1).split("\n")) {
                        if (val.trim().length() <= 10) continue;
                        buf.append("    " + val + "\n");
                    }
                    CallHomeEmailSetupPanel.this.print(buf.toString());
                }
                catch (SnmpException ex) {
                    CallHomeEmailSetupPanel.this.print(ex.getMessage());
                }
                catch (Exception ex) {
                    CallHomeEmailSetupPanel.this.print(ex.getMessage());
                }
                break;
            }
        }
    }
}

