/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cfs.ps;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.cfs.CfsMasterSwitchPanel;
import com.cisco.dcbu.sm.client.cfs.CfsSwitchPeer;
import com.cisco.dcbu.sm.client.cfs.ps.PortSecurityWizard;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.rif.PortSecurityRif;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PSMasterSwitchPanel
extends CfsMasterSwitchPanel
implements ActionListener {
    static final String DEFAULT_DESC = "Please select a Master Switch.  All Port Security configurations will be applied to this switch and propagated to rest of the switches using CFS.  In addition, Port Security and CFS will be enabled on all capable fabric switches.";
    static final String MERGE_FAIL_DESC = "NOTE: Due to Merge Failure the Master Switch configuration will be propagated to all switches.";
    int runState;
    private JCheckBox autoLearn;
    private int reportIdPS = -1;
    private int reportIdAutoLearn = -1;
    static final int AUTO_LEARN_STATE = 6;

    public PSMasterSwitchPanel(JWizard wizard) throws SnmpException {
        super(wizard, DEFAULT_DESC, 2);
    }

    @Override
    protected void buildSwitchPanel(JPanel pnl) throws SnmpException {
        super.buildSwitchPanel(pnl);
        this.autoLearn = new JCheckBox("Automatically learn all logged in ports in VSAN.  (Will overwrite existing port configuration!)", true);
        pnl.add((Component)this.autoLearn, "South");
    }

    @Override
    protected SnmpPeer[] build20SwitchList() {
        Switch[] swLst;
        ArrayList<SnmpPeer> peersLst = new ArrayList<SnmpPeer>();
        Object ctxt = ((PortSecurityWizard)this.getWizard()).getContext();
        if (ctxt != null && ctxt instanceof Vsan && (swLst = ((Vsan)ctxt).getSwitches()) != null) {
            for (int i = 0; i < swLst.length; ++i) {
                if (swLst[i] == null || !swLst[i].isMDS() || swLst[i].isFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag()) || !swLst[i].isManageable() || swLst[i].getPeer() == null || !swLst[i].isVersionGreaterThan("2.0(0)")) continue;
                peersLst.add(swLst[i].getPeer());
            }
        }
        return peersLst.toArray(new SnmpPeer[peersLst.size()]);
    }

    @Override
    protected Object getSelectedListObject() {
        return ((CfsSwitchPeer)this._switchLst.getSelectedValue())._peer;
    }

    @Override
    protected boolean userAction() throws SnmpException {
        boolean locked;
        if (this.runState >= 6) {
            this.runState = 0;
            return true;
        }
        CfsSwitchPeer pr = (CfsSwitchPeer)this._switchLst.getSelectedValue();
        boolean bl = locked = pr.isLocked() && pr.isLockedByMe();
        if (!locked) {
            Switch sww = null;
            CfsSwitchPeer prLoc = this.getLockedPeerInList();
            if (prLoc != null) {
                try {
                    ClientController.getInstance();
                    sww = ClientController.findFabricSwitchByIpAddress(InetAddress.getByAddress(prLoc._lockedOn));
                }
                catch (UnknownHostException exU) {
                    // empty catch block
                }
                throw new SnmpException("The Fabric is currently locked by user " + prLoc._lockedBy + " with pending changes" + (sww != null ? " at switch " + sww : "") + ".");
            }
        }
        StringBuffer globalCfsPr = new StringBuffer();
        DefaultListModel defModel = (DefaultListModel)this._switchLst.getModel();
        for (int i = 0; i < defModel.size(); ++i) {
            pr = (CfsSwitchPeer)defModel.getElementAt(i);
            if (pr._globalCfsState) continue;
            if (globalCfsPr.length() > 0) {
                globalCfsPr.append(", ");
            }
            globalCfsPr.append(pr._peer);
        }
        if (globalCfsPr.length() > 0) {
            throw new SnmpException("Please enable global CFS for following switches and then rerun the wizard\n" + globalCfsPr.toString());
        }
        this.runState = 0;
        try {
            PortSecurityRif psProxy = ClientController.getInstance().assertPortSecurity();
            boolean enableFeature = false;
            boolean enableCfs = false;
            boolean clearMerge = false;
            for (int i = 0; i < defModel.size(); ++i) {
                pr = (CfsSwitchPeer)defModel.getElementAt(i);
                if (!pr._featureState && !enableFeature) {
                    enableFeature = true;
                }
                if (!pr._cfs && !enableCfs) {
                    enableCfs = true;
                }
                if (!pr._isMergeFailed || clearMerge) continue;
                clearMerge = true;
            }
            this.constructServerSideObject();
            psProxy.resetStopAction(10, this.reportIdPS);
            psProxy.resetStopAction(11, this.reportIdAutoLearn);
            ((PortSecurityWizard)this.getWizard()).setStatusTimer(new Timer(3000, this));
            if (enableFeature) {
                this.runState = 1;
                this.timerAction();
            } else if (enableCfs) {
                this.runState = 2;
                this.timerAction();
            } else if (clearMerge) {
                this.runState = 4;
                this.timerAction();
            } else if (this.isAutoLearnRunNeeded()) {
                this.setDataValid(false);
                this.runState = 6;
                this.startAutoLearnProcess();
            } else {
                return true;
            }
            ((PortSecurityWizard)this.getWizard()).setCursor(true);
            this.getWizard().getNavigator().getNextBtn().setEnabled(false);
            return false;
        }
        catch (Exception ex) {
            throw new SnmpException(ex.getMessage());
        }
    }

    private boolean isAutoLearnRunNeeded() {
        Boolean autoLearnState = (Boolean)this.getModelValue("AUTO_LEARNT");
        return autoLearnState == null || autoLearnState.booleanValue() != this.autoLearn.isSelected();
    }

    private String[] getSwitchList() {
        DefaultListModel model = (DefaultListModel)this._switchLst.getModel();
        String[] sws = null;
        if (model.getSize() > 0) {
            sws = new String[model.getSize()];
            for (int i = 0; i < model.getSize(); ++i) {
                CfsSwitchPeer pr = (CfsSwitchPeer)model.get(i);
                sws[i] = pr._peer.getAddress().getHostAddress();
            }
        }
        return sws;
    }

    private String[] getFeatureSwitchList() {
        DefaultListModel model = (DefaultListModel)this._switchLst.getModel();
        ArrayList<String> sws = new ArrayList<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            CfsSwitchPeer pr = (CfsSwitchPeer)model.get(i);
            if (pr._featureState) continue;
            sws.add(pr._peer.getAddress().getHostAddress());
        }
        return sws.size() > 0 ? sws.toArray(new String[sws.size()]) : null;
    }

    private String[] getCFSSwitchList(boolean cfsEnabled) {
        DefaultListModel model = (DefaultListModel)this._switchLst.getModel();
        ArrayList<String> sws = new ArrayList<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            CfsSwitchPeer pr = (CfsSwitchPeer)model.get(i);
            if ((cfsEnabled || pr._cfs) && (!cfsEnabled || !pr._cfs)) continue;
            sws.add(pr._peer.getAddress().getHostAddress());
        }
        return sws.size() > 0 ? sws.toArray(new String[sws.size()]) : null;
    }

    private CfsSwitchPeer getLockedPeerInList() {
        DefaultListModel model = (DefaultListModel)this._switchLst.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CfsSwitchPeer pr = (CfsSwitchPeer)model.get(i);
            if (!pr.isLocked()) continue;
            return pr;
        }
        return null;
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this._switchLst.getModel() instanceof DefaultListModel) {
            DefaultListModel model = (DefaultListModel)this._switchLst.getModel();
            boolean mergeFailed = false;
            for (int i = 0; i < model.getSize(); ++i) {
                CfsSwitchPeer pr = (CfsSwitchPeer)model.get(i);
                if (!pr._isMergeFailed) continue;
                mergeFailed = true;
                break;
            }
            this.setDescription(DEFAULT_DESC + (mergeFailed ? "\nNOTE: Due to Merge Failure the Master Switch configuration will be propagated to all switches." : ""));
        }
        super.setVisible(b);
    }

    private void constructServerSideObject() throws Exception {
        PortSecurityRif psProxy = ClientController.getInstance().assertPortSecurity();
        if (this.reportIdAutoLearn == -1) {
            this.reportIdAutoLearn = psProxy.getNewInstance(11);
        }
        if (this.reportIdPS == -1) {
            this.reportIdPS = psProxy.getNewInstance(10);
        }
    }

    @Override
    protected void populateSwitchList() {
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
        this.getWizard().setStatus("Discovering Switch Feature, CFS status. Please wait...");
        Thread thd = new Thread(new Runnable(){
            DefaultListModel listMdl = new DefaultListModel();
            int principalIndex = -1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.listMdl.clear();
                Object ctxt = ((PortSecurityWizard)PSMasterSwitchPanel.this.getWizard()).getContext();
                short vsanIndex = ctxt != null && ctxt instanceof Vsan ? ((Vsan)ctxt).getId() : (short)1;
                Vsan vv = ClientController.getInstance().getFabric().findVsanById(vsanIndex);
                SnmpPeer principalVsan1Peer = null;
                if (vv != null && vv.getPrincipalSwitch() != null) {
                    principalVsan1Peer = vv.getPrincipalSwitch().getPeer();
                }
                ArrayList<String> swList = new ArrayList<String>();
                for (int p = 0; p < PSMasterSwitchPanel.this._peers.length; ++p) {
                    swList.add(PSMasterSwitchPanel.this._peers[p].getAddress().getHostAddress());
                }
                try {
                    PSMasterSwitchPanel.this.setModelValue("AUTO_LEARNT", false);
                    SnmpUserOpt userOpt = ClientController.getInstance().getFabric().getSnmpUserOpt();
                    PortSecurityRif psProxy = ClientController.getInstance().assertPortSecurity();
                    ctxt = ((PortSecurityWizard)PSMasterSwitchPanel.this.getWizard()).getContext();
                    int vsanId = ctxt != null && ctxt instanceof Vsan ? (int)((Vsan)ctxt).getId() : -1;
                    PSMasterSwitchPanel.this.constructServerSideObject();
                    ArrayList info = psProxy.getSwitchInformationPS(swList.toArray(new String[0]), 0, new int[]{vsanId != -1 ? 2 : 1, vsanId}, userOpt, PSMasterSwitchPanel.this.reportIdPS);
                    Iterator itr = info.iterator();
                    ArrayList<CfsSwitchPeer> cfsPrLst = new ArrayList<CfsSwitchPeer>();
                    while (itr.hasNext()) {
                        Object[] obj = (Object[])itr.next();
                        CfsSwitchPeer swPr = new CfsSwitchPeer();
                        try {
                            InetAddress inetAdd = InetAddress.getByName((String)obj[0]);
                            ClientController.getInstance();
                            swPr._sw = ClientController.findFabricSwitchByIpAddress(inetAdd);
                            swPr._peer = swPr._sw != null ? swPr._sw.getSnmpPeer() : null;
                        }
                        catch (UnknownHostException ex) {
                            // empty catch block
                        }
                        swPr._featureState = ((int[])obj[1])[0] == 2;
                        swPr._featureName = "Port Security";
                        swPr._lockedBy = (String)obj[2];
                        swPr._lockedOn = (byte[])obj[4];
                        swPr._isMergeFailed = (Boolean)obj[5];
                        swPr._cfs = ((int[])obj[6])[0] == 2;
                        swPr._globalCfsState = (Boolean)obj[7];
                        cfsPrLst.add(swPr);
                    }
                    Collections.sort(cfsPrLst);
                    for (int i = 0; i < cfsPrLst.size(); ++i) {
                        CfsSwitchPeer prr = (CfsSwitchPeer)cfsPrLst.get(i);
                        if (prr._peer.equals(principalVsan1Peer)) {
                            this.principalIndex = i;
                        }
                        this.listMdl.addElement(prr);
                    }
                }
                catch (RemoteException re) {
                    Util.errorMessage((Component)PSMasterSwitchPanel.this.getWizard(), re.getMessage());
                    ((PortSecurityWizard)PSMasterSwitchPanel.this.getWizard()).setCursor(false);
                    PSMasterSwitchPanel.this.getWizard().setStatus(re.getMessage());
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ((PortSecurityWizard)PSMasterSwitchPanel.this.getWizard()).setCursor(false);
                    PSMasterSwitchPanel.this.getWizard().setStatus("Failed");
                    return;
                }
                finally {
                    PSMasterSwitchPanel.this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                    PSMasterSwitchPanel.this.getWizard().setStatus("");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PSMasterSwitchPanel.this._switchLst.setModel(listMdl);
                        if (listMdl.getSize() > 0) {
                            PSMasterSwitchPanel.this._switchLst.setSelectedIndex(principalIndex != -1 ? principalIndex : 0);
                        }
                    }
                });
            }
        });
        thd.start();
    }

    private void getAutoLearnState() throws Exception {
        this.autoLearn.setSelected(false);
        SnmpPeer masterPeer = (SnmpPeer)this.getModelValue("CFS_MASTER_SWITCH");
        PortSecurityRif psProxy = ClientController.getInstance().assertPortSecurity();
        SnmpUserOpt userOpt = ClientController.getInstance().getFabric().getSnmpUserOpt();
        Object ctxt = ((PortSecurityWizard)this.getWizard()).getContext();
        int vsanId = ctxt != null && ctxt instanceof Vsan ? (int)((Vsan)ctxt).getId() : -1;
        boolean autoLearnState = psProxy.isAutoLearnEnabled(masterPeer.getAddress().getHostAddress(), userOpt, vsanId, this.reportIdAutoLearn);
        this.setModelValue("AUTO_LEARNT", autoLearnState);
    }

    private void updateListModel(int value) {
        DefaultListModel model = (DefaultListModel)this._switchLst.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CfsSwitchPeer pr = (CfsSwitchPeer)model.get(i);
            if (value == 1) {
                pr._featureState = true;
                continue;
            }
            if (value == 2) {
                pr._cfs = true;
                continue;
            }
            if (value != 3) continue;
            pr._isMergeFailed = false;
        }
    }

    @Override
    public void dispose() {
        try {
            PortSecurityRif psProxy = ClientController.getInstance().assertPortSecurity();
            if (this.runState == 6) {
                psProxy.stopAction(11, this.reportIdAutoLearn);
            } else if (this.reportIdPS != -1) {
                psProxy.stopAction(10, this.reportIdPS);
            }
            ((PortSecurityWizard)this.getWizard()).stopTimer();
            psProxy.cleanUp(this.reportIdAutoLearn);
            this.reportIdAutoLearn = -1;
            psProxy.cleanUp(this.reportIdPS);
            this.reportIdPS = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == ((PortSecurityWizard)this.getWizard()).statusTimer && !((PortSecurityWizard)this.getWizard()).isStopped) {
                if (this.runState == 6) {
                    this.timerActionAutoLearn();
                } else {
                    this.timerAction();
                }
            }
        }
        catch (Exception ex) {
            ((PortSecurityWizard)this.getWizard()).setCursor(false);
            this.getWizard().setStatus(ex.getMessage());
            Util.errorMessage((Component)this.getWizard(), ex.getMessage());
        }
    }

    private void startAutoLearnProcess() {
        try {
            if (this.isAutoLearnRunNeeded()) {
                ((PortSecurityWizard)this.getWizard()).stopTimer();
                PortSecurityRif psProxy = ClientController.getInstance().assertPortSecurity();
                CfsSwitchPeer pr = (CfsSwitchPeer)this._switchLst.getSelectedValue();
                SnmpUserOpt userOpt = ClientController.getInstance().getFabric().getSnmpUserOpt();
                Object ctxt = ((PortSecurityWizard)this.getWizard()).getContext();
                int vsanId = ctxt != null && ctxt instanceof Vsan ? (int)((Vsan)ctxt).getId() : -1;
                psProxy.resetStopAction(11, this.reportIdAutoLearn);
                psProxy.runAutoLearnProcedure(pr._peer.getAddress().getHostAddress(), userOpt, vsanId, this.reportIdAutoLearn);
                ((PortSecurityWizard)this.getWizard()).startTimer(this);
                this.setModelValue("AUTO_LEARNT", this.autoLearn.isSelected());
            } else {
                ((PortSecurityWizard)this.getWizard()).setCursor(false);
                this.clearServerSideObjects();
                super.doNext();
            }
        }
        catch (Exception ex) {
            ((PortSecurityWizard)this.getWizard()).setCursor(false);
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            this.getWizard().getNavigator().getBackBtn().setEnabled(true);
            Util.errorMessage((Component)this.getWizard(), ex);
            ((PortSecurityWizard)this.getWizard()).setCursor(false);
            this.getWizard().setStatus("Failed");
        }
    }

    public void clearServerSideObjects() {
        try {
            PortSecurityRif psProxy = ClientController.getInstance().assertPortSecurity();
            psProxy.cleanUp(this.reportIdAutoLearn);
            this.reportIdAutoLearn = -1;
            psProxy.cleanUp(this.reportIdPS);
            this.reportIdPS = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void timerActionAutoLearn() throws Exception {
        if (((PortSecurityWizard)this.getWizard()).statusTimer == null) {
            return;
        }
        PortSecurityRif psProxy = ClientController.getInstance().assertPortSecurity();
        this.getWizard().setStatus(psProxy.getStatus(11, this.reportIdAutoLearn));
        ((PortSecurityWizard)this.getWizard()).elapsedSecs += 3000;
        if (psProxy.isError(11, this.reportIdAutoLearn)) {
            ((PortSecurityWizard)this.getWizard()).statusTimer.stop();
            ((PortSecurityWizard)this.getWizard()).statusTimer = null;
            Exception[] ex = psProxy.getErrorException(11, this.reportIdAutoLearn);
            if (ex != null && ex.length > 0) {
                throw ex[0];
            }
            throw new Exception("Failed");
        }
        if (psProxy.isAutoLearnProcessSuccess(this.reportIdAutoLearn)) {
            ((PortSecurityWizard)this.getWizard()).stopTimer();
            this.autoLearn.setSelected(false);
            this.getWizard().setModelValue("AUTO_LEARNT", Boolean.TRUE);
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            this.getWizard().getNavigator().getBackBtn().setEnabled(true);
            ((PortSecurityWizard)this.getWizard()).setCursor(false);
            this.clearServerSideObjects();
            super.doNext();
        }
    }

    private void timerAction() throws Exception {
        if (((PortSecurityWizard)this.getWizard()).statusTimer == null) {
            return;
        }
        PortSecurityRif psProxy = ClientController.getInstance().assertPortSecurity();
        this.getWizard().setStatus(psProxy.getStatus(10, this.reportIdPS));
        ((PortSecurityWizard)this.getWizard()).elapsedSecs += 3000;
        if (psProxy.isError(10, this.reportIdPS)) {
            ((PortSecurityWizard)this.getWizard()).statusTimer.stop();
            ((PortSecurityWizard)this.getWizard()).statusTimer = null;
            Exception[] ex = psProxy.getErrorException(10, this.reportIdPS);
            if (ex != null && ex.length > 0) {
                throw ex[0];
            }
            throw new Exception("Failed");
        }
        if (psProxy.isLastActionSuccess(10, this.reportIdPS)) {
            ((PortSecurityWizard)this.getWizard()).stopTimer();
            Object ctxt = ((PortSecurityWizard)this.getWizard()).getContext();
            int vsanId = ctxt != null && ctxt instanceof Vsan ? (int)((Vsan)ctxt).getId() : -1;
            switch (this.runState) {
                case 1: {
                    this.getWizard().setStatus("Start Enabling Port Security");
                    this.showMsgDlg("Start Enabling Port Security");
                    this.runState = 2;
                    psProxy.enableFeaturesPS(this.getFeatureSwitchList(), 0, ClientController.getInstance().getFabric().getSnmpUserOpt(), this.reportIdPS);
                    this.getWizard().setStatus("Enabling Port Security");
                    ((PortSecurityWizard)this.getWizard()).startTimer(this);
                    break;
                }
                case 2: {
                    this.updateListModel(1);
                    this.getWizard().setStatus("Enabled Port Security");
                    this.runState = 3;
                    this.showMsgDlg("Start Enabling CFS");
                    psProxy.enableCFSPS(this.getCFSSwitchList(false), 0, ClientController.getInstance().getFabric().getSnmpUserOpt(), this.reportIdPS);
                    this.getWizard().setStatus("Enabling CFS");
                    ((PortSecurityWizard)this.getWizard()).startTimer(this);
                    break;
                }
                case 3: {
                    this.updateListModel(2);
                    this.getWizard().setStatus("Validate CFS Merge");
                    this.runState = 4;
                    this.showMsgDlg("Start validating CFS");
                    psProxy.validateMergeCompletion(this.getCFSSwitchList(true), 0, new int[]{vsanId != -1 ? 2 : 1, vsanId}, ClientController.getInstance().getFabric().getSnmpUserOpt(), this.reportIdPS);
                    ((PortSecurityWizard)this.getWizard()).startTimer(this);
                    break;
                }
                case 4: {
                    CfsSwitchPeer pr = (CfsSwitchPeer)this._switchLst.getSelectedValue();
                    this.runState = 5;
                    this.getWizard().setStatus("Enabled CFS");
                    this.showMsgDlg("Issuing commit to clear any merge failures");
                    psProxy.clearMergeFailurePS(pr._peer.getAddress().getHostAddress(), 0, new int[]{vsanId != -1 ? 2 : 1, vsanId}, ClientController.getInstance().getFabric().getSnmpUserOpt(), this.reportIdPS);
                    ((PortSecurityWizard)this.getWizard()).startTimer(this);
                    this.getWizard().setStatus("Clearing any Merge Failures");
                    break;
                }
                case 5: {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exx) {
                        // empty catch block
                    }
                    this.updateListModel(3);
                    if (this.isAutoLearnRunNeeded()) {
                        this.runState = 6;
                        this.showMsgDlg("Start autolearn process");
                        this.startAutoLearnProcess();
                        this.getWizard().setStatus("Starting Auto Learn process");
                        break;
                    }
                    this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                    ((PortSecurityWizard)this.getWizard()).setCursor(false);
                    this.clearServerSideObjects();
                    super.doNext();
                }
            }
        }
    }

    private void showMsgDlg(String msg) {
    }
}

