/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.common.model.ddm.DDMJob;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import com.cisco.dcbu.sm.common.rif.DMMException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DMMStatusJobLog
extends JDialog
implements ActionListener {
    DDMJob _job;
    JTextArea _log;
    JButton[] _buttons;
    static final int WHEN = 0;
    static final int DATE = 1;

    public DMMStatusJobLog(DDMJob job) {
        block2: {
            super((Frame)BrowserFrame.getInstance(), "Job Log - Data Mobility Manager");
            this._job = job;
            try {
                JPanel center = new JPanel(new BorderLayout());
                this._log = new JTextArea();
                this._log.setEditable(false);
                this._log.setWrapStyleWord(true);
                this._log.setLineWrap(true);
                this._log.setFont(ChangedCellRenderer.getNormalFont());
                JScrollPane sp = new JScrollPane(this._log);
                sp.setPreferredSize(new Dimension(500, 160));
                String[] buttons = new String[]{"Close"};
                DialogUtil.buildDialog((JDialog)this, (Container)BrowserFrame.getInstance(), (Container)sp, (AbstractButton[])DialogUtil.buildButtons(buttons, (ActionListener)this));
                this.setResizable(true);
                DisplayJobLogThread logThread = new DisplayJobLogThread();
                logThread.start();
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex.getMessage());
                if (!SnmpSession.isTrace()) break block2;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    class DisplayJobLogThread
    extends Thread {
        DisplayJobLogThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DMMStatusJobLog.this._log.setCursor(Cursor.getPredefinedCursor(3));
                DDMServerRif ddmServerRif = ClientController.getInstance().getDDMServerRif();
                DMMStatusJobLog.this._log.setText(ddmServerRif.getJobLog(DMMStatusJobLog.this._job));
            }
            catch (Exception ex) {
                if (ex instanceof DMMException) {
                    Util.errorMessage((Component)DMMStatusJobLog.this._log, ((DMMException)ex).getMessage());
                } else {
                    Util.errorMessage((Component)DMMStatusJobLog.this._log, ex);
                }
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            finally {
                DMMStatusJobLog.this._log.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

