/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.datamig.RTPmConfig;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class RealTimeStatDialog
extends JDialog
implements ActionListener {
    TimeSeriesCollection _dataSet;
    JFreeChart _chart;
    ChartPanel _chartPanel;
    Second _lastUpdated;
    int _interval = 3;
    Timer _timer;
    JComboBox _enclosureCbx;
    JComboBox _fabCbx;
    JComboBox _vsanCbx;
    JList _endPortList;
    JList _inList;
    JList _islList;
    JTabbedPane _tabPane;
    HashMap<WwnKey, RTPmConfig> _entityMap = new HashMap();

    public RealTimeStatDialog(JFrame parent) throws Exception {
        super(parent);
        this.setTitle("Real Time Stats: ");
        this.setSize(750, 530);
        this.init();
        this.setLocationRelativeTo(this.getParent());
        this._timer = new Timer(this._interval * 1000, this);
        this._timer.setRepeats(true);
    }

    void init() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this._dataSet = this.createDataset();
        this._chart = ChartFactory.createTimeSeriesChart((String)"Real Time Stats", (String)"Time", (String)"Value", (XYDataset)this._dataSet, (boolean)true, (boolean)true, (boolean)false);
        this._chartPanel = new ChartPanel(this._chart);
        this._chartPanel.setPreferredSize(new Dimension(500, 270));
        this.getContentPane().add((Component)this._chartPanel, "Center");
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        this.getContentPane().add((Component)btnPanel, "South");
        JButton btn = new JButton("start");
        btn.addActionListener(this);
        btnPanel.add(btn);
        btn = new JButton("stop");
        btn.addActionListener(this);
        btnPanel.add(btn);
        btn = new JButton("reset");
        btn.addActionListener(this);
        btnPanel.add(btn);
        btn = new JButton("close");
        btn.addActionListener(this);
        btnPanel.add(btn);
        this.getContentPane().add((Component)this.createEntityPanel(), "West");
        this.pack();
    }

    private JPanel createEntityPanel() throws RemoteException, Exception {
        JPanel entityPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        entityPanel.setLayout(layout);
        this._tabPane = new JTabbedPane();
        this._tabPane.add("Host/Storage", this.createEnclosurePanel());
        this._tabPane.add("Host/Storage", this.createIslPanel());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 10.0;
        c.weighty = 40.0;
        entityPanel.add((Component)this._tabPane, c);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        JButton addbtn = new JButton("add");
        addbtn.setActionCommand("add");
        btnPanel.add(addbtn);
        addbtn.addActionListener(this);
        JButton deletebtn = new JButton("delete");
        deletebtn.setActionCommand("delete");
        btnPanel.add(deletebtn);
        deletebtn.addActionListener(this);
        c.gridy = 3;
        c.weightx = 10.0;
        c.weighty = 10.0;
        entityPanel.add((Component)btnPanel, c);
        this._inList = new JList();
        this._inList.setVisibleRowCount(10);
        this._inList.setModel(new DefaultListModel());
        c.gridy = 4;
        c.weightx = 10.0;
        c.weighty = 40.0;
        c.fill = 1;
        entityPanel.add((Component)new JScrollPane(this._inList), c);
        return entityPanel;
    }

    private JPanel createEnclosurePanel() throws RemoteException, Exception {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        this._enclosureCbx = new JComboBox();
        EnclosureBase[] all = null;
        all = ClientController.getInstance().assertModelFacade().getEnclosures();
        for (int i = 0; i < all.length; ++i) {
            this._enclosureCbx.addItem(all[i]);
        }
        this._enclosureCbx.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 10.0;
        c.weighty = 10.0;
        panel.add((Component)this._enclosureCbx, c);
        this._endPortList = new JList();
        this._endPortList.setVisibleRowCount(10);
        this._endPortList.setModel(new DefaultListModel());
        c.gridy = 2;
        c.weightx = 10.0;
        c.weighty = 40.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this._endPortList), c);
        return panel;
    }

    private JPanel createIslPanel() throws RemoteException, Exception {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        this._fabCbx = new JComboBox();
        Fabric[] allFab = ClientController.getInstance().getFabrics();
        for (int i = 0; i < allFab.length; ++i) {
            this._fabCbx.addItem(allFab[i]);
        }
        this._fabCbx.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 10.0;
        c.weighty = 10.0;
        panel.add((Component)this._fabCbx, c);
        this._vsanCbx = new JComboBox();
        this._vsanCbx.addActionListener(this);
        c.gridy = 2;
        c.weighty = 10.0;
        panel.add((Component)this._vsanCbx, c);
        this._islList = new JList();
        this._islList.setVisibleRowCount(10);
        this._islList.setModel(new DefaultListModel());
        c.gridy = 3;
        c.weightx = 10.0;
        c.weighty = 40.0;
        c.fill = 1;
        panel.add((Component)new JScrollPane(this._islList), c);
        return panel;
    }

    private void populateEndPorts(EnclosureBase encl) {
        DefaultListModel listModel = (DefaultListModel)this._endPortList.getModel();
        listModel.clear();
        List<WwnKey> epKeys = encl.getEndPortPKs();
        for (WwnKey key : epKeys) {
            listModel.addElement(key);
        }
    }

    private void populateIsl(Fabric fab, Vsan vsan) {
        DefaultListModel listModel = (DefaultListModel)this._islList.getModel();
        listModel.clear();
        Isl[] isls = vsan.getIsls();
        for (int i = 0; i < isls.length; ++i) {
            listModel.addElement(isls[i]);
        }
    }

    private void populateVsan(Fabric fab) {
        this._vsanCbx.removeAll();
        Vsan[] allV = fab.getVsans();
        for (int i = 0; i < allV.length; ++i) {
            this._vsanCbx.addItem(allV[i]);
        }
    }

    public TimeSeriesCollection createDataset() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        return dataset;
    }

    private void addTimeSeries(WwnKey wwn) {
        if (wwn != null && wwn.toString() != null) {
            TimeSeries result = new TimeSeries((Comparable)((Object)wwn.toString()), Second.class);
            this._dataSet.addSeries(result);
            ((DefaultListModel)this._inList.getModel()).addElement(wwn);
            try {
                this._entityMap.put(wwn, new RTPmConfig(wwn, result));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void deleteTimeSeries(WwnKey wwn) {
        if (wwn != null && wwn.toString() != null) {
            TimeSeries result = new TimeSeries((Comparable)((Object)wwn.toString()), Second.class);
            this._dataSet.removeSeries(this._entityMap.remove(wwn).getTimeSeries());
            ((DefaultListModel)this._inList.getModel()).removeElement(wwn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == null) {
            Second now = new Second();
            for (WwnKey key : this._entityMap.keySet()) {
                this._entityMap.get(key).updateStats();
            }
            this._chartPanel.validate();
        } else if (e.getActionCommand().equals("add")) {
            WwnKey key = (WwnKey)this._endPortList.getSelectedValue();
            this.addTimeSeries(key);
        } else if (e.getActionCommand().equals("delete")) {
            WwnKey key = (WwnKey)this._inList.getSelectedValue();
            this.deleteTimeSeries(key);
        } else if (e.getActionCommand().equals("start")) {
            this._timer.start();
        } else if (e.getActionCommand().equals("stop")) {
            this._timer.stop();
        } else if (e.getActionCommand().equals("close")) {
            this.dispose();
        } else if (e.getActionCommand().equals("reset")) {
            int count = this._dataSet.getSeriesCount();
            for (int i = count - 1; i >= 0; --i) {
                this._dataSet.removeSeries(this._dataSet.getSeries(i));
            }
        } else if (e.getSource() == this._enclosureCbx) {
            EnclosureBase encl = (EnclosureBase)this._enclosureCbx.getSelectedItem();
            this.populateEndPorts(encl);
        } else if (e.getSource() == this._fabCbx) {
            Fabric fab = (Fabric)this._fabCbx.getSelectedItem();
            this.populateVsan(fab);
        } else if (e.getSource() == this._vsanCbx) {
            Vsan vsan = (Vsan)this._vsanCbx.getSelectedItem();
            Fabric fab = (Fabric)this._fabCbx.getSelectedItem();
            this.populateIsl(fab, vsan);
        }
    }
}

