/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SmCacheUtil {
    public static final String FILTERS = "cpkiMapFilterName";
    public static final String VFC_ETH = "cfcoeStaticVfcBindIfIndex";
    public static final String VFC_ETH_LABELS = "EthernetInterfaceLabels";
    private static SmCacheUtil _Instance;
    HashMap<String, HashMap> _mapList;
    HashMap<SnmpPeer, List> _peers2Profiles = new HashMap();
    HashMap<SnmpPeer, List> _peers2Filters = new HashMap();
    HashMap<SnmpPeer, List> _peers2Roles = new HashMap();
    HashMap<SnmpPeer, List> _peers2VFCEthPorts;
    HashMap<SnmpPeer, HashMap> _peers2VfcEthLabels;

    public static SmCacheUtil getInstance() {
        if (_Instance == null) {
            _Instance = new SmCacheUtil();
        }
        return _Instance;
    }

    private SmCacheUtil() {
        this._mapList = new HashMap();
        this._peers2VFCEthPorts = new HashMap();
        this._peers2VfcEthLabels = new HashMap();
        this._mapList.put(FILTERS, this._peers2Filters);
        this._mapList.put(VFC_ETH, this._peers2VFCEthPorts);
        this._mapList.put(VFC_ETH_LABELS, this._peers2VfcEthLabels);
    }

    public HashMap getMap(String name) {
        return this._mapList.get(name);
    }

    public void setMap(String name, HashMap map) {
        this._mapList.put(name, map);
    }

    public void addEntry(String mibVar, SnmpPeer peer, String entry) {
        HashMap map = this._mapList.get(mibVar);
        ArrayList<String> peerEntries = (ArrayList<String>)map.get(peer);
        if (peerEntries == null) {
            peerEntries = new ArrayList<String>();
        }
        if (!peerEntries.contains(entry)) {
            peerEntries.add(entry);
            map.put(peer, peerEntries);
        }
    }

    public void clearEntries(String mibVar) {
        HashMap map = this._mapList.get(mibVar);
        if (map != null) {
            map.clear();
        }
    }

    List getPeerEntries(String mibVar, SnmpPeer peer) {
        HashMap map = this._mapList.get(mibVar);
        if (map == null) {
            return new ArrayList();
        }
        return (List)map.get(peer);
    }
}

