/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmPhysicalSummaryTableModel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;

public class SmCardTableModel
extends SmTableModel {
    static final int NAME_COL = 2;
    static final int MODEL_COL = 3;
    static final int OPER_STATUS_COL = 4;

    @Override
    protected boolean bAddElementRow(VarBindList vbl, SnmpPeer node, SnmpOID index, int state) {
        int[] indexVb = index.getValue();
        if (indexVb[0] > 85 && indexVb[0] <= 100000021) {
            return false;
        }
        return super.bAddElementRow(vbl, node, index, state);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        if (nodes == null) {
            return new Array(0);
        }
        SmFilter[] filters = new SmFilter[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(nodes[i].getAddress());
            int[] modelindices = sw.getCardPhysicalIndices();
            if (modelindices != null) {
                int[][] indices = SmPhysicalSummaryTableModel.getIndices2Array(modelindices);
                filters[i] = new SmFilter(nodes[i], indices);
                continue;
            }
            filters[i] = null;
        }
        return super.getTableVars(filters, false);
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        if (col == 4) {
            int activeSupSlotIndex = sw.getActiveSupSlot() + 21;
            int curSlotIndex = index.getValue()[0];
            if (curSlotIndex == activeSupSlotIndex) {
                String operStatus = super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl).toString();
                return operStatus + " (active)";
            }
        }
        return super.getCellDisplayString(node, mibNode, vbl, vb, var, row, col, index, indexOfVbl);
    }
}

