/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmRoleUtil;
import com.cisco.dcbu.sm.client.gui.SmTableModel;

public class SmCommonRoleTableModel
extends SmTableModel {
    static final int SCOPEENABLE_MIB = 1;
    static final int SCOPE1k_MIB = 2;
    static final int SCOPE2k_MIB = 3;
    static final int[] _commonRoleScope1Oid = MibNode.get("commonRoleScope1").getOid();

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        SmRoleUtil.getInstance().clearRoles();
        return super.getTableVars(nodes);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        SnmpString scope1 = (SnmpString)vbl.getVb(2).getVar();
        SnmpString scope2 = (SnmpString)vbl.getVb(3).getVar();
        PortInterfaceUtil.getInstance(4).getVsan(scope1, scope2, true);
        int[] indexOid = index.getValue();
        SmRoleUtil.getInstance().addRole(node, SnmpString.toString(indexOid, 1, indexOid.length));
        return super.addElement(vbl, node, index);
    }

    @Override
    protected SnmpVar processChangedCell(Cell cell, SnmpPDU pdu, SnmpOID changedCellOid, int[] index) throws Exception {
        SnmpVar changedCellVar = super.processChangedCell(cell, pdu, changedCellOid, index);
        if (changedCellOid.startsWith(_commonRoleScope1Oid)) {
            PortInterfaceUtil.getInstance(4).addVsan4k2Pdu(pdu, changedCellOid, changedCellVar, index);
            this._fragPduOnByte = true;
        }
        return changedCellVar;
    }

    @Override
    public boolean isCellActive(int row, int col) {
        if (col == 2 + this._offset) {
            Object o = this.getValueAt(row, 1 + this._offset);
            return (Boolean)o;
        }
        return super.isCellActive(row, col);
    }
}

