/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.SmCfsUtil;
import com.cisco.dcbu.sm.client.gui.SmTableModel;

public class SmDeviceAliasErrorTableModel
extends SmTableModel {
    private String _cfsFeatureName;
    private int _vsan;
    static final int PEER = 0;
    static final int DEVALIAS_CHKSM = 1;
    static final String[] LABELS = new String[]{"Switch", "Discrepancy"};

    public SmDeviceAliasErrorTableModel(String cfsFeatureName, int vsan) {
        this._cfsFeatureName = cfsFeatureName;
        this._vsan = vsan;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        this.setHeaders(LABELS);
    }

    @Override
    public Array getVars(SnmpPeer[] nodes) throws SnmpException {
        Array responseData = super.getVars(nodes);
        Array<Object[]> modData = new Array<Object[]>();
        SnmpPeer refPeer = SmCfsUtil.getInstance().getMaster(this._cfsFeatureName + this._vsan);
        int refPeerRow = -1;
        if (refPeer != null) {
            for (int i = 0; i < responseData.size(); ++i) {
                Object[] rowData = (Object[])responseData.elementAt(i);
                if (rowData[0] != refPeer) continue;
                refPeerRow = i;
                break;
            }
        } else if (responseData.size() > 0) {
            refPeerRow = 0;
        }
        if (refPeerRow != -1) {
            Object[] refRowData = (Object[])responseData.elementAt(refPeerRow);
            for (int i = 0; i < responseData.size(); ++i) {
                Object[] rowData = (Object[])responseData.elementAt(i);
                if (rowData[0] == refPeer || rowData[1].toString().equals(refRowData[1].toString())) continue;
                modData.addElement(new Object[]{rowData[0], "Device Aliases differs from " + refRowData[0]});
            }
        }
        return modData;
    }
}

