/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmFCIPTunnelBaseTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class SmFCIPTunnelAdvTableModel
extends SmFCIPTunnelBaseTableModel {
    static final int CTRL_QOS = 5;
    static final int DATA_QOS = 6;
    static final int TAPE_ACC = 10;
    static final int TAPE_MAX_OS = 13;
    static final int[] _cfmFcipLinkExtCntrlQOSFieldOid = MibNode.get("cfmFcipLinkExtCntrlQOSField").getOid();
    static final int[] _cfmFcipLinkExtDataQOSFieldOid = MibNode.get("cfmFcipLinkExtDataQOSField").getOid();

    @Override
    protected HashMap buildSendPdus() throws Exception {
        int i;
        Array cells = this.getChanged();
        if (cells == null) {
            return null;
        }
        Array<String> warningMsg = new Array<String>();
        if (this._cellCheckers != null) {
            this.resetCheckerPostFlag();
        }
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        for (i = 0; i < cells.size(); ++i) {
            String msg;
            Cell cell = (Cell)cells.elementAt(i);
            SnmpPeer node = this.getRowPeer(cell._row);
            SnmpPDU pdu = (SnmpPDU)pdus.get(node);
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(node.getAddress());
                pdus.put(node, pdu);
            }
            int[] index = this.getIndex(cell._row);
            SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
            SnmpVar changedCellVar = this.getChangedCellVar(cell._row, cell._col, oid, index);
            if (this._cellCheckers != null && (msg = this.checkChangedCell(node, oid, changedCellVar)) != null) {
                warningMsg.addElement(msg);
            }
            if (oid.startsWith(_cfmFcipLinkExtCntrlQOSFieldOid)) {
                if (i + 1 < cells.size()) {
                    Cell nextCell = (Cell)cells.elementAt(i + 1);
                    if (nextCell._row == cell._row && SnmpOID.startsWith(this._mibNodes[nextCell._col].getOid(), _cfmFcipLinkExtDataQOSFieldOid)) {
                        ++i;
                    }
                }
                pdu.addVar(new SnmpOID(_cfmFcipLinkExtDataQOSFieldOid, index), (SnmpVar)this.getValueAt(cell._row, 6));
            } else if (oid.startsWith(_cfmFcipLinkExtDataQOSFieldOid)) {
                pdu.addVar(new SnmpOID(_cfmFcipLinkExtCntrlQOSFieldOid, index), (SnmpVar)this.getValueAt(cell._row, 5));
            }
            pdu.addVar(oid, changedCellVar);
        }
        if (warningMsg.size() != 0) {
            for (i = 0; i < warningMsg.size(); ++i) {
                if (JOptionPane.showConfirmDialog(BrowserFrame.getDataView(), (String)warningMsg.elementAt(i), "Select an Option", 0) == 0) continue;
                return null;
            }
        }
        return pdus;
    }

    @Override
    public boolean isCellActive(int row, int col) {
        switch (col) {
            case 13: {
                Object tapeAc = this.getValueAt(row, 10);
                if (tapeAc instanceof Boolean) {
                    return (Boolean)tapeAc;
                }
                return false;
            }
        }
        return super.isCellActive(row, col);
    }

    @Override
    protected SnmpVar getChangedCellVar(int row, int col, SnmpOID changedCellOid, int[] index) throws Exception {
        Object[] values;
        long lifeTime;
        if (col == 13 && (lifeTime = ((SnmpGauge)(values = (Object[])this.getData().elementAt(row))[13]).getValue()) == 0L) {
            return new SnmpUnsignedInt(0L);
        }
        return super.getChangedCellVar(row, col, changedCellOid, index);
    }
}

