/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import java.util.ArrayList;
import java.util.HashMap;

public class SmFCIPTunnelBaseTableModel
extends SmTableModel {
    private HashMap _peers2TunnelIds = new HashMap();
    static final int QUERY_TYPE_TUNNELID = 1;

    @Override
    public Array getTableVars(MgmtDomainIf mgmtDomain, boolean isScalar) throws SnmpException {
        this._peers2TunnelIds.clear();
        if (mgmtDomain.isSan() || mgmtDomain.isFabric()) {
            return super.getTableVars(mgmtDomain);
        }
        SmFilter[] filters = mgmtDomain.getFilters((short)4608);
        if (filters.length != 0) {
            for (int i = 0; i < filters.length; ++i) {
                if (filters[i].getIndicesCount() == 0) continue;
                SnmpPeer peer = filters[i].getSnmpPeer();
                ArrayList<int[]> ifList = (ArrayList<int[]>)this._peers2TunnelIds.get(peer);
                if (ifList == null) {
                    ifList = new ArrayList<int[]>();
                    this._peers2TunnelIds.put(peer, ifList);
                }
                int[][] queryIndices = this.getTableVarsIndices(filters[i]);
                for (int j = 0; j < queryIndices.length; ++j) {
                    if (IfIndexUtil.getType(queryIndices[j][0]) != 10) continue;
                    int tunnelId = IfIndexUtil.ifIndex2Fcip(queryIndices[j][0]);
                    ifList.add(new int[]{-1, tunnelId});
                }
                if (ifList.size() != 0) continue;
                this._peers2TunnelIds.remove(peer);
            }
            if (this._peers2TunnelIds.size() != 0) {
                SmFilter[] invoker = new SmFilter[this._peers2TunnelIds.size()];
                SnmpPeer[] peers = this._peers2TunnelIds.keySet().toArray(new SnmpPeer[this._peers2TunnelIds.size()]);
                for (int i = 0; i < invoker.length; ++i) {
                    ArrayList indexList = (ArrayList)this._peers2TunnelIds.get(peers[i]);
                    invoker[i] = new SmFilter(peers[i], (int[][])indexList.toArray((T[])new int[indexList.size()][]));
                }
                return this.getTableVars(invoker);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        this._responseData = new Array();
        if (invoker == null || invoker.length == 0) {
            return this._responseData;
        }
        int profileId = invoker[0].getIndex(0, 0);
        int tunnelId = invoker[0].getIndex(0, 1);
        if (profileId != -1 && tunnelId != -1) {
            return super.getTableVars(invoker);
        }
        if (tunnelId == -1) {
            return super.getMultiIndexedTableVars(invoker);
        }
        this.setData(this._responseData);
        this._state = 4;
        int peersLen = invoker.length;
        this._firstOid = this._mibNodes[this._offset].getOid();
        this._peers2TunnelIds.clear();
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < peersLen; ++i) {
                SnmpPeer peer = invoker[i].getSnmpPeer();
                ArrayList<int[]> indexList = (ArrayList<int[]>)this._peers2TunnelIds.get(peer);
                if (indexList == null) {
                    indexList = new ArrayList<int[]>();
                    this._peers2TunnelIds.put(peer, indexList);
                }
                int[][] queryIndices = this.getTableVarsIndices(invoker[i]);
                for (int j = 0; j < queryIndices.length; ++j) {
                    indexList.add(queryIndices[j]);
                }
                SnmpFetch f = new SnmpFetch();
                f.getBulk(peer, this._vars, (SnmpCallbackIf)this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
        return this._responseData;
    }

    @Override
    protected boolean bAddElementRow(VarBindList vbl, SnmpPeer node, SnmpOID index, int state) {
        int[] indexVb = index.getValue();
        ArrayList indexList = (ArrayList)this._peers2TunnelIds.get(node);
        if (indexList != null) {
            for (int i = 0; i < indexList.size(); ++i) {
                int[] indexReq = (int[])indexList.get(i);
                if (indexVb[indexVb.length - 1] != indexReq[1]) continue;
                return true;
            }
        }
        return false;
    }
}

