/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntHashMap;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class SmFcInterfaceTableModel
extends SmTableModel {
    protected int _ifType;
    protected short _addVsanId = 0;
    protected IntHashMap _switch2ColIndex;
    static final int QUAIL_connUnitPort_MIBLEN = 17;
    static final int QUAIL_FC_MIBLEN = 2;

    public SmFcInterfaceTableModel(int ifType) {
        this._ifType = ifType;
    }

    public SmFcInterfaceTableModel(int ifType, short addVsanId) {
        this._ifType = ifType;
        this._addVsanId = addVsanId;
    }

    public SmFcInterfaceTableModel() {
    }

    public SmFcInterfaceTableModel(int ifType, String bitmap, String tooltip, int insertBefore, String action, ActionListener listener) {
        super(bitmap, tooltip, insertBefore, action, listener);
        this._ifType = ifType;
    }

    public void setAddVsanId(short addVsanId) {
        this._addVsanId = addVsanId;
    }

    @Override
    protected boolean isModelTypeSupported(SnmpPeer peer) {
        boolean supported = super.isModelTypeSupported(peer);
        if (supported && this._ifType == 8) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            supported = sw.isFcoeCapable();
        }
        return supported;
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        switch (this._ifType) {
            case 1: {
                this._stopIndex = 0x2000000;
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.getLogicalTableVars(nodes, this._ifType);
            }
            case 8: {
                return this.getVfcTableVars(nodes);
            }
        }
        return super.getTableVars(nodes);
    }

    public Array getLogicalTableVars(SnmpPeer[] nodes, int ifType) throws SnmpException {
        Array returnData = new Array();
        switch (ifType) {
            case 11: {
                this._index = 0x3FFFFFF;
                this._stopIndex = 0x5000000;
                Array getData = super.getTableVars(nodes);
                returnData.append(getData);
                break;
            }
            case 10: {
                this._index = 0x9FFFFFF;
                this._stopIndex = 0xB000000;
                Array getData = super.getTableVars(nodes);
                returnData.append(getData);
                break;
            }
            case 9: {
                this._index = 0xAFFFFFF;
                this._stopIndex = 0xC000000;
                Array getData = super.getTableVars(nodes);
                returnData.append(getData);
                break;
            }
            case 12: {
                this._index = 0xBFFFFFF;
                this._stopIndex = 0xF000000;
                Array getData = super.getTableVars(nodes);
                returnData.append(getData);
                break;
            }
            case 2: {
                this._index = 0x3FFFFFF;
                this._stopIndex = 0x5000000;
                Array getData = super.getTableVars(nodes);
                returnData.append(getData);
                this._index = 0x9FFFFFF;
                this._stopIndex = 0xF000000;
                getData = super.getTableVars(nodes);
                returnData.append(getData);
                getData = this.getVfcTableVars(nodes);
                returnData.append(getData);
            }
        }
        this._responseData = returnData;
        return this._responseData;
    }

    private Array getVfcTableVars(SnmpPeer[] nodes) throws SnmpException {
        Array getData;
        Array returnData = new Array();
        ArrayList<SnmpPeer> oldPeers = new ArrayList<SnmpPeer>();
        ArrayList<SnmpPeer> newPeers = new ArrayList<SnmpPeer>();
        Switch sw = null;
        for (SnmpPeer peer : nodes) {
            sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
            if (sw.isN5K() && sw.isVersionLessThan("4.1(3)")) {
                oldPeers.add(peer);
                continue;
            }
            newPeers.add(peer);
        }
        if (newPeers.size() > 0) {
            this._index = 0x1DFFFFFF;
            this._stopIndex = 0x1F000000;
            getData = super.getTableVars(newPeers.toArray(new SnmpPeer[newPeers.size()]));
            returnData.append(getData);
        }
        if (oldPeers.size() > 0) {
            sw = ClientController.findFabricSwitchByIpAddress(((SnmpPeer)oldPeers.get(0)).getAddress());
            this._index = IfIndexUtil.getFirstValidIfIndexFor(sw.getActualType(30)) - 1;
            this._stopIndex = IfIndexUtil.getLastValidIfIndexFor(sw.getActualType(30)) + 1;
            getData = super.getTableVars(oldPeers.toArray(new SnmpPeer[oldPeers.size()]));
            returnData.append(getData);
        }
        this._responseData = returnData;
        return this._responseData;
    }

    @Override
    public Array getTableVars(MgmtDomainIf mgmtDomain, boolean isScalar) throws SnmpException {
        if (this._ifType == 3 || this._ifType == 4 || this._ifType == 5 || this._ifType == 6) {
            return null;
        }
        if (mgmtDomain.isSan() || mgmtDomain.isFabric()) {
            return super.getTableVars(mgmtDomain);
        }
        SmFilter[] filters = mgmtDomain.getFilters(this.getFilter(), this._addVsanId);
        if (filters.length != 0) {
            BrowserFrame.getDataView().setValidateVbl(true);
            return this.getTableVars(filters);
        }
        return null;
    }

    private short getFilter() {
        switch (this._ifType) {
            case 1: {
                return 4352;
            }
            case 8: {
                return 6144;
            }
            case 11: {
                return 5136;
            }
            case 10: {
                return 6145;
            }
            case 9: {
                return 6146;
            }
            case 12: {
                return 6147;
            }
        }
        return 4608;
    }

    @Override
    protected int[] getCellGetIndex(Switch sw, int col, int[] defaultIndex) {
        int swType = sw.getModelType();
        if (this._switch2ColIndex != null && this._switch2ColIndex.get(swType) != null) {
            if (this.isColumnMatch(sw, col)) {
                if (swType == 514) {
                    int[] sWwn = SnmpString.valueOf(sw.getWwn().getValue(), false);
                    int[] connUnitPortIndex = new int[17];
                    System.arraycopy(sWwn, 0, connUnitPortIndex, 0, sWwn.length);
                    connUnitPortIndex[connUnitPortIndex.length - 1] = defaultIndex[0];
                    return connUnitPortIndex;
                }
            } else {
                return this.getMainTableGetIndex(sw, col, defaultIndex);
            }
        }
        return this.getMainTableGetIndex(sw, col, defaultIndex);
    }

    protected int[] getMainTableGetIndex(Switch sw, int col, int[] defaultIndex) {
        int swType = sw.getModelType();
        if (swType == 514) {
            int[] fcIndex = new int[]{sw.getFcFeModuleId(), defaultIndex[0]};
            return fcIndex;
        }
        return super.getCellGetIndex(sw, col, defaultIndex);
    }

    @Override
    public int[] getCellSetIndex(Cell cell) {
        int[] index = super.getCellSetIndex(cell);
        SnmpPeer node = (SnmpPeer)this.getValueAt(cell._row, 0);
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        if (!sw.isMDS()) {
            int swType = sw.getModelType();
            if (this._switch2ColIndex != null && this._switch2ColIndex.get(swType) != null) {
                if (this.isColumnMatch(sw, cell._col)) {
                    if (swType == 514) {
                        if (index.length == 17) {
                            return index;
                        }
                        int[] sWwn = SnmpString.valueOf(sw.getWwn().getValue(), false);
                        int[] connUnitPortIndex = new int[17];
                        System.arraycopy(sWwn, 0, connUnitPortIndex, 0, sWwn.length);
                        connUnitPortIndex[connUnitPortIndex.length - 1] = index[1];
                        return connUnitPortIndex;
                    }
                } else if (swType == 514) {
                    if (index.length == 2) {
                        return index;
                    }
                    int[] fcPortIndex = new int[]{sw.getFcFeModuleId(), index[index.length - 1]};
                    return fcPortIndex;
                }
            }
        }
        return index;
    }

    public void addSwitch2ColIndex(int switchType, int[] cols) {
        if (this._switch2ColIndex == null) {
            this._switch2ColIndex = new IntHashMap();
        }
        this._switch2ColIndex.put(switchType, cols);
    }

    public boolean isColumnMatch(Switch sw, int col) {
        int swType = sw.getModelType();
        boolean matchCol = false;
        if (this._switch2ColIndex != null && this._switch2ColIndex.get(swType) != null) {
            int[] cols = (int[])this._switch2ColIndex.get(swType);
            for (int i = 0; i < cols.length; ++i) {
                if (col != cols[i]) continue;
                matchCol = true;
            }
        }
        return matchCol;
    }

    @Override
    public int[] getTableGetNextIndex(SnmpPeer node, int[] defaultIndex, int col) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        if (sw.isQuail()) {
            if (this.isColumnMatch(sw, col)) {
                int[] sWwn = SnmpString.valueOf(sw.getWwn().getValue(), false);
                defaultIndex = new int[16];
                System.arraycopy(sWwn, 0, defaultIndex, 0, sWwn.length);
            } else {
                defaultIndex = new int[]{sw.getFcFeModuleId()};
            }
            return defaultIndex;
        }
        return super.getTableGetNextIndex(node, defaultIndex, col);
    }

    @Override
    protected boolean isEnd(SnmpPeer peer, int[] req, SnmpVarBind vb, int[] index, int reqId) {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw.isQuail()) {
            boolean end = super.isEnd(peer, req, vb, index, reqId);
            if (!end) {
                int firstIndex;
                MibNode[] mibNodes = (MibNode[])this._switch2MibNodes.get(sw.getModelType());
                if (mibNodes != null) {
                    for (firstIndex = this._offset; mibNodes[firstIndex] == null && firstIndex < mibNodes.length; ++firstIndex) {
                    }
                }
                if (this.isColumnMatch(sw, firstIndex)) {
                    int[] sWwn = SnmpString.valueOf(sw.getWwn().getValue(), false);
                    int[] expectIndex = new int[16];
                    System.arraycopy(sWwn, 0, expectIndex, 0, sWwn.length);
                    end = !SnmpOID.startsWith(index, expectIndex);
                } else {
                    end = index[0] != sw.getFcFeModuleId();
                }
            }
            return end;
        }
        if (this._ifType == 8) {
            return !SnmpOID.startsWith(req, vb.getOid().getValue()) || index[0] > IfIndexUtil.getLastValidIfIndexFor(sw.getActualType(30));
        }
        return super.isEnd(peer, req, vb, index, reqId);
    }

    @Override
    public void mapSelectDevice(SnmpKTable table) {
        this.mapSelectDevice(table, true);
    }

    @Override
    protected int getSelectedRowLinkIfIndex(Object[] rowData) {
        SnmpPeer peer = (SnmpPeer)rowData[0];
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        if (sw != null && sw.isQuail()) {
            int[] oid = ((SnmpOID)rowData[1]).getValue();
            return oid[oid.length - 1];
        }
        return super.getSelectedRowLinkIfIndex(rowData);
    }
}

