/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.InterfaceIndex;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SmFcipIfTableModel
extends SmTableModel {
    HashMap _peer2RowData = new HashMap();
    HashMap _peer2FCIPIndex = new HashMap();
    static final int FCIPENTITY_IF_DATA = 1;
    static final int IP_IF_DATA = 2;
    static final int ETH_IF_DATA = 3;
    static final int ETH_STATUS_DATA = 4;
    static final int ETH_IPADR_DATA = 5;
    static final int CDP_IPADR_DATA = 6;
    static final int CDP_IF_DATA = 7;
    static final int CDP_DEVID_DATA = 8;
    static final int[] _cfmFcipLinkIfIndexOid = MibNode.get("cfmFcipLinkIfIndex").getOid();
    static final int[] _cfmFcipEntityAddressOid = MibNode.get("cfmFcipEntityAddress").getOid();
    static final int[] _fcIfAdminModeOid = MibNode.get("fcIfAdminMode").getOid();
    static final int[] _ciiIPIfAddressPrefixLengthOid = MibNode.get("ciiIPIfAddressPrefixLength").getOid();
    static final int[] _ifOperStatusOid = MibNode.get("ifOperStatus").getOid();
    static final int[] _cdpCacheAddressOid = MibNode.get("cdpCacheAddress").getOid();
    static final int[] _cdpCacheDevicePortOid = MibNode.get("cdpCacheDevicePort").getOid();
    static final int[] _cdpCacheDeviceIdOid = MibNode.get("cdpCacheDeviceId").getOid();
    static final int GETVAR = 0;
    static final int GETBULKVAR = 1;
    static final int GETNEXTVAR = 2;
    int _ifType;

    public SmFcipIfTableModel(int ifType) {
        this._ifType = ifType;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        super.build(mibVars, prefixes, offset);
        boolean[] isEditable = this.getEditable();
        isEditable[5] = false;
        this.setEditable(isEditable);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peer2RowData.clear();
        switch (this._ifType) {
            case 10: {
                super.getTableVars(nodes);
                this.getVars(new int[][]{_cfmFcipEntityAddressOid}, new int[]{5}, 0);
                break;
            }
            case 9: {
                if (this._peer2FCIPIndex.size() != 0) break;
                this.getiScsiIfs(nodes);
            }
        }
        this.getCommonVars();
        return this._responseData;
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        this.setViewFilter(invoker);
        this._peer2FCIPIndex.clear();
        boolean bIscsiIf = false;
        this._responseData = new Array();
        for (int i = 0; i < invoker.length; ++i) {
            SnmpPeer peer = invoker[i].getSnmpPeer();
            for (int j = 0; j < invoker[i].getIndicesCount(); ++j) {
                int index = invoker[i].getIndex(j, 0);
                if (IfIndexUtil.getType(index) == 4) {
                    Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                    Fabric fb = sw.getFabric();
                    Isl isl = fb.findIslBySwitchIfIndex(sw, index);
                    if (isl == null || !isl.isFcipPortChannel()) continue;
                    List<int[]> childIfIndices = isl.getChildren();
                    for (int[] indexPair : childIfIndices) {
                        this.addPeerFcIpIndex(peer, indexPair[0]);
                    }
                    continue;
                }
                if (IfIndexUtil.getType(index) == 10) {
                    this.addPeerFcIpIndex(peer, index);
                    continue;
                }
                if (IfIndexUtil.getType(index) != 11) continue;
                bIscsiIf = true;
                this.addiScsiElement(null, peer, new SnmpOID(new int[]{index}));
            }
        }
        if (this._peer2FCIPIndex.size() != 0) {
            return this.getFilteredFcipTableVars();
        }
        if (bIscsiIf) {
            this.getFilterediScsiTableVars();
        }
        return this._responseData;
    }

    void addPeerFcIpIndex(SnmpPeer peer, int index) {
        Array<Integer> fcipIndices = (Array<Integer>)this._peer2FCIPIndex.get(peer);
        if (fcipIndices == null) {
            fcipIndices = new Array<Integer>();
            this._peer2FCIPIndex.put(peer, fcipIndices);
        }
        fcipIndices.addElement(new Integer(index));
    }

    Array getFilteredFcipTableVars() throws SnmpException {
        Set peerSets = this._peer2FCIPIndex.keySet();
        return this.getTableVars(peerSets.toArray(new SnmpPeer[0]));
    }

    Array getFilterediScsiTableVars() throws SnmpException {
        this.getCommonVars();
        return this._responseData;
    }

    void getCommonVars() throws SnmpException {
        this.getVars(new int[][]{_ciiIPIfAddressPrefixLengthOid}, new int[]{3}, 1);
        this.getVars(new int[][]{_ifOperStatusOid, _cdpCacheAddressOid, _cdpCacheDevicePortOid, _cdpCacheDeviceIdOid}, new int[]{4, 6, 7, 8}, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getVars(int[][] oids, int[] dataCols, int getType) throws SnmpException {
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : this._peer2RowData.keySet()) {
                if (this._timedoutPeers.find(peer) != -1) continue;
                VarBindList vbl = new VarBindList();
                if (getType == 1) {
                    for (int j = 0; j < oids.length; ++j) {
                        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(oids[j]));
                        vbl.add(vb);
                    }
                } else {
                    Array rowDatas = (Array)this._peer2RowData.get(peer);
                    for (int i = 0; i < rowDatas.size(); ++i) {
                        Object[] row = (Object[])rowDatas.elementAt(i);
                        for (int j = 0; j < oids.length; ++j) {
                            SnmpVarBind vb = this.getVb(row, oids[j], dataCols[j]);
                            if (vb == null) continue;
                            vbl.add(vb);
                        }
                    }
                }
                if (vbl.size() == 0) continue;
                SnmpFetch f = new SnmpFetch();
                switch (getType) {
                    case 0: {
                        f.get(peer, vbl, this);
                        break;
                    }
                    case 1: {
                        f.getBulk(peer, vbl, (SnmpCallbackIf)this);
                        break;
                    }
                    case 2: {
                        f.getNext(peer, vbl, this);
                    }
                }
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    SnmpVarBind getVb(Object[] row, int[] oid, int dataCol) {
        int[] index = this.getVarIndex(row, dataCol);
        if (index != null) {
            return new SnmpVarBind(new SnmpOID(oid, index));
        }
        return null;
    }

    int[] getVarIndex(Object[] row, int dataCol) {
        try {
            switch (dataCol) {
                case 5: {
                    int[] index = ((SnmpOID)row[1]).getValue();
                    return new int[]{index[0]};
                }
                case 4: {
                    int ifIndex = ((InterfaceIndex)row[3]).getValue();
                    return new int[]{ifIndex - 1};
                }
                case 6: 
                case 7: 
                case 8: {
                    int ifIndex = ((InterfaceIndex)row[3]).getValue();
                    return new int[]{ifIndex};
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getiScsiIfs(SnmpPeer[] nodes) throws SnmpException {
        if (nodes == null || nodes.length == 0) {
            return this._responseData;
        }
        int savStartIndex = this._index;
        int savStopIndex = this._stopIndex;
        this._index = 0xAFFFFFF;
        this._stopIndex = 0xC000000;
        this._state = 2;
        this._firstOid = _fcIfAdminModeOid;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (int i = 0; i < nodes.length; ++i) {
                SnmpPeer peer = nodes[i];
                if (this._timedoutPeers.find(peer) != -1) continue;
                VarBindList vbl = new VarBindList();
                SnmpVarBind vb = new SnmpVarBind(new SnmpOID(_fcIfAdminModeOid, this._index));
                vbl.add(vb);
                SnmpPDU pdu = new SnmpPDU(-95, vbl);
                peer.send(pdu, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
        this._index = savStartIndex;
        this._stopIndex = savStopIndex;
        return this._responseData;
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        this.updateGetProgress();
        SnmpOID firstOid = vbl.getVb(0).getOid();
        if (firstOid.startsWith(_cfmFcipLinkIfIndexOid)) {
            return this.addFcipElement(vbl, node, index);
        }
        return this.addiScsiElement(vbl, node, index);
    }

    public synchronized Object[] addFcipElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        if (this._peer2FCIPIndex.size() != 0 && !this.bAddRow(vbl, node, index)) {
            return null;
        }
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return row;
        }
        row[3] = "n/a";
        this.recordRow(node, row);
        return row;
    }

    public synchronized Object[] addiScsiElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = new Object[this._vars.length + this._offset + 1];
        this._responseData.addElement(row);
        row[0] = node;
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        if (index != null) {
            row[1] = index;
        }
        int ifIndex = index.getValue()[0];
        try {
            row[2] = new InterfaceIndex(new SnmpInt(ifIndex), (IfIndexIf)sw);
            String prefix = "gigE";
            int slotNum = sw.ifIndex2Card(ifIndex);
            int[] cardTypes = sw.getCardTypeInSlots();
            if (cardTypes[slotNum] == 68) {
                prefix = "IPStorage";
            }
            String gigEName = prefix + (sw.ifIndex2Card(ifIndex) + 1) + '/' + (sw.ifIndex2Port(ifIndex) + 1);
            row[3] = new InterfaceIndex(new SnmpInt(sw.nameToIfIndex(gigEName)), (IfIndexIf)sw);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.recordRow(node, row);
        return row;
    }

    void recordRow(SnmpPeer node, Object[] row) {
        row[4] = "n/a";
        row[5] = "n/a";
        row[6] = "n/a";
        row[7] = "n/a";
        row[8] = "n/a";
        Array<Object[]> rowData = (Array<Object[]>)this._peer2RowData.get(node);
        if (rowData == null) {
            rowData = new Array<Object[]>();
            this._peer2RowData.put(node, rowData);
        }
        rowData.addElement(row);
    }

    boolean bAddRow(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Array fcipIndices = (Array)this._peer2FCIPIndex.get(node);
        if (fcipIndices == null) {
            return false;
        }
        int ifIndex = vbl.intValue(0);
        for (int i = 0; i < fcipIndices.size(); ++i) {
            int fcipIndex = (Integer)fcipIndices.elementAt(i);
            if (ifIndex != fcipIndex) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            if (((SnmpOID)firstOid).startsWith(_cfmFcipEntityAddressOid)) {
                this.processGetSameTableData(node, pdu.getVariables(), new int[]{5}, 2);
            } else if (((SnmpOID)firstOid).startsWith(_ciiIPIfAddressPrefixLengthOid)) {
                this.processEtherIfTableData(node, pdu.getVariables());
            } else if (((SnmpOID)firstOid).startsWith(_ifOperStatusOid)) {
                this.processExtraTableData(node, pdu.getVariables(), new int[]{4, 6, 7, 8}, 3, new int[]{0, 1, 1, 1});
            } else {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    void processGetSameTableData(SnmpPeer node, VarBindList vbl, int[] dataCols, int indexCol) {
        Array rowDatas = (Array)this._peer2RowData.get(node);
        int step = dataCols.length;
        int i = 0;
        int datarowIndex = i / step;
        while (i < vbl.size()) {
            Object[] row = (Object[])rowDatas.elementAt(datarowIndex);
            while (row[indexCol].toString().equals("n/a")) {
                row = (Object[])rowDatas.elementAt(++datarowIndex);
            }
            for (int j = 0; j < step; ++j) {
                row[dataCols[j]] = this.toCell(this._mibNodes[dataCols[j]], vbl.getVb(i + j).getVar(), this._vars[dataCols[j] - this._offset], 0);
            }
            i += step;
            ++datarowIndex;
        }
    }

    void processExtraTableData(SnmpPeer node, VarBindList vbl, int[] dataCols, int indexCol, int[] indexPosInVarBindFromEnd) {
        Array rowDatas = (Array)this._peer2RowData.get(node);
        int step = dataCols.length;
        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
        int i = 0;
        int datarowIndex = i / step;
        while (i < vbl.size()) {
            Object[] row = (Object[])rowDatas.elementAt(datarowIndex);
            String strIfIndex = row[indexCol].toString();
            while (strIfIndex.equals("n/a")) {
                row = (Object[])rowDatas.elementAt(++datarowIndex);
                strIfIndex = row[indexCol].toString();
            }
            int ifIndex = sw.nameToIfIndex(strIfIndex);
            for (int j = 0; j < step; ++j) {
                int[] oid = vbl.getVb(i + j).getOid().getValue();
                int varIfIndex = oid[oid.length - 1 - indexPosInVarBindFromEnd[j]];
                if (varIfIndex != ifIndex) continue;
                row[dataCols[j]] = this.toCell(this._mibNodes[dataCols[j]], vbl.getVb(i + j).getVar(), this._vars[dataCols[j] - this._offset], 0);
            }
            i += step;
            ++datarowIndex;
        }
    }

    void processEtherIfTableData(SnmpPeer node, VarBindList vbl) {
        Array rowDatas = (Array)this._peer2RowData.get(node);
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.getVb(i).getOid().getValue();
            int ifIndex = oid[oid.length - 7];
            String ipAdrIndex = SnmpOID.toString(oid, oid.length - 4, oid.length);
            for (int j = 0; j < rowDatas.size(); ++j) {
                Object[] row = (Object[])rowDatas.elementAt(j);
                int curRowIfIndex = ((InterfaceIndex)row[2]).getValue();
                if (IfIndexUtil.getType(curRowIfIndex) == 10) {
                    try {
                        String ipAdr = ((SnmpString)row[5]).toString();
                        if (!ipAdrIndex.equals(ipAdr)) continue;
                        Switch sw = ClientController.findFabricSwitchByIpAddress(node.getAddress());
                        row[3] = new InterfaceIndex(new SnmpInt(oid[oid.length - 7]), (IfIndexIf)sw);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                int curEthIfIndex = ((InterfaceIndex)row[3]).getValue();
                if (ifIndex != curEthIfIndex) continue;
                byte[] addr = new byte[4];
                for (int k = 0; k < 4; ++k) {
                    addr[k] = (byte)oid[oid.length - 4 + k];
                }
                row[5] = this.toCell(this._mibNodes[5], new SnmpString(addr), this._vars[5 - this._offset], 0);
            }
        }
    }
}

