/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.concurrent.PooledThreadExecutor;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpCommunity;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmEnclosureTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.map.actions.ShowPathAction;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class SmHostEnclosureTableModel
extends SmEnclosureTableModel
implements ActionListener {
    static final int[] _fcFeElementNameExpOid = new int[]{1, 3, 6, 1, 3, 42, 2, 1, 1, 2};
    static final int[] _fcFeElementNameOid = new int[]{1, 3, 6, 1, 2, 1, 75, 1, 1, 2};
    static final int[] _fcQlogicWwwn = new int[]{1, 3, 6, 1, 3, 94, 1, 6, 1, 1, 16};
    static final String RESTRICTED_TOPOLOGY_BTN_TEXT = "Show Path";
    private static final String[][] NEW_BUTTON = new String[][]{{null, "Lookup IP Address", "DNS"}, {null, "Find OS...", "findOS"}, {null, "Show Path", "FROM_HOST_ENCLOSURE_TABLE"}};
    private final String OS_STR = "Running:";
    private boolean stopQuery = false;
    StringBuilder os_cmd = new StringBuilder("nmap -O ");
    JButton _enclosureDSNLookupBtn;
    JButton _findOSBtn;
    JButton _restrictedTopologyBtn;
    public static Logger _Logger = Logger.getLogger(SmHostEnclosureTableModel.class);

    public SmHostEnclosureTableModel(MgmtDomainIf mgmtDomain) {
        super(mgmtDomain);
        this.init();
    }

    public SmHostEnclosureTableModel(MgmtDomainIf mgmtDomain, ArrayList enclosures) {
        super(mgmtDomain, enclosures);
        this.init();
    }

    private void init() {
        DataView dataView = BrowserFrame.getDataView();
        JButton[] buttons = null;
        buttons = dataView.insertButtons(0, NEW_BUTTON, new ActionListener[]{this, this, this});
        this._enclosureDSNLookupBtn = buttons[0];
        this._findOSBtn = buttons[1];
        this._restrictedTopologyBtn = buttons[2];
        this._restrictedTopologyBtn.setActionCommand(NEW_BUTTON[2][2]);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.stopQuery = true;
    }

    @Override
    public ArrayList getEnclosures(ArrayList enclosures) {
        return SmHostEnclosureTableModel.getEnclosures(this._mgmtDomain, enclosures);
    }

    public static ArrayList getEnclosures(MgmtDomainIf mgmtDomain, ArrayList enclosures) {
        if (enclosures == null) {
            enclosures = new HashedArrayList<Enclosure>();
        }
        EndPort[] endPorts = mgmtDomain.getEndPorts();
        Enclosure encl = null;
        if (endPorts != null && endPorts.length > 0) {
            for (int i = 0; i < endPorts.length; ++i) {
                if (!endPorts[i].isInitiator() || (encl = endPorts[i].getEnclosure()) == null || ((ArrayList)enclosures).contains(encl) || encl.getMemberCount() <= 0) continue;
                ((ArrayList)enclosures).add(encl);
            }
        }
        return enclosures;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            if (NEW_BUTTON[0][1].startsWith(e.getActionCommand()) || e.getActionCommand().equals(NEW_BUTTON[0][2])) {
                this.dnsLookupSelectedEnclosures();
            } else if (NEW_BUTTON[1][1].startsWith(e.getActionCommand()) || e.getActionCommand().equals(NEW_BUTTON[1][2])) {
                this.findOsSelectedEnclosures();
            } else if (NEW_BUTTON[2][1].startsWith(e.getActionCommand()) || e.getActionCommand().equals(NEW_BUTTON[2][2])) {
                ShowPathAction.getInstance().actionPerformed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dnsLookupSelectedEnclosures() {
        final DataView dataView = BrowserFrame.getDataView();
        boolean startedDnsLookup = false;
        try {
            dataView.setSortable(false);
            final int[] sels = dataView._table.getSelectedRows();
            Array data = this.getData();
            if (data == null || data.isEmpty()) {
                return;
            }
            if (sels.length == 0) {
                Util.errorMessage((Component)dataView, "Please select the enclosure names for IP lookup.");
                return;
            }
            int timeInSeconds = (int)new Double((double)sels.length * 0.16).longValue();
            if (timeInSeconds >= 30) {
                int timeInMinutes = 0;
                if (timeInSeconds >= 60) {
                    timeInMinutes = timeInSeconds / 60;
                }
                StringBuilder msg = new StringBuilder("The IP lookup could approximately ");
                if (timeInMinutes > 0) {
                    msg.append(timeInMinutes).append(" minute(s),");
                } else {
                    msg.append(timeInSeconds).append(" seconds,");
                }
                msg.append("\nDo you want to continue?");
                int selection = JOptionPane.showConfirmDialog(dataView, msg.toString(), "IP Lookup", 0);
                if (selection == 1) {
                    return;
                }
            }
            Thread taskThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        BrowserFrame.getInstance().setStatus("IP Lookup in progress...");
                        dataView.setCursor(Cursor.getPredefinedCursor(3));
                        int successCount = 0;
                        int failureCount = 0;
                        for (int i = 0; i < sels.length; ++i) {
                            int row = sels[i];
                            Object[] rowData = (Object[])SmHostEnclosureTableModel.this.getData().elementAt(row);
                            String name = (String)rowData[0];
                            if (name == null || name.equals("")) continue;
                            if (name == null || name.trim().equals("") || name.contains(":")) {
                                ++failureCount;
                                continue;
                            }
                            InetAddress ipAddr = null;
                            try {
                                ipAddr = InetAddress.getByName(name);
                                SmHostEnclosureTableModel.this.setValueAt(ipAddr.getHostAddress(), row, 1);
                                ++successCount;
                                continue;
                            }
                            catch (UnknownHostException uhe) {
                                ++failureCount;
                            }
                        }
                        DataView currentDV = BrowserFrame.getDataView();
                        if (currentDV.getDataViewModelIf() == SmHostEnclosureTableModel.this) {
                            BrowserFrame.getInstance().setStatus("");
                            dataView.setCursor(Cursor.getPredefinedCursor(0));
                            JOptionPane.showMessageDialog(dataView, "DNS lookup complete:\n" + successCount + " succeeded, " + failureCount + " failed.", "DNS Lookup", 1);
                        }
                    }
                    catch (Exception e) {
                        DataView currentDV = BrowserFrame.getDataView();
                        if (currentDV.getDataViewModelIf() == SmHostEnclosureTableModel.this) {
                            BrowserFrame.getInstance().setStatus("");
                            dataView.setCursor(Cursor.getPredefinedCursor(0));
                            Util.errorMessage((Component)dataView, "Unable to lookup IP, received error:" + Util.getErrorMessage(e));
                        }
                    }
                    finally {
                        DataView currentDV = BrowserFrame.getDataView();
                        if (currentDV.getDataViewModelIf() == SmHostEnclosureTableModel.this) {
                            dataView.setSortable(true);
                        }
                    }
                }
            });
            taskThread.start();
            startedDnsLookup = true;
        }
        finally {
            DataView currentDV;
            if (!startedDnsLookup && (currentDV = BrowserFrame.getDataView()).getDataViewModelIf() == this) {
                dataView.setSortable(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findOsSelectedEnclosures() {
        DataView dataView = BrowserFrame.getDataView();
        boolean startedOSLookup = false;
        try {
            dataView.setSortable(false);
            int[] sels = dataView._table.getSelectedRows();
            Array data = this.getData();
            if (data == null || data.isEmpty()) {
                return;
            }
            if (sels.length == 0) {
                Util.errorMessage((Component)dataView, "Please select the enclosure names upon which to find OS.");
                return;
            }
            FindOSCommunityDialog commDialog = new FindOSCommunityDialog(BrowserFrame.getInstance());
            if (!commDialog.wasCanceled()) {
                boolean performDNS = commDialog.getPerformDNS();
                int timeInSeconds = (int)new Double((double)sels.length * 0.2).longValue();
                if (performDNS) {
                    timeInSeconds += (int)new Double((double)sels.length * 0.16).longValue();
                }
                if (timeInSeconds >= 30) {
                    int timeInMinutes = 0;
                    if (timeInSeconds >= 60) {
                        timeInMinutes = timeInSeconds / 60;
                    }
                    StringBuilder msg = performDNS ? new StringBuilder("The IP and OS lookup could take approximately ") : new StringBuilder("The OS lookup could take approximately ");
                    if (timeInMinutes > 0) {
                        msg.append(timeInMinutes).append(" minute(s),");
                    } else {
                        msg.append(timeInSeconds).append(" seconds,");
                    }
                    msg.append("\nDo you want to continue?");
                    int selection = JOptionPane.showConfirmDialog(dataView, msg.toString(), "IP Lookup", 0);
                    if (selection == 1) {
                        return;
                    }
                }
                Thread taskThread = new Thread(new FindOSTaskThread(dataView, sels, commDialog.getCommunityString(), commDialog.getPerformDNS(), commDialog.isQueryTypeSnmp()));
                taskThread.start();
                startedOSLookup = true;
            }
        }
        finally {
            DataView currentDV;
            if (!startedOSLookup && (currentDV = BrowserFrame.getDataView()).getDataViewModelIf() == this) {
                dataView.setSortable(true);
            }
        }
    }

    class FindOSTaskThread
    implements Runnable,
    SnmpCallbackIf {
        DataView dataView;
        int[] sels;
        private int successCount = 0;
        private int failureCount = 0;
        String comm;
        boolean performDNSLookup = true;
        Map<String, Integer> ipAddressToRowMap = new HashMap<String, Integer>();
        boolean queryTypeSnmp = true;
        PooledThreadExecutor threadPool = null;

        public FindOSTaskThread(DataView dv, int[] selectedRows, String comm, boolean performDNSLookup, boolean queryTypeSnmp) {
            this.dataView = dv;
            this.sels = selectedRows;
            this.comm = comm;
            this.performDNSLookup = performDNSLookup;
            this.queryTypeSnmp = queryTypeSnmp;
        }

        public synchronized void incrementFailures() {
            ++this.failureCount;
        }

        public synchronized void incrementSuccess() {
            ++this.successCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DataView currentDV;
                BrowserFrame.getInstance().setStatus("Find OS in progress...");
                this.dataView.setCursor(Cursor.getPredefinedCursor(3));
                SnmpSession session = ClientController.getSnmpSession();
                if (this.queryTypeSnmp && (this.comm == null || this.comm.trim().length() == 0)) {
                    throw new Exception("Please supply community string.");
                }
                this.threadPool = new PooledThreadExecutor("OSLookup", 0, 20, 10000L);
                for (int i = 0; i < this.sels.length; ++i) {
                    int row = this.sels[i];
                    QueryRunnable queryRunnable = new QueryRunnable(row, this.performDNSLookup, session);
                    this.threadPool.execute(queryRunnable);
                }
                int total = this.sels.length;
                while (total - this.failureCount - this.successCount > 0) {
                    Thread.sleep(300L);
                    if (SmHostEnclosureTableModel.this.stopQuery) {
                        return;
                    }
                    BrowserFrame.getInstance().setStatus("Find OS in progress..., processed/total = " + (this.failureCount + this.successCount) + "/" + total);
                }
                if (SmHostEnclosureTableModel.this.stopQuery) {
                    return;
                }
                BrowserFrame.getInstance().setStatus("Find OS in progress..., processed/total = " + (this.failureCount + this.successCount) + "/" + total + "   poolsize - " + this.threadPool.getPoolSize());
                if (this.threadPool.getPoolSize() == 0 && total - this.failureCount - this.successCount > 0) {
                    this.failureCount += total - this.failureCount - this.successCount;
                }
                if (!SmHostEnclosureTableModel.this.stopQuery && (currentDV = BrowserFrame.getDataView()).getDataViewModelIf() == SmHostEnclosureTableModel.this) {
                    BrowserFrame.getInstance().setStatus("");
                    this.dataView.setCursor(Cursor.getPredefinedCursor(0));
                    JOptionPane.showMessageDialog(this.dataView, "Find OS complete:\n" + this.successCount + " succeeded, " + this.failureCount + " failed. ", "Find OS", 1);
                }
            }
            catch (Exception e) {
                DataView currentDV = BrowserFrame.getDataView();
                if (currentDV.getDataViewModelIf() == SmHostEnclosureTableModel.this) {
                    BrowserFrame.getInstance().setStatus("");
                    this.dataView.setCursor(Cursor.getPredefinedCursor(0));
                    Util.errorMessage((Component)this.dataView, "Unable to Find OS, received error:" + Util.getErrorMessage(e));
                }
            }
            finally {
                DataView currentDV = BrowserFrame.getDataView();
                if (currentDV.getDataViewModelIf() == SmHostEnclosureTableModel.this) {
                    this.dataView.setSortable(true);
                }
                if (this.threadPool != null) {
                    this.threadPool.shutdownNow();
                    this.threadPool = null;
                }
            }
        }

        private int searchSnmp(String ipAddressStr, SnmpSession session, String comm) throws Exception {
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("sysDescr").getOid())));
            SnmpPDU pdu = this.createPdu(vbl, InetAddress.getByName(ipAddressStr), comm);
            int requestId = session.send(pdu, this);
            return requestId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean searchNmap(String ipAddressStr) {
            Process cmdProcess = null;
            BufferedReader rdr = null;
            String osValue = null;
            boolean successFailResult = false;
            try {
                int startIndex;
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("starting Nmap for ip - " + ipAddressStr));
                }
                String cmd = SmHostEnclosureTableModel.this.os_cmd + ipAddressStr;
                cmdProcess = Runtime.getRuntime().exec(cmd.toString());
                StringBuffer response = new StringBuffer();
                rdr = new BufferedReader(new InputStreamReader(cmdProcess.getInputStream()));
                String line = null;
                try {
                    while ((line = rdr.readLine()) != null) {
                        response.append(line);
                        response.append("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String respStr = response.toString();
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("NMap: ip - " + ipAddressStr + ", response string: " + respStr));
                }
                if ((startIndex = respStr.indexOf("Running:")) != -1) {
                    int endIndex = respStr.indexOf("\n", startIndex += "Running:".length());
                    if (endIndex == -1) {
                        endIndex = respStr.length();
                    }
                    osValue = respStr.substring(startIndex, endIndex).trim();
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)("NMap: ip - :" + ipAddressStr + ", OsValue: " + osValue));
                    }
                } else if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("NMap: ip - :" + ipAddressStr + ",no Running: found in the response string: "));
                }
                if (osValue != null && osValue.length() > 0) {
                    int row = this.ipAddressToRowMap.get(ipAddressStr);
                    SmHostEnclosureTableModel.this.setValueAt(osValue, row, 5);
                    successFailResult = true;
                } else {
                    successFailResult = false;
                }
                boolean bl = successFailResult;
                return bl;
            }
            catch (Exception e) {
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)("NMap: ip - :" + ipAddressStr + ", exception - " + e));
                }
                boolean bl = successFailResult = false;
                return bl;
            }
            finally {
                if (cmdProcess != null) {
                    try {
                        cmdProcess.getInputStream().close();
                        cmdProcess.getOutputStream().close();
                        cmdProcess.getErrorStream().close();
                    }
                    catch (IOException e) {}
                    rdr = null;
                }
            }
        }

        private SnmpPDU createPdu(VarBindList vbl, InetAddress addr, String readCommunity) {
            SnmpPDU pdu = new SnmpPDU(-95, vbl);
            pdu.setAddress(addr);
            pdu.setPort(161);
            pdu.setVersion(1);
            if (readCommunity == null) {
                pdu.setCommunity(SnmpCommunity.getRead(addr));
            } else {
                pdu.setCommunity(readCommunity);
            }
            pdu.setRetries(0);
            pdu.setTimeout(SnmpPeer._Timeout);
            return pdu;
        }

        @Override
        public void callback(SnmpSession session, int reqid, SnmpPDU resp, boolean timedOut) {
            if (!timedOut && resp.getError() == 0) {
                String desc = resp.getVar(0).toString();
                if (desc != null && desc.trim().length() > 0) {
                    InetAddress ipAddr = resp.getAddress();
                    String ipAddressStr = ipAddr.getHostAddress();
                    int row = this.ipAddressToRowMap.get(ipAddressStr);
                    SmHostEnclosureTableModel.this.setValueAt(desc, row, 5);
                    this.incrementSuccess();
                } else {
                    this.incrementFailures();
                }
            } else {
                this.incrementFailures();
            }
        }

        class QueryRunnable
        implements Runnable {
            int row;
            boolean performDNSLookup;
            SnmpSession session;

            public QueryRunnable(int row, boolean performDNSLookup, SnmpSession session) {
                this.row = row;
                this.performDNSLookup = performDNSLookup;
                this.session = session;
            }

            @Override
            public void run() {
                try {
                    if (SmHostEnclosureTableModel.this.stopQuery) {
                        return;
                    }
                    Object[] rowData = (Object[])SmHostEnclosureTableModel.this.getData().elementAt(this.row);
                    String name = (String)rowData[0];
                    String ipAddressStr = (String)rowData[1];
                    if (!(!this.performDNSLookup || ipAddressStr != null && ipAddressStr.trim().length() != 0 || name == null || name.equals("") || name.contains(":"))) {
                        InetAddress ipAddr = null;
                        try {
                            ipAddr = InetAddress.getByName(name);
                            ipAddressStr = ipAddr.getHostAddress();
                            SmHostEnclosureTableModel.this.setValueAt(ipAddr.getHostAddress(), this.row, 1);
                        }
                        catch (Exception uhe) {
                            // empty catch block
                        }
                    }
                    if (ipAddressStr == null || ipAddressStr.trim().length() == 0) {
                        FindOSTaskThread.this.incrementFailures();
                        if (_Logger.isTraceEnabled()) {
                            _Logger.trace((Object)("IP lookup failed for row - " + this.row + " with name - " + name));
                        }
                    } else {
                        if (SmHostEnclosureTableModel.this.stopQuery) {
                            return;
                        }
                        FindOSTaskThread.this.ipAddressToRowMap.put(ipAddressStr, this.row);
                        String currentValue = (String)SmHostEnclosureTableModel.this.getValueAt(this.row, 5);
                        if (currentValue == null || currentValue.length() == 0) {
                            if (FindOSTaskThread.this.queryTypeSnmp) {
                                FindOSTaskThread.this.searchSnmp(ipAddressStr, this.session, FindOSTaskThread.this.comm);
                            } else {
                                boolean successFailResult = FindOSTaskThread.this.searchNmap(ipAddressStr);
                                if (successFailResult) {
                                    FindOSTaskThread.this.incrementSuccess();
                                } else {
                                    FindOSTaskThread.this.incrementFailures();
                                }
                            }
                        } else {
                            FindOSTaskThread.this.incrementSuccess();
                        }
                    }
                }
                catch (Exception e) {
                    FindOSTaskThread.this.incrementFailures();
                }
            }
        }
    }

    class FindOSCommunityDialog
    extends JDialog
    implements ActionListener {
        private String _community;
        private boolean _wasCanceled;
        private KTextField commTextField;
        private JCheckBox dnsLookup;
        private JRadioButton snmpQuery;
        private JRadioButton nmapQuery;

        public FindOSCommunityDialog(JFrame parent) {
            super(parent, "Find OS - DCNM-SAN", true);
            this._community = null;
            this._wasCanceled = true;
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    FindOSCommunityDialog.this._wasCanceled = true;
                    FindOSCommunityDialog.this.dispose();
                }
            });
            String nMapText = "Nmap";
            String os = System.getProperty("os.name");
            if (!os.startsWith("Windows")) {
                nMapText = nMapText + " - Requires root access.";
            }
            this.commTextField = new KTextField("public");
            this.dnsLookup = new JCheckBox("Perform a DNS lookup for blank IP Addresses using the Enclosure Name");
            this.dnsLookup.setSelected(true);
            this.snmpQuery = new JRadioButton("SNMP host agent");
            this.snmpQuery.setActionCommand("SNMP");
            this.nmapQuery = new JRadioButton(nMapText);
            this.nmapQuery.setActionCommand("NMAP");
            ButtonGroup gp = new ButtonGroup();
            gp.add(this.snmpQuery);
            gp.add(this.nmapQuery);
            this.snmpQuery.setSelected(true);
            this.snmpQuery.addActionListener(this);
            this.nmapQuery.addActionListener(this);
            JPanel fields = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = DialogUtil._Insets;
            gbc.gridwidth = 2;
            gbc.gridy = 1;
            gbc.gridx = 0;
            gbc.anchor = 17;
            fields.add(new JLabel("Query host for operating systems."));
            ++gbc.gridy;
            fields.add((Component)new JLabel("Query Type:", 2), gbc);
            ++gbc.gridy;
            fields.add((Component)this.snmpQuery, gbc);
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            ++gbc.gridy;
            gbc.anchor = 13;
            fields.add((Component)new JLabel("Community:", 4), gbc);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            fields.add((Component)this.commTextField, gbc);
            gbc.anchor = 17;
            gbc.gridx = 0;
            ++gbc.gridy;
            fields.add((Component)this.nmapQuery, gbc);
            ++gbc.gridy;
            fields.add((Component)this.dnsLookup, gbc);
            gbc.gridwidth = 2;
            gbc.gridx = 0;
            gbc.anchor = 17;
            ++gbc.gridy;
            fields.add((Component)new JLabel("Note: FDMI discovered OS values will overwrite user provided values, as FDMI data takes precedence."), gbc);
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
            p.add("Center", fields);
            String[] bLabels = new String[]{"Search", "Cancel"};
            JButton[] buttons = DialogUtil.buildButtons(bLabels, (ActionListener)this);
            this.getRootPane().setDefaultButton(buttons[0]);
            JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
            for (int i = 0; i < buttons.length; ++i) {
                buttonPanel.add(buttons[i]);
            }
            p.add("South", buttonPanel);
            this.setResizable(true);
            this.add(p);
            this.pack();
            this.setLocationRelativeTo(parent);
            this.setVisible(true);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof AbstractButton)) return;
            String cmd = ((AbstractButton)e.getSource()).getActionCommand();
            if (cmd.startsWith("Sea")) {
                block6: {
                    String comm = this.commTextField.getText();
                    if (this.snmpQuery.isSelected()) {
                        if (comm != null && comm.trim().length() > 0) {
                            this._community = comm;
                            this._wasCanceled = false;
                            break block6;
                        } else {
                            Util.errorMessage((Component)this, "Please supply community string.", "Find OS");
                            return;
                        }
                    }
                    this._wasCanceled = false;
                }
                this.dispose();
                return;
            }
            if (cmd.startsWith("C")) {
                this.dispose();
                return;
            }
            if (cmd.startsWith("SNMP")) {
                this.commTextField.setEnabled(true);
                return;
            }
            if (!cmd.startsWith("NMAP")) return;
            this.commTextField.setEnabled(false);
        }

        public boolean wasCanceled() {
            return this._wasCanceled;
        }

        public String getCommunityString() {
            return this._community;
        }

        public boolean getPerformDNS() {
            return this.dnsLookup.isSelected();
        }

        public boolean isQueryTypeSnmp() {
            return this.snmpQuery.isSelected();
        }
    }
}

