/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.SmFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Timer;

public class SmIPCloudGenTableModel
extends SmTableModel
implements ActionListener {
    static final int AUTO_DISCOVER = 1;
    static final int SCOPE = 3;
    static final int COMMAND_STATUS = 4;
    static final int STATUS_POLLING_MIB_SIZE = 1;
    static final int[] _cIpNetworkDiscoveryCmdStatusOid = MibNode.get("cIpNetworkDiscoveryCmdStatus").getOid();
    static final MibEnum[] _cIpNetworkDiscoveryCmdStatusEnums = MibNode.get("cIpNetworkDiscoveryCmdStatus").getEnums();
    static final int[] _cIpNetworkDiscoverySpinLock = MibNode.get("cIpNetworkDiscoverySpinLock").getOid();
    protected Timer _statusTimer = new Timer(5000, this);
    HashMap _peers2RowsGetStatus = new HashMap();
    HashMap _peers2RowInfo = new HashMap();
    HashMap _peers2SpinLock;
    Array _actionChangedCells = new Array();
    Array _allChangedCells = new Array();
    static final int ACTION_RESULT_INPROGRESS = 3;
    VarBindList _spinLockVB = new VarBindList();

    public SmIPCloudGenTableModel() {
        this._spinLockVB.add(new SnmpVarBind(new SnmpOID(_cIpNetworkDiscoverySpinLock, 0)));
        this._peers2SpinLock = new HashMap();
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        ArrayList<SnmpPeer> peers2Query = new ArrayList<SnmpPeer>();
        for (int i = 0; i < invoker.length; ++i) {
            peers2Query.add(invoker[i].getSnmpPeer());
        }
        SnmpPeer[] peers = peers2Query.toArray(new SnmpPeer[0]);
        return this.getTableVars(peers);
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        Integer rowEntry = (Integer)this._peers2RowInfo.get(node);
        if (rowEntry == null) {
            this._peers2RowInfo.put(node, new Integer(this._responseData.size() - 1));
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        super.snmpAggregrate(pdu, err);
        if (err.length() != 0) {
            return;
        }
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        SnmpOID rowIndex = (SnmpOID)this._peers2RowsGetStatus.get(node);
        VarBindList vbl = pdu.getVariables();
        if (rowIndex == null && vbl.size() > 0) {
            SnmpVarBind vb = vbl.getVb(0);
            int[] oid = vb.getOid().getValue();
            if (this._actionChangedCells.size() > 0) {
                SnmpOID index = new SnmpOID(oid, _cIpNetworkDiscoveryCmdStatusOid.length, oid.length - _cIpNetworkDiscoveryCmdStatusOid.length);
                HashMap hashMap = this._peers2RowsGetStatus;
                synchronized (hashMap) {
                    this._peers2RowsGetStatus.put(node, index);
                }
            }
        }
    }

    @Override
    protected void performPostSorting() {
        this.updatePeers2RowInfo();
    }

    void updatePeers2RowInfo() {
        this._peers2RowInfo.clear();
        Array data = this.getData();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            SnmpPeer node = (SnmpPeer)row[0];
            Integer rowEntry = (Integer)this._peers2RowInfo.get(node);
            if (rowEntry != null) continue;
            this._peers2RowInfo.put(node, new Integer(i));
        }
    }

    @Override
    public boolean applyChanges() throws Exception {
        this._peers2SpinLock.clear();
        if (this._peers2RowsGetStatus.size() != 0) {
            return false;
        }
        Array cells = super.getChanged();
        if (cells == null) {
            return false;
        }
        this._peers2RowsGetStatus.clear();
        this._actionChangedCells.clear();
        this._allChangedCells.clear();
        int preRow = -1;
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._col != 1 && cell._row != preRow) {
                this._actionChangedCells.addElement(new Cell(cell._row, cell._col));
            }
            this._allChangedCells.addElement(new Cell(cell._row, cell._col));
            preRow = cell._row;
        }
        this.fireTableDataChanged();
        this.getSpinLock();
        super.applyChanges(this);
        if (this._actionChangedCells.size() != 0) {
            this._statusTimer.start();
        }
        Array data = this.getData();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            row[3] = Boolean.FALSE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getSpinLock() throws Exception {
        Array cells = this.getChanged();
        if (cells == null) {
            return;
        }
        HashMap<SnmpPeer, SnmpPeer> peersChanged = new HashMap<SnmpPeer, SnmpPeer>();
        for (int i = 0; i < cells.size(); ++i) {
            SnmpPeer node;
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._col != 3 || peersChanged.get(node = this.getRowPeer(cell._row)) != null) continue;
            peersChanged.put(node, node);
        }
        this._state = 1;
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peersChanged.keySet()) {
                SnmpFetch f = new SnmpFetch();
                try {
                    f.get(peer, this._spinLockVB, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    @Override
    protected HashMap buildSendPdus() throws Exception {
        HashMap pdus = super.buildSendPdus();
        for (SnmpPeer peer : pdus.keySet()) {
            SnmpPDU pdu = (SnmpPDU)pdus.get(peer);
            if (this._peers2SpinLock.get(peer) == null) continue;
            pdu.addVar(new SnmpOID(_cIpNetworkDiscoverySpinLock, 0), (SnmpInt)this._peers2SpinLock.get(peer));
        }
        return pdus;
    }

    @Override
    protected Array getChangeCells() {
        return this._allChangedCells;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._actionChangedCells.size() != 0) {
                this.pollSwitches();
                return;
            }
            this._statusTimer.stop();
            this.resetChanges(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSwitches() {
        this._state = 1;
        boolean requestSent = false;
        HashMap<SnmpPeer, VarBindList> peers2Vbl = new HashMap<SnmpPeer, VarBindList>();
        Object object = this._peers2RowsGetStatus;
        synchronized (object) {
            for (SnmpPeer peer : this._peers2RowsGetStatus.keySet()) {
                SnmpOID index = (SnmpOID)this._peers2RowsGetStatus.get(peer);
                if (index == null) continue;
                VarBindList vbl = new VarBindList();
                vbl.add(new SnmpVarBind(new SnmpOID(_cIpNetworkDiscoveryCmdStatusOid, index.getValue())));
                peers2Vbl.put(peer, vbl);
            }
        }
        this._numOutstanding.set(0);
        object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer peer : peers2Vbl.keySet()) {
                VarBindList vbl = (VarBindList)peers2Vbl.get(peer);
                SnmpPDU pdu = new SnmpPDU(-96, vbl);
                pdu.setRetries(0);
                try {
                    peer.send(pdu, this);
                    this._numOutstanding.increment();
                }
                catch (SnmpException ex) {}
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object vbl;
        if (this._state == 5) {
            return;
        }
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(peer, pdu, timedOut) && pdu.getVariables().size() > 0) {
            vbl = pdu.getVariables();
            SnmpVarBind vb = ((VarBindList)vbl).getVb(0);
            int[] oid = vb.getOid().getValue();
            SnmpOID firstOid = pdu.getVariables().getVb(0).getOid();
            if (firstOid.startsWith(this._firstOid)) {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
            if (firstOid.startsWith(_cIpNetworkDiscoverySpinLock)) {
                SnmpInt spinLock = (SnmpInt)pdu.getVar(0);
                this._peers2SpinLock.put(peer, spinLock);
            } else {
                for (int i = 0; i < ((VarBindList)vbl).size(); ++i) {
                    SnmpOID rowIndex;
                    vb = ((VarBindList)vbl).getVb(i);
                    int actionResult = ((VarBindList)vbl).intValue(i);
                    oid = vb.getOid().getValue();
                    SnmpOID index = new SnmpOID(oid, _cIpNetworkDiscoveryCmdStatusOid.length, oid.length - _cIpNetworkDiscoveryCmdStatusOid.length);
                    Integer rowEntry = (Integer)this._peers2RowInfo.get(peer);
                    if (rowEntry != null) {
                        int rowN = rowEntry;
                        Object[] row = (Object[])this.getData().elementAt(rowN);
                        row[4] = MibEnum.getLabel(_cIpNetworkDiscoveryCmdStatusEnums, ((VarBindList)vbl).intValue(i));
                        BrowserFrame.getInstance();
                        BrowserFrame.getDataView()._table.calcPreferredSize();
                    }
                    if (actionResult == 3 || (rowIndex = (SnmpOID)this._peers2RowsGetStatus.get(peer)) == null) continue;
                    this._peers2RowsGetStatus.remove(peer);
                }
            }
        } else {
            vbl = this._peers2RowsGetStatus;
            synchronized (vbl) {
                this._peers2RowsGetStatus.remove(peer);
            }
        }
        this.fireTableDataChanged();
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                vbl = this._numOutstanding;
                synchronized (vbl) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
    }
}

