/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.dialogs.SmIkeTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SmIkeTunnelTableModel
extends SmIkeTableModel
implements ActionListener {
    JPanel _newToolbar;
    JPanel _actPanel;
    JComboBox _clearIPSECList;
    HashMap _peer2RowIndices;
    HashMap _peer2TunnelVbl;
    private static final int AUTHMETHOD_COL = 4;
    private static final int ACTION_COL = 5;
    private static final int TUNNEL_DETAIL_LEN = 2;
    static final int[] _cifeClearAllTunnelsOid = MibNode.get("cifeClearAllTunnels").getOid();
    static final MibEnum[] _cifeClearAllTunnelsEnum = MibNode.get("cifeClearAllTunnels").getEnums();
    static final int[] _cisgIpsSgTunAuthMethodOid = MibNode.get("cisgIpsSgTunAuthMethod").getOid();
    static final int CLEAR_ALL_IPSEC = 2;
    static final int CLEAR_AL_FCSP = 3;
    static final String DEFAUL_SWLIST = "None";

    public SmIkeTunnelTableModel() {
        DataView dataView = BrowserFrame.getDataView();
        this._actPanel = new JPanel(new FlowLayout(0, 2, 2));
        this._actPanel.add(new JLabel("Clear IPSEC:"));
        this._clearIPSECList = new JComboBox<String>(new String[]{DEFAUL_SWLIST});
        this._clearIPSECList.setSelectedIndex(0);
        this._clearIPSECList.addActionListener(this);
        this._clearIPSECList.setActionCommand("CI");
        this._actPanel.add(this._clearIPSECList);
        JPanel _newToolbar = new JPanel(new FlowLayout(2, 2, 2));
        _newToolbar.add(dataView.getDefaultButtonPanel());
        _newToolbar.add(this._actPanel);
        dataView.replaceButtonPanel(_newToolbar);
        this._peer2RowIndices = new HashMap();
        this._peer2TunnelVbl = new HashMap();
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        this._peer2RowIndices.clear();
        super.getTableVars(nodes);
        this.getTunnelDetailTable();
        this.updateSwitchList();
        return this._responseData;
    }

    @Override
    public int[] getIndex(int row, int col) {
        int[] index = super.getIndex(row);
        if (col >= 4) {
            int[] tunndelDetailIndex = new int[index.length - 1];
            System.arraycopy(index, 1, tunndelDetailIndex, 0, tunndelDetailIndex.length);
            return tunndelDetailIndex;
        }
        return index;
    }

    void updateSwitchList() {
        int nPeers = this._peer2RowIndices.size();
        if (nPeers == 0) {
            return;
        }
        Object[] swList = new Object[nPeers + 2];
        swList[0] = DEFAUL_SWLIST;
        SnmpPeer[] peers = this._peer2RowIndices.keySet().toArray(new SnmpPeer[this._peer2RowIndices.size()]);
        for (int i = 0; i < peers.length; ++i) {
            swList[i + 1] = peers[i];
        }
        swList[swList.length - 1] = "All";
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(swList);
        this._clearIPSECList.setModel(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getTunnelDetailTable() throws SnmpException {
        this._peer2TunnelVbl.clear();
        this._numOutstanding.set(0);
        Object object = this._numOutstanding.getLock();
        synchronized (object) {
            for (SnmpPeer node : this._peer2RowIndices.keySet()) {
                if (this.isPeerTimedOut(node)) continue;
                HashMap info2Row = (HashMap)this._peer2RowIndices.get(node);
                VarBindList vbl = new VarBindList();
                Iterator itj = info2Row.keySet().iterator();
                while (itj.hasNext()) {
                    int[] index = ((SnmpOID)itj.next()).getValue();
                    for (int i = 4; i <= 5; ++i) {
                        vbl.add(new SnmpVarBind(new SnmpOID(this._mibNodes[i].getOid(), index)));
                    }
                }
                if (vbl.size() == 0) continue;
                SnmpFetch f = new SnmpFetch();
                f.get(node, vbl, this);
                this._numOutstanding.increment();
            }
        }
        if (this._numOutstanding.get() > 0) {
            this.wait(this._numOutstanding);
            this.processTunnelDetail();
        }
    }

    void processTunnelDetail() {
        VarBindList vbl = null;
        for (SnmpPeer node : this._peer2TunnelVbl.keySet()) {
            HashMap info2Row = (HashMap)this._peer2RowIndices.get(node);
            if (info2Row == null) continue;
            vbl = (VarBindList)this._peer2TunnelVbl.get(node);
            for (int i = 0; i < vbl.size(); i += 2) {
                int[] oid = vbl.getVb(i).getOid().getValue();
                int[] tunnelDetailIndex = new int[2];
                System.arraycopy(oid, _cisgIpsSgTunAuthMethodOid.length, tunnelDetailIndex, 0, tunnelDetailIndex.length);
                Integer rowIdObj = (Integer)info2Row.get(new SnmpOID(tunnelDetailIndex));
                if (rowIdObj == null) continue;
                int rowN = rowIdObj;
                Object[] row = (Object[])this._responseData.elementAt(rowN);
                for (int j = 4; j <= 5; ++j) {
                    row[j] = super.getCellDisplayString(node, this._mibNodes[j], vbl, vbl.getVb(i + (j - 4)), this._vars[j - this._offset], rowN, j, null, 0);
                }
            }
        }
    }

    @Override
    public synchronized Object[] addElement(VarBindList vbl, SnmpPeer node, SnmpOID index) {
        Object[] row = super.addElement(vbl, node, index);
        if (row == null) {
            return null;
        }
        HashMap<SnmpOID, Integer> info2Row = (HashMap<SnmpOID, Integer>)this._peer2RowIndices.get(node);
        if (info2Row == null) {
            info2Row = new HashMap<SnmpOID, Integer>();
            this._peer2RowIndices.put(node, info2Row);
        }
        int[] tableRowIndex = index.getValue();
        int[] tunnelDetailIndex = new int[2];
        System.arraycopy(tableRowIndex, 1, tunnelDetailIndex, 0, tunnelDetailIndex.length);
        info2Row.put(new SnmpOID(tunnelDetailIndex), new Integer(this._responseData.size() - 1));
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        Object firstOid;
        SnmpPeer node = SnmpPeer.findPeer(pdu.getAddress());
        if (!this.checkSnmpCallbackErr(node, pdu, timedOut) && pdu.getVariables().size() > 0) {
            firstOid = pdu.getVariables().getVb(0).getOid();
            VarBindList vbl = pdu.getVariables();
            if (((SnmpOID)firstOid).startsWith(_cisgIpsSgTunAuthMethodOid)) {
                this._peer2TunnelVbl.put(node, vbl);
            } else {
                super.callback(session, reqid, pdu, timedOut);
                return;
            }
        }
        this._numOutstanding.decrement();
        if (this._numOutstanding.get() <= 0) {
            try {
                firstOid = this._numOutstanding;
                synchronized (firstOid) {
                    this._numOutstanding.notifyAll();
                }
            }
            catch (IllegalMonitorStateException ex) {
                // empty catch block
            }
        }
        this.updateTableDisplay();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (e.getActionCommand().equals("CI")) {
            Object swSel = this._clearIPSECList.getSelectedItem();
            if (swSel.toString().equals(DEFAUL_SWLIST)) {
                return;
            }
            ClearTunnelsAction thread = new ClearTunnelsAction(2);
            thread.start();
            return;
        }
    }

    void setActionSelDefault(int clearCmd) {
        switch (clearCmd) {
            case 2: {
                this._clearIPSECList.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._clearIPSECList != null) {
            this._clearIPSECList.setVisible(false);
        }
    }

    @Override
    public boolean applyChanges() throws Exception {
        boolean bChangesApplied = super.applyChanges();
        BrowserFrame.getDataView().refresh();
        return bChangesApplied;
    }

    class ClearTunnelsAction
    extends Thread {
        int _clearCmd;

        ClearTunnelsAction(int clearCmd) {
            this._clearCmd = clearCmd;
        }

        @Override
        public void run() {
            Object swSel = SmIkeTunnelTableModel.this._clearIPSECList.getSelectedItem();
            SnmpPeer[] peers = null;
            peers = swSel.toString().equals("All") ? SmIkeTunnelTableModel.this._peer2RowIndices.keySet().toArray(new SnmpPeer[SmIkeTunnelTableModel.this._peer2RowIndices.size()]) : new SnmpPeer[]{(SnmpPeer)swSel};
            String warningMsg = "This will clear all the IKE tunnels. IPSEC tunnels established through IKEv2 will be cleared also. Do you want to continue?";
            if (JOptionPane.showConfirmDialog(BrowserFrame.getDataView(), warningMsg, "Select an Option", 0) != 0) {
                return;
            }
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(_cifeClearAllTunnelsOid, 0), new SnmpInt(this._clearCmd)));
            for (int i = 0; i < peers.length; ++i) {
                SnmpPDU pdu = new SnmpPDU(-93, vbl);
                pdu.setIgnoreSetCount(true);
                try {
                    peers[i].set(pdu);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            BrowserFrame.getDataView().refresh();
            SmIkeTunnelTableModel.this.setActionSelDefault(this._clearCmd);
        }
    }
}

