/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.Card;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SmInsertIpFc
extends InsertForm
implements ItemListener {
    static final int VSANID = 0;
    static final int IPADDR = 1;
    static final int CARD = 2;
    int _vsanId;
    int _card;
    SnmpPeer _selPeer;
    JComboBox _moduleList;
    JCheckBox _useCPP;
    JComponent[] _guiLabels;
    JComponent[] _guiValues;
    static final int VSANID_GUI = 0;
    static final int IPADDR_GUI = 1;
    static final int USE_CPP_GUI = 2;
    static final int CARD_GUI = 3;

    public SmInsertIpFc(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
        this._insertRowCallback = null;
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this._selPeer = (SnmpPeer)this._choice.getSelectedItem();
        this.setComponentText(1, "10.1.1.1/24");
        this.loadModuleList();
    }

    @Override
    protected void layoutForm() {
        this._guiLabels = new JComponent[this._labels.length + 1];
        System.arraycopy(this._labels, 0, this._guiLabels, 0, this._labels.length - 1);
        this._guiValues = new JComponent[this._values.length + 1];
        System.arraycopy(this._values, 0, this._guiValues, 0, this._values.length - 1);
        this._useCPP = new JCheckBox("CPP (ASM/SSM Only)", false);
        this._guiValues[2] = this._useCPP;
        this._useCPP.addItemListener(this);
        this._guiLabels[this._guiLabels.length - 1] = this._labels[this._labels.length - 1];
        this._guiValues[this._guiValues.length - 1] = this._values[this._values.length - 1];
        DialogUtil.buildPanel(this._container, this._guiLabels, this._guiValues);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 2) {
            this._moduleList = new JComboBox();
            this._moduleList.setEditable(false);
            return this._moduleList;
        }
        if (index == 0) {
            this._selPeer = this._peers[0];
            return this.loadVsanList();
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            JComboBox combo = (JComboBox)this._values[index];
            this._vsanId = (Integer)combo.getSelectedItem();
            return new SnmpInt(this._vsanId);
        }
        if (index == 1) {
            return null;
        }
        if (index == 2) {
            boolean useCpp = this._useCPP.isSelected();
            if (useCpp) {
                this._card = (Integer)this._moduleList.getSelectedItem();
            } else {
                ClientController.getInstance();
                Switch sw = ClientController.findFabricSwitchByIpAddress(this._selPeer.getAddress());
                if (sw != null) {
                    this._card = sw.getActiveSupSlot();
                }
            }
            return null;
        }
        return super.getComponentValue(index);
    }

    void loadModuleList() {
        Card[] cards;
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(this._selPeer.getAddress());
        ArrayList<Integer> cardlist = new ArrayList<Integer>();
        boolean ilcCard = false;
        if (sw != null && (cards = sw.getCards()) != null) {
            for (int i = 0; i < cards.length; ++i) {
                if (cards[i] == null || cards[i].getType() != 5 && cards[i].getType() != 20 && cards[i].getType() != 39) continue;
                cardlist.add(new Integer(cards[i].getSlotId()));
                ilcCard = true;
            }
            if (cardlist.size() != 0) {
                Integer[] ssmCardIds = cardlist.toArray(new Integer[cardlist.size()]);
                DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>(ssmCardIds);
                this._moduleList.setModel(model);
                this._moduleList.setSelectedIndex(0);
            }
        }
        this._useCPP.setVisible(ilcCard);
        this._guiLabels[3].setVisible(ilcCard);
        this._guiValues[3].setVisible(ilcCard);
        this._guiLabels[3].setEnabled(this._useCPP.isSelected());
        this._guiValues[3].setEnabled(this._useCPP.isSelected());
        this._parent.validate();
        this._parent.invalidate();
        this._parent.pack();
    }

    JComboBox loadVsanList() {
        Switch sw = ClientController.findFabricSwitchByIpAddress(this._selPeer.getAddress());
        short[] vsans = sw.getVsanIds();
        Integer[] oVsans = new Integer[vsans == null ? 0 : vsans.length];
        for (int i = 0; i < oVsans.length; ++i) {
            oVsans[i] = new Integer(vsans[i]);
        }
        DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>(oVsans);
        JComboBox<Integer> comboVsan = (JComboBox<Integer>)this._values[0];
        if (comboVsan == null) {
            comboVsan = new JComboBox<Integer>();
        }
        comboVsan.setModel(model);
        return comboVsan;
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 2) {
            return new JLabel("Module:");
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                this._selPeer = (SnmpPeer)this._choice.getSelectedItem();
                this.loadVsanList();
                this.loadModuleList();
                return;
            }
        }
        super.actionPerformed(e);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        Switch sw = ClientController.findFabricSwitchByIpAddress(this._selPeer.getAddress());
        int processorId = sw.getModuleProcessorId(this._card - 1);
        int[] index = new int[]{processorId, 1, this._vsanId};
        return index;
    }

    @Override
    protected void insert() throws Exception {
        byte[] ipAddr;
        String addr = this.getComponentText(1);
        int prefix = 0;
        int slash = addr.indexOf(47);
        if (slash == -1) {
            ipAddr = SnmpIpAddress.parse(addr);
        } else {
            ipAddr = SnmpIpAddress.parse(addr.substring(0, slash));
            try {
                prefix = Integer.parseInt(addr.substring(slash + 1));
            }
            catch (NumberFormatException ex) {
                throw new SnmpException("bad mask");
            }
        }
        super.insert();
        if (this._insertErrMsg.size() != 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this._insertErrMsg.size(); ++i) {
                sb.append(this._insertErrMsg.elementAt(i));
                sb.append('\n');
            }
            sb.setLength(sb.length() - 1);
            throw new Exception(sb.toString());
        }
        this.insertIpAddress(ipAddr, prefix);
        boolean useCpp = this._useCPP.isSelected();
        int ifIndex = this._useCPP.isSelected() ? IfIndexUtil.getCppIfIndex(this._card, 1, this._vsanId) : IfIndexUtil.getVsanIfIndex(this._vsanId);
        int[] index = new int[]{ifIndex};
        SnmpPDU getpdu = this._table.buildGetPdu(this._selPeer, index);
        SnmpPDU pdu = this._selPeer.send(getpdu);
        this._table.addElement(pdu.getVariables(), this._selPeer, new SnmpOID(index));
    }

    void insertIpAddress(byte[] ipAddr, int prefix) throws Exception {
        int ifIndex = this._useCPP.isSelected() ? IfIndexUtil.getCppIfIndex(this._card, 1, this._vsanId) : IfIndexUtil.getVsanIfIndex(this._vsanId);
        SnmpInt createAndGo = new SnmpInt(4);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        int[] ipIndex = new int[ipAddr.length + 3];
        ipIndex[0] = ifIndex;
        ipIndex[1] = ipAddr.length == 16 ? 2 : 1;
        ipIndex[2] = ipAddr.length;
        int i = 0;
        int j = 3;
        while (i < ipAddr.length) {
            ipIndex[j] = ipAddr[i] & 0xFF;
            ++i;
            ++j;
        }
        int defaultMask = ipAddr.length == 16 ? 64 : 24;
        pdu.addVar(new SnmpOID(MibNode.get("ciiIPIfAddressStatus").getOid(), ipIndex), createAndGo);
        pdu.addVar(new SnmpOID(MibNode.get("ciiIPIfAddressPrefixLength").getOid(), ipIndex), new SnmpUnsignedInt(prefix == 0 ? (long)defaultMask : (long)prefix));
        this._selPeer.set(pdu);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._useCPP) {
            this._guiLabels[3].setEnabled(this._useCPP.isSelected());
            this._guiValues[3].setEnabled(this._useCPP.isSelected());
        }
    }
}

