/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SmInsertIpInterface
extends InsertForm {
    static final int INTERFACE = 0;
    static final int IPADDR = 1;
    byte[] _ipAddr;

    public SmInsertIpInterface(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        ((JTextField)this._values[1]).setText("");
    }

    @Override
    protected int getWidth(String mibVar, MibNode mibNode, String tc) {
        if (mibVar.equals("ciiIPIfAddressPrefixLength")) {
            return 20;
        }
        return super.getWidth(mibVar, mibNode, tc);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            return new JLabel("Interface:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1) {
            String addrString = this.getComponentText(1);
            if (addrString.length() == 0) {
                throw new Exception("Please provide ipaddress.");
            }
            int slash = addrString.indexOf(47);
            this._ipAddr = SnmpIpAddress.parse(slash != -1 ? addrString.substring(0, slash) : addrString);
            if (this._ipAddr.length == 0) {
                throw new SnmpException("bad ipaddress");
            }
            try {
                int prefix = slash == -1 ? (this._ipAddr.length == 16 ? 64 : 24) : Integer.parseInt(addrString.substring(slash + 1));
                return new SnmpGauge(prefix);
            }
            catch (NumberFormatException ex) {
                throw new SnmpException("bad mask");
            }
        }
        return super.getComponentValue(index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = new int[this._ipAddr.length + 3];
        index[0] = ((SnmpInt)values[0]).getValue();
        index[1] = this._ipAddr.length == 16 ? 2 : 1;
        index[2] = this._ipAddr.length;
        int[] ipAddress = SnmpString.valueOf(this._ipAddr, false);
        System.arraycopy(ipAddress, 0, index, 3, ipAddress.length);
        return index;
    }
}

