/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSetEditor;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmPortSetFieldPanel;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SmInsertIpsecIf
extends InsertForm {
    static final int IF = 0;
    static final int CRYPTOMAPNAME = 1;
    static final int[] _cipsStaticCryptomapSetSizeOid = MibNode.get("cipsStaticCryptomapSetSize").getOid();
    private JComboBox _cryptoMapcmbx;
    private SmPortSetFieldPanel _portFieldPanel;

    public SmInsertIpsecIf(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, false);
        int newInsVarLen = this._vars.length - 1;
        String[] newInsertVars = new String[newInsVarLen];
        for (int i = 0; i < newInsVarLen; ++i) {
            newInsertVars[i] = this._vars[i];
        }
        this._vars = newInsertVars;
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 0) {
            return new JLabel("Interface");
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        this._choice.setActionCommand("L");
        this._choice.addActionListener(this);
        this._portFieldPanel.setNode((SnmpPeer)this._choice.getSelectedItem());
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            this._cryptoMapcmbx = new JComboBox();
            this._cryptoMapcmbx.setSelectedItem("");
            this.updateCryptoMapList(this._peers[0]);
            return this._cryptoMapcmbx;
        }
        if (index == 0) {
            PortEditorFilter psFilter = new PortEditorFilter(new int[]{22, 27, 39, 41, 44, 68}, new int[]{2});
            this._portFieldPanel = new SmPortSetFieldPanel(true, 10, psFilter);
            return new FieldPanel((JComponent)this._portFieldPanel, (JComponent)new JLabel("   (e.g. gigE2/1, gigE2/2.1)"), null);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            String ifName = this._portFieldPanel.getText();
            if (ifName.length() == 0) {
                throw new Exception("Interface: invalid entry");
            }
            return new SnmpInt(this.getSelectedIfIndexIf().nameToIfIndex(ifName));
        }
        return new SnmpString((String)((JComboBox)this._values[index]).getSelectedItem());
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = super.getInsertIndex(values);
        int[] newIndex = new int[index.length];
        newIndex[0] = index[1];
        System.arraycopy(index, 2, newIndex, 1, index.length - 2);
        newIndex[newIndex.length - 1] = index[0];
        return newIndex;
    }

    void updateCryptoMapList(SnmpPeer peer) {
        this._cryptoMapcmbx.removeAllItems();
        String[] cryptoMaps = this.getCryptoMaps(peer);
        for (int i = 0; i < cryptoMaps.length; ++i) {
            this._cryptoMapcmbx.addItem(cryptoMaps[i]);
        }
    }

    String[] getCryptoMaps(SnmpPeer peer) {
        ArrayList<String> cryptoMapNames = new ArrayList<String>();
        SnmpFetch f = new SnmpFetch();
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(_cipsStaticCryptomapSetSizeOid)));
        try {
            SnmpPDU respCryptoMap = SnmpFetch.getBulk(peer, vbl);
            VarBindList vblCryptoMap = respCryptoMap.getVariables();
            for (int i = 0; i < vblCryptoMap.size(); ++i) {
                SnmpVarBind vb = vblCryptoMap.getVb(i);
                int[] oid = vb.getOid().getValue();
                cryptoMapNames.add(SnmpString.toString(oid, _cipsStaticCryptomapSetSizeOid.length + 1, oid.length));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return cryptoMapNames.toArray(new String[cryptoMapNames.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        switch (cmd.charAt(0)) {
            case 'L': {
                SnmpPeer peer = (SnmpPeer)this._choice.getSelectedItem();
                this.updateCryptoMapList(peer);
                this._portFieldPanel.setNode(peer);
                this._portFieldPanel.setText("");
                return;
            }
        }
        super.actionPerformed(e);
    }

    @Override
    public void dispose() {
        PortSetEditor.getInstance(BrowserFrame.getInstance()).hideDlg();
    }
}

