/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmPsmTableModel;
import com.cisco.dcbu.sm.client.gui.InsertDialog;
import com.cisco.dcbu.sm.client.gui.InsertForm;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmInsertPsmFabricBind
extends InsertForm
implements ListSelectionListener {
    static final int INDEX = 0;
    static final int WWN = 1;
    static final int DMID = 2;
    private JTextField _wwn;
    private JList _list;
    JLabel _wwnLabel;
    private static final int[] _cpsmFabricBindDomIdOid = MibNode.get("cpsmFabricBindDomId").getOid();

    public SmInsertPsmFabricBind(SnmpPeer[] peers, InsertDialog parent, SmTableModel table) {
        super(peers, parent, table, true);
    }

    @Override
    protected void build() throws Exception {
        super.build();
        if (this._wwnLabel != null) {
            DialogUtil.constrain(this._container, this._wwnLabel, new GridBagConstraints(), 0, 2, 0, 14);
        }
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            JPanel panel = new JPanel(new BorderLayout(1, 2));
            int vsanId = ((SmPsmTableModel)this._table).getVsanId();
            MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
            Fabric f = mgmtDomain.getFabric();
            Vsan[] vsans = f.getVsansById(vsanId);
            ArrayList<Switch> swList = new ArrayList<Switch>();
            for (int i = 0; i < vsans.length; ++i) {
                SnmpPeer[] peersInVsan = vsans[i].getSnmpPeers();
                for (int j = 0; j < peersInVsan.length; ++j) {
                    Switch sw = ClientController.getInstance().getFabric().findSwitchByIpAddress(peersInVsan[j].getAddress());
                    if (sw == null) continue;
                    swList.add(sw);
                }
            }
            Switch[] sws = swList.toArray(new Switch[swList.size()]);
            if (sws != null) {
                this._list = new JList<Switch>(sws);
                this._list.addListSelectionListener(this);
                this._list.setSelectionMode(1);
                this._list.setCellRenderer(new SwitchWwnDmIdCellRenderer());
                JScrollPane sp = new JScrollPane(this._list);
                sp.setPreferredSize(new Dimension(300, 100));
                panel.add("Center", sp);
            }
            this._wwn = new KTextField();
            panel.add("South", this._wwn);
            return panel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1) {
            if (this._wwn.getText().length() == 0) {
                throw new Exception("Peer WWN: invalid entry");
            }
            return new SnmpWWN(this._wwn.getText(), false);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 1) {
            this._wwnLabel = new JLabel("<html><div align=right>Available<br>(Name,WWN,DomId)<br>Peer WWN:</html>", 4);
            return this._wwnLabel;
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = new int[]{1, ((SmPsmTableModel)this._table).getVsanId(), (int)((SnmpUnsignedInt)values[0]).getValue()};
        return index;
    }

    @Override
    protected void insertAction() throws Exception {
        super.insertAction();
        int curIndex = Integer.parseInt(this.getComponentText(0));
        this.setComponentText(0, Integer.toString(++curIndex));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Switch sw = (Switch)this._list.getSelectedValue();
        if (sw != null) {
            this._wwn.setText(SnmpString.toHexString(sw.getWwn().getValue()));
            short dmId = sw.getDomainId(((SmPsmTableModel)this._table).getVsanId());
            this.setComponentText(2, Integer.toString(dmId));
        }
    }

    @Override
    protected SnmpPDU getInsertPDU(SnmpPeer peer, VarBindList vbl) throws Exception {
        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
        boolean isVer30Above = sw.isVersionGreaterThanEqual("3.0(0)");
        VarBindList newVbl = new VarBindList();
        newVbl.copy(vbl, 0, vbl.size());
        if (!isVer30Above) {
            SnmpVarBind vbAdr = newVbl.get(newVbl.size() - 1);
            newVbl.remove(newVbl.size() - 1);
            int[] index = new int[]{1, ((SmPsmTableModel)this._table).getVsanId(), vbAdr.getIndex()};
            newVbl.add(new SnmpVarBind(new SnmpOID(_cpsmFabricBindDomIdOid, index), vbAdr.getVar()));
        }
        return new SnmpPDU(-93, newVbl);
    }

    class SwitchWwnDmIdCellRenderer
    extends DefaultListCellRenderer {
        SwitchWwnDmIdCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Switch sw = (Switch)value;
            StringBuffer buf = new StringBuffer();
            buf.append(sw.toString());
            buf.append(",");
            buf.append(sw.getWwn());
            buf.append(",");
            short dmId = sw.getDomainId(((SmPsmTableModel)SmInsertPsmFabricBind.this._table).getVsanId());
            buf.append(dmId);
            this.setText(buf.toString());
            return retValue;
        }
    }
}

